/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Deltree
extends Task {
    private File dir;

    public void execute() throws BuildException {
        this.log("Deleting: " + this.dir.getAbsolutePath());
        if (this.dir.exists()) {
            if (!this.dir.isDirectory()) {
                if (!this.dir.delete()) {
                    throw new BuildException("Unable to delete file " + this.dir.getAbsolutePath());
                }
                return;
            }
            try {
                this.removeDir(this.dir);
            }
            catch (IOException iOException) {
                String msg = "Unable to delete " + this.dir.getAbsolutePath();
                throw new BuildException(msg);
            }
        }
    }

    private void removeDir(File dir) throws IOException {
        String[] list = dir.list();
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            File f = new File(dir, s);
            if (f.isDirectory()) {
                this.removeDir(f);
            } else if (!f.delete()) {
                throw new BuildException("Unable to delete file " + f.getAbsolutePath());
            }
            ++i;
        }
        if (!dir.delete()) {
            throw new BuildException("Unable to delete directory " + dir.getAbsolutePath());
        }
    }

    public void setDir(String dirName) {
        this.dir = this.project.resolveFile(dirName);
    }
}

