
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools;

import java.applet.Applet;
import java.awt.*;

/**
 * Provides version information for BTools and the Java runtime.
 * This class also serves as a simple applet and application that will
 * display the version of Java currently being used.
 */
public class Version extends Applet {
    /**
     * The version number of this BTools release.
     */
    public static String btoolsVersion = "1.1";

    /**
     * Returns the version of Java currently being used.
     *
     * @return the version of Java being used, or <tt>null</tt> if the
     * Java version cannot be established.
     */
    public static String javaVersion() {
        try {
            String version = System.getProperty("java.version");
            if (version == null)
                return null;
            
            // We have a version string.
            // Some Java implementations omit the dot.
            version = version.trim();
            if (version.indexOf('.') < 0 && version.length() > 0)
                version = version.charAt(0) + '.' + version.substring(1);
            return version;
        } catch (Throwable th) {
            return null;
        }
    }

    /**
     * Runs the application <tt>btools.Version</tt> which simply
     * writes to standard output the version of Java currently being
     * used.
     */
    public static void main(String[] args) {
        String version = javaVersion();
        if (version == null)
            System.out.println("Java version cannot be established.");
        else
            System.out.println("Java version " + version);
    }

    /**
     * Initialises the applet <tt>btools.Version</tt> which simply
     * displays the version of Java currently being used.
     */
    public void init() {
        setLayout(new GridLayout(0, 1));
        String version = javaVersion();
        if (version == null)
            add(new Label("Java version cannot be established.",
                Label.CENTER));
        else
            add(new Label("Java version " + version, Label.CENTER));
    }

    /**
     * Returns a description of this applet.
     *
     * @return a description of this applet.
     */
    public String getAppletInfo() {
        return "Java version information";
    }

    /**
     * Returns details of the available applet parameters.
     *
     * @return applet parameter details.
     */
    public String[][] getParameterInfo() {
        String[][] info = { };
        return info;
    }
}

