/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Version;

public class SymbolUtilities {
    private SymbolUtilities() {
    }

    public static String getOutermostPackage(String fqn) {
        int index = fqn.indexOf(".");
        if (index < 0) {
            return fqn;
        }
        return fqn.substring(0, index);
    }

    public static String getParentPackage(String fqn) {
        int index = fqn.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        return fqn.substring(0, index);
    }

    public static boolean hasParentPackage(SymbolID id) {
        boolean has_parent = SymbolUtilities.getParentPackage(id.getFullName()) != null;
        return has_parent;
    }

    public static boolean hasParentPackage(String fqn) {
        boolean has_parent = SymbolUtilities.getParentPackage(fqn) != null;
        return has_parent;
    }

    public static boolean sameVersionAsParent(SymbolID id) {
        Symbol psym;
        boolean same_version = false;
        String pname = SymbolUtilities.getParentPackage(id.getFullName());
        if (pname != null && (psym = SymbolTable.getInstance().lookupSymbol(pname)) != null) {
            Version pvers = psym.getSymbolID().getVersion();
            same_version = pvers.isSame(id.getVersion());
        }
        return same_version;
    }

    public static boolean sameVersionAsParent(String fqn) {
        Symbol psym;
        String pname;
        boolean same_version = false;
        SymbolTable symtable = SymbolTable.getInstance();
        Symbol ssym = symtable.lookupSymbol(fqn);
        if (ssym != null && (pname = SymbolUtilities.getParentPackage(fqn)) != null && (psym = symtable.lookupSymbol(pname)) != null) {
            Version pvers = psym.getSymbolID().getVersion();
            same_version = pvers.isSame(ssym.getSymbolID().getVersion());
        }
        return same_version;
    }

    public static Version getVersion(String name) {
        Symbol sym;
        Version vers = null;
        if (name != null && (sym = SymbolTable.getInstance().lookupSymbol(name)) != null) {
            vers = sym.getSymbolID().getVersion();
        }
        return vers;
    }

    public static Version getParentVersion(String fqn) {
        return SymbolUtilities.getVersion(SymbolUtilities.getParentPackage(fqn));
    }

    public static boolean isBaseException(SymbolID id) {
        boolean is_base = false;
        String name = id.getFullName();
        if (name.equals(BabelConfiguration.getBaseExceptionInterface()) || name.equals(BabelConfiguration.getBaseExceptionClass())) {
            is_base = true;
        }
        return is_base;
    }

    public static boolean isBase(SymbolID id) {
        boolean is_base = false;
        String name = id.getFullName();
        if (SymbolUtilities.isBaseException(id) || name.equals(BabelConfiguration.getBaseClass()) || name.equals(BabelConfiguration.getBaseInterface())) {
            is_base = true;
        }
        return is_base;
    }

    public static String getSymbolName(SymbolID fid, SymbolID sid) {
        String name = null;
        String flname = fid.getFullName();
        if (SymbolUtilities.isBase(fid)) {
            name = SymbolUtilities.isBase(sid) ? fid.getShortName() : flname;
        } else {
            String fpkg = SymbolUtilities.getParentPackage(flname);
            String spkg = SymbolUtilities.getParentPackage(sid.getFullName());
            name = fpkg != null && spkg != null ? (fpkg.equals(spkg) ? fid.getShortName() : flname) : flname;
        }
        return name;
    }

    public static String getSymbolName(String full_name, String pkg) {
        String name = null;
        if (full_name != null && pkg != null) {
            String fpkg = SymbolUtilities.getParentPackage(full_name);
            name = fpkg != null ? (fpkg.equals(pkg) ? SymbolID.getShortName(full_name) : full_name) : full_name;
        }
        return name;
    }

    public static String getVersionString(String vers) {
        String out = null;
        if (!vers.equals("0") && vers != null) {
            out = "version " + vers;
        }
        return out;
    }

    public static String getVersionString(SymbolID id) {
        return SymbolUtilities.getVersionString(id.getVersion().getVersionString());
    }
}

