/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.python;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.python.PythonServerCSource;
import gov.llnl.babel.backend.python.PythonServerLaunch;
import gov.llnl.babel.backend.python.PythonServerPySource;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenPythonServer
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        SymbolTable table = SymbolTable.getInstance();
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            switch (symbol.getSymbolType()) {
                case 12: {
                    this.generateClass((Class)symbol);
                }
            }
        }
    }

    private void generateClass(Class cls) throws CodeGenerationException {
        PythonServerCSource source = new PythonServerCSource(cls);
        PythonServerLaunch launch = new PythonServerLaunch(cls);
        PythonServerPySource pySource = new PythonServerPySource(cls);
        source.generateCode();
        launch.generateCode();
        pySource.generateCode();
    }

    public String getType() {
        return "skel";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("python");
        return result;
    }
}

