/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.c.ImplHeader;
import gov.llnl.babel.backend.c.StubSource;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.util.Iterator;

public class ImplSource {
    private CodeSplicer d_splicer;
    private LanguageWriterForC d_writer;

    public ImplSource(LanguageWriterForC writer, CodeSplicer splicer) {
        this.d_splicer = splicer;
        this.d_writer = writer;
    }

    public static void generateCode(Class cls, LanguageWriterForC writer, CodeSplicer splicer) throws CodeGenerationException {
        ImplSource source = new ImplSource(writer, splicer);
        source.generateCode(cls);
    }

    private void writePrologue(Class cls) {
        SymbolID id = cls.getSymbolID();
        String header = C.getImplSourceFile(id);
        this.d_writer.writeBanner(cls, header, true, "Server-side implementation for " + id.getFullName());
        this.d_writer.beginBlockComment(false);
        this.d_writer.println("DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS");
        this.d_writer.println("FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.");
        this.d_writer.endBlockComment(false);
        this.d_writer.writeComment(cls, false);
    }

    private void writeIncludeSection(Class cls) {
        SymbolID id = cls.getSymbolID();
        String includes = id.getFullName() + "." + "_includes";
        this.d_writer.generateInclude(C.getImplHeaderFile(id), false);
        this.d_writer.println();
        this.d_splicer.splice(includes, this.d_writer, "includes and arbitrary code");
        this.d_writer.println();
    }

    private void writeMethodBody(SymbolID id, String name, String desc) {
        String splicerTag = id.getFullName() + '.' + name;
        this.d_splicer.splice(splicerTag, this.d_writer, desc + " method");
    }

    private void writeMethodShell(Method m, SymbolID id, String desc, String suffix) throws CodeGenerationException {
        boolean isOrig = suffix.equals("");
        String name = m.getLongMethodName() + suffix;
        String method_name = C.getMethodImplName(id, name);
        if (isOrig) {
            this.d_writer.writeComment(m, false);
        } else {
            this.d_writer.writeComment(method_name + ": Interceptor implementation.", false);
        }
        this.d_writer.printlnUnformatted("#undef __FUNC__");
        this.d_writer.printlnUnformatted("#define __FUNC__ \"" + method_name + "\"");
        this.d_writer.println();
        ImplHeader.writeMethodSignature(this.d_writer, m, suffix, "self", false, false, true, id);
        this.d_writer.println();
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.writeMethodBody(id, name, desc);
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private void writeBuiltinMethods(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        StubSource.generateSupers(cls.getOverwrittenClassMethods(), cls, this.d_writer);
        this.writeMethodShell(IOR.getBuiltinMethod(5, id), id, "static class initializer", "");
        this.writeMethodShell(IOR.getBuiltinMethod(3, id), id, "constructor", "");
        this.d_writer.println();
        this.writeMethodShell(IOR.getBuiltinMethod(4, id), id, "destructor", "");
        if (IOR.supportAssertions(cls)) {
            if (cls.hasStaticMethod(true)) {
                this.d_writer.println();
                this.writeMethodShell(IOR.getBuiltinMethod(8, id, true), id, "check_error_static", "");
            }
            this.d_writer.println();
            this.writeMethodShell(IOR.getBuiltinMethod(8, id), id, "check_error", "");
        }
    }

    private void writeMethods(Class cls, boolean isStatic) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        Iterator i = null;
        i = isStatic ? cls.getStaticMethods(false).iterator() : cls.getNonstaticMethods(false).iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.d_writer.println();
            if (IOR.supportInterceptors(cls)) {
                this.writeMethodShell(m, id, m.getLongMethodName(), "_pre");
                this.d_writer.println();
                this.writeMethodShell(m, id, m.getLongMethodName(), "");
                this.d_writer.println();
                this.writeMethodShell(m, id, m.getLongMethodName(), "_post");
                continue;
            }
            this.writeMethodShell(m, id, m.getLongMethodName(), "");
        }
    }

    public void generateCode(Class cls) throws CodeGenerationException {
        SymbolID id = cls.getSymbolID();
        this.writePrologue(cls);
        this.writeIncludeSection(cls);
        this.writeBuiltinMethods(cls);
        this.writeMethods(cls, true);
        this.writeMethods(cls, false);
        if (this.d_splicer.hasUnusedSymbolEdits()) {
            this.d_writer.println();
            this.d_writer.printlnUnformatted("#error File has unused splicer blocks.");
            this.d_writer.beginBlockComment(true);
            this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
            this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
            this.d_writer.println("This can result from a method rename/removal in the sidl file.");
            this.d_writer.println("Move or remove the code in order to compile cleanly.");
            this.d_writer.endBlockComment(true);
            this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
            this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
        }
    }
}

