/*
 * Created on 6 sept. 2003
 *
 */
package org.gudy.azureus2.irc;

import org.jibble.pircbot.Colors;
import org.jibble.pircbot.PircBot;
import org.jibble.pircbot.User;

import org.gudy.azureus2.plugins.*;
import org.gudy.azureus2.plugins.utils.*;

/**
 * @author Olivier
 * 
 */

public class 
IrcClient 
	extends PircBot 
{
	public static final String	CONFIG_IRC_SERVER 			= "Irc Server";
	public static final String	CONFIG_IRC_SERVER_DEFAULT	= "irc.freenode.net";
	
	public static final String	CONFIG_IRC_CHANNEL			= "Irc Channel";
	public static final String	CONFIG_IRC_CHANNEL_DEFAULT	= "#azureus-users";
	
	public static final String	CONFIG_IRC_USER				= "Irc Login";
	public static final String	CONFIG_IRC_USER_DEFAULT		= "";
	
	private PluginInterface		plugin_interface;
	private LocaleUtilities 	locale_utils;
	
  private String srvName;
  private String channel;

  private IrcListener listener;
  private String userName;

  public 
  IrcClient(
  	PluginInterface	_plugin_interface,
	IrcListener 	_listener)
  {    
  	plugin_interface	= _plugin_interface;
	
  	locale_utils = plugin_interface.getUtilities().getLocaleUtilities();
 	
  	PluginConfig config = plugin_interface.getPluginconfig();
  	
    this.srvName 	= config.getPluginStringParameter(CONFIG_IRC_SERVER, CONFIG_IRC_SERVER_DEFAULT );
    this.channel 	= config.getPluginStringParameter(CONFIG_IRC_CHANNEL,CONFIG_IRC_CHANNEL_DEFAULT );
    this.userName 	= config.getPluginStringParameter(CONFIG_IRC_USER, 	 CONFIG_IRC_USER_DEFAULT);    
    
    this.setName(userName);
    this.listener = _listener;
    if(userName.equals("")) {
        listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.noNick"));
        return;
    }
    setLogin("Azureus");
    Thread t = new Thread() {
      /* (non-Javadoc)
       * @see java.lang.Thread#run()
       */
      public void run() {
        try {                  
          listener.systemMessage("");  
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.copyright"));
          listener.systemMessage("");
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.connecting") + " " + srvName);
          connect(srvName);
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.connected") + " " + srvName);
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.joining") + " " + channel);
          joinChannel(channel);
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.channel") + " " + channel + " " +  locale_utils.getLocalisedMessageText("IrcClient.joined"));
        }
        catch (Exception e) {
          //e.printStackTrace();
          listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.error") + " : " + e.getMessage());
        }
      }
    };
    t.setDaemon(true);
    t.start();
  }
  
  protected void onMessage(String channel, String sender, String login, String hostname, String message) {
    if(listener != null) {
      listener.messageReceived(sender,Colors.removeFormattingAndColors(message));
    }
  }
  
  public void close() {    
    super.quitServer( plugin_interface.getAzureusName() + " " + plugin_interface.getAzureusVersion());
    try {
      super.dispose();
    } catch(Exception e) {
      
    }
  }
  
  public void sendMessage(String message) {
    super.sendMessage(channel,message);
    listener.messageReceived(userName,message);
  }
  
  
  protected void onJoin(String channel, String sender, String login, String hostname) {
    listener.systemMessage(sender + " " + locale_utils.getLocalisedMessageText("IrcClient.hasjoined"));
    listener.clientEntered(sender);
  }
  
  protected void onKick(String channel, String kickerNick, String kickerLogin, String kickerHostname, String recipientNick, String reason) {
    listener.systemMessage(kickerNick + " " + locale_utils.getLocalisedMessageText("IrcClient.haskicked") + " " + recipientNick + " (" + reason + ").");
    listener.clientExited(recipientNick);
  }
  
  protected void onQuit(String sourceNick, String sourceLogin, String sourceHostname, String reason) {
    listener.systemMessage(sourceNick + " " + locale_utils.getLocalisedMessageText("IrcClient.hasleft") + " (" + reason + ").");
    listener.clientExited(sourceNick);
  }
  
  protected void onPart(String channel, String sender, String login, String hostname)  {
    listener.systemMessage(sender + " " + locale_utils.getLocalisedMessageText("IrcClient.hasleft"));
    listener.clientExited(sender);
  }
  
  
  protected void onNickChange(String oldNick, String login, String hostname, String newNick) 
  {
    listener.systemMessage(oldNick + " " + locale_utils.getLocalisedMessageText("IrcClient.nowknown") + " " + newNick);
    listener.clientExited(oldNick);
    listener.clientEntered(newNick);
  }
  
  protected void onAction(String sender, String login, String hostname, String target, String action) 
  {
    listener.action(sender,action);
  }
  
  /**
   * @return
   */
  public String getUserName() {
    return userName;
  }

  /**
   * @param userName
   */
  public void setUserName(String userName) {
    this.userName = userName;
    super.changeNick(userName);
  }
  
  public void sendAction(String action) {
    super.sendAction(channel,action);
  }
  
  protected void onUserList(String channel, User[] users) {
    if(! this.channel.equals(channel))
       return;
    for(int i = 0 ; i < users.length ;i++) {
      listener.clientEntered(users[i].getNick());
    }    
  }
  
  protected void onPrivateMessage(String sender, String login, String hostname, String message)
  {
    listener.privateMessage(sender,message);
  }
  
  protected void onNotice(String sourceNick, String sourceLogin, String sourceHostname, String target, String notice)
  {
    listener.notice(sourceNick,notice);
  } 
  
  protected void onServerResponse(int code, String response)  {
    //No such nick name:
    if(code == 401)
      listener.systemMessage(response);
  }
  
  protected void onTopic(String channel, String topic, String setBy, long date, boolean changed) {
    listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.topicforchannel") + " " + channel + " : " + topic);
  }
  
  protected void onDisconnect() {
    listener.systemMessage(locale_utils.getLocalisedMessageText("IrcClient.disconnected") + " " + srvName);
  }

  
  
  /**
   * @return
   */
  public String getChannel() {
    return channel;
  }

  /**
   * @return
   */
  public String getSrvName() {
    return srvName;
  }
  
  public void changeChannel(String channel) {
    partChannel(this.channel);    
    User[] users = super.getUsers(this.channel);
    for(int i=0 ; i< users.length ; i++) {
      listener.clientExited(users[i].getNick());
    }
    this.channel = channel;
    joinChannel(this.channel);
  }

}
