/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.pluginsimpl.local.ui.SWT.SWTManagerImpl;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PiecesItem
extends CoreTableColumn
implements TableCellAddedListener {
    private static final int INDEX_COLOR_FADEDSTARTS = 10;
    private static final int borderHorizontalSize = 1;
    private static final int borderVerticalSize = 1;
    private static final int borderSplit = 1;
    private static final int completionHeight = 2;

    public PiecesItem() {
        super("pieces", "Peers");
        this.initializeAsGraphic(-2, 200);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    implements TableCellRefreshListener,
    TableCellDisposeListener {
        public Cell(TableCell cell) {
            cell.setFillCell(true);
            cell.addRefreshListener(this);
            cell.addDisposeListener(this);
        }

        public void dispose(TableCell cell) {
            cell.setGraphic(null);
            PEPeer infoObj = (PEPeer)cell.getDataSource();
            if (infoObj == null) {
                return;
            }
            Image img = (Image)infoObj.getData("PiecesImage");
            if (img != null && !img.isDisposed()) {
                img.dispose();
            }
            infoObj.setData("PiecesImageBuffer", null);
            infoObj.setData("PiecesImage", null);
        }

        public void refresh(TableCell cell) {
            GC gcImage;
            Rectangle imageBounds;
            boolean bImageChanged;
            Image image;
            PEPeer infoObj = (PEPeer)cell.getDataSource();
            long lCompleted = infoObj == null ? 0 : infoObj.getPercentDoneInThousandNotation();
            if (!cell.setSortValue(lCompleted) && cell.isValid()) {
                return;
            }
            if (infoObj == null) {
                return;
            }
            int newWidth = cell.getWidth();
            if (newWidth <= 0) {
                return;
            }
            int newHeight = cell.getHeight();
            DownloadManager dm = infoObj.getManager().getDownloadManager();
            int x0 = 1;
            int x1 = newWidth - 1 - 1;
            int y0 = 4;
            int y1 = newHeight - 1 - 1;
            int drawWidth = x1 - x0 + 1;
            if (drawWidth < 10 || y1 < 3) {
                return;
            }
            boolean bImageBufferValid = true;
            int[] imageBuffer = (int[])infoObj.getData("PiecesImageBuffer");
            if (imageBuffer == null || imageBuffer.length != drawWidth) {
                imageBuffer = new int[drawWidth];
                bImageBufferValid = false;
            }
            if ((image = (Image)infoObj.getData("PiecesImage")) == null || image.isDisposed()) {
                bImageChanged = true;
            } else {
                imageBounds = image.getBounds();
                boolean bl = bImageChanged = imageBounds.width != newWidth || imageBounds.height != newHeight;
            }
            if (bImageChanged) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                image = new Image((Device)SWTManagerImpl.getSingleton().getDisplay(), newWidth, newHeight);
                imageBounds = image.getBounds();
                bImageBufferValid = false;
                gcImage = new GC((Drawable)image);
                gcImage.setForeground(Colors.grey);
                gcImage.drawRectangle(0, 0, newWidth - 1, newHeight - 1);
                gcImage.setForeground(Colors.white);
                gcImage.drawLine(x0, 3, x1, 3);
            } else {
                gcImage = new GC((Drawable)image);
            }
            boolean[] available = infoObj.getAvailable();
            if (available != null && available.length > 0) {
                try {
                    int limit;
                    DiskManager disk_manager = dm.getDiskManager();
                    DiskManagerPiece[] pieces = disk_manager == null ? null : disk_manager.getPieces();
                    int nbComplete = 0;
                    int nbPieces = available.length;
                    int a1 = 0;
                    int i = 0;
                    while (i < drawWidth) {
                        int index;
                        int a0;
                        if (i == 0) {
                            a0 = 0;
                            a1 = nbPieces / drawWidth;
                            if (a1 == 0) {
                                a1 = 1;
                            }
                        } else {
                            a0 = a1;
                            a1 = (i + 1) * nbPieces / drawWidth;
                        }
                        int nbNeeded = 0;
                        if (a1 <= a0) {
                            index = imageBuffer[i - 1];
                        } else {
                            int nbAvailable = 0;
                            int j = a0;
                            while (j < a1) {
                                if (available[j]) {
                                    if (pieces == null | !pieces[j].getDone()) {
                                        ++nbNeeded;
                                    }
                                    ++nbAvailable;
                                }
                                ++j;
                            }
                            nbComplete += nbAvailable;
                            index = nbAvailable * 9 / (a1 - a0);
                            if (nbNeeded <= nbAvailable / 2) {
                                index += 10;
                            }
                        }
                        if (imageBuffer[i] != index) {
                            imageBuffer[i] = index;
                            if (bImageBufferValid) {
                                bImageChanged = true;
                                if (imageBuffer[i] >= 10) {
                                    gcImage.setForeground(Colors.faded[index - 10]);
                                } else {
                                    gcImage.setForeground(Colors.blues[index]);
                                }
                                gcImage.drawLine(i + x0, y0, i + x0, y1);
                            }
                        }
                        ++i;
                    }
                    if (!bImageBufferValid) {
                        int iLastIndex = imageBuffer[0];
                        int iWidth = 1;
                        int i2 = 1;
                        while (i2 < drawWidth) {
                            if (iLastIndex == imageBuffer[i2]) {
                                ++iWidth;
                            } else {
                                if (iLastIndex >= 10) {
                                    gcImage.setBackground(Colors.faded[iLastIndex - 10]);
                                } else {
                                    gcImage.setBackground(Colors.blues[iLastIndex]);
                                }
                                gcImage.fillRectangle(i2 - iWidth + x0, y0, iWidth, y1 - y0 + 1);
                                iWidth = 1;
                                iLastIndex = imageBuffer[i2];
                            }
                            ++i2;
                        }
                        if (iLastIndex >= 10) {
                            gcImage.setBackground(Colors.faded[iLastIndex - 10]);
                        } else {
                            gcImage.setBackground(Colors.blues[iLastIndex]);
                        }
                        gcImage.fillRectangle(x1 - iWidth + 1, y0, iWidth, y1 - y0 + 1);
                        bImageChanged = true;
                    }
                    if ((limit = drawWidth * nbComplete / nbPieces) < drawWidth) {
                        gcImage.setBackground(Colors.blues[0]);
                        gcImage.fillRectangle(limit + x0, 1, x1 - limit, 2);
                    }
                    gcImage.setBackground(Colors.colorProgressBar);
                    gcImage.fillRectangle(x0, 1, limit, 2);
                }
                catch (Exception e) {
                    System.out.println("Error Drawing PiecesItem");
                    Debug.printStackTrace(e);
                }
            }
            gcImage.dispose();
            Image oldImage = ((TableCellCore)cell).getGraphicSWT();
            if (bImageChanged || image != oldImage || !cell.isValid()) {
                ((TableCellCore)cell).setGraphic(image);
                infoObj.setData("PiecesImage", image);
                infoObj.setData("PiecesImageBuffer", imageBuffer);
            }
        }
    }
}

