/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class RemainingPiecesItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public RemainingPiecesItem() {
        super("remaining", 2, -2, 60, "Files");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        int remaining = 0;
        if (fileInfo2 != null) {
            int start = fileInfo2.getFirstPieceNumber();
            int end = start + fileInfo2.getNbPieces();
            DiskManagerPiece[] pieces = fileInfo2.getDiskManager().getPieces();
            int i = start;
            while (i < end) {
                if (!pieces[i].getDone()) {
                    ++remaining;
                }
                ++i;
            }
        }
        if (!cell.setSortValue(remaining) && cell.isValid()) {
            return;
        }
        cell.setText("" + remaining);
    }
}

