/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.stats.ActivityView;
import org.gudy.azureus2.ui.swt.views.stats.CacheView;
import org.gudy.azureus2.ui.swt.views.stats.TransferStatsView;

public class StatsView
extends AbstractIView {
    GlobalManager manager;
    TabFolder folder;
    TabItem itemActivity;
    TabItem itemStats;
    TabItem itemCache;
    IView viewActivity;
    IView viewStats;
    IView viewCache;
    UpdateThread updateThread;

    public StatsView(GlobalManager manager) {
        this.manager = manager;
    }

    public void initialize(Composite composite) {
        this.folder = new TabFolder(composite, 16384);
        this.folder.setBackground(Colors.background);
        this.itemActivity = new TabItem(this.folder, 0);
        this.itemStats = new TabItem(this.folder, 0);
        this.itemCache = new TabItem(this.folder, 0);
        this.viewActivity = new ActivityView(this.manager);
        this.viewStats = new TransferStatsView(this.manager);
        this.viewCache = new CacheView();
        Messages.setLanguageText((Widget)this.itemActivity, this.viewActivity.getData());
        Messages.setLanguageText((Widget)this.itemStats, this.viewStats.getData());
        Messages.setLanguageText((Widget)this.itemCache, this.viewCache.getData());
        TabItem[] items = new TabItem[]{this.itemActivity};
        this.folder.setSelection(items);
        this.viewActivity.initialize((Composite)this.folder);
        this.itemActivity.setControl((Control)this.viewActivity.getComposite());
        this.viewStats.initialize((Composite)this.folder);
        this.itemStats.setControl((Control)this.viewStats.getComposite());
        this.viewCache.initialize((Composite)this.folder);
        this.itemCache.setControl((Control)this.viewCache.getComposite());
        this.folder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StatsView.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refresh();
        this.viewActivity.getComposite().layout(true);
        this.updateThread = new UpdateThread();
        this.updateThread.setDaemon(true);
        this.updateThread.start();
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        try {
            switch (this.folder.getSelectionIndex()) {
                case 0: {
                    if (this.viewActivity == null || this.itemActivity.isDisposed()) break;
                    this.viewActivity.refresh();
                    break;
                }
                case 1: {
                    if (this.viewStats == null || this.itemStats.isDisposed()) break;
                    this.viewStats.refresh();
                    break;
                }
                case 2: {
                    if (this.viewCache == null || this.itemCache.isDisposed()) break;
                    this.viewCache.refresh();
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public Composite getComposite() {
        return this.folder;
    }

    public String getFullTitle() {
        return MessageText.getString("Stats.title.full");
    }

    public void delete() {
        this.updateThread.stopIt();
        MainWindow.getWindow().setStats(null);
        if (Constants.isOSX && this.folder != null && !this.folder.isDisposed()) {
            TabItem[] items = this.folder.getItems();
            int i = 0;
            while (i < items.length) {
                if (!items[i].isDisposed()) {
                    items[i].dispose();
                }
                ++i;
            }
        }
        this.viewActivity.delete();
        this.viewStats.delete();
        this.viewCache.delete();
        if (!this.folder.isDisposed()) {
            Utils.disposeComposite((Composite)this.folder);
        }
    }

    private class UpdateThread
    extends Thread {
        boolean bContinue;

        UpdateThread() {
        }

        public void run() {
            try {
                this.bContinue = true;
                while (this.bContinue) {
                    ((ActivityView)StatsView.this.viewActivity).periodicUpdate();
                    ((CacheView)StatsView.this.viewCache).periodicUpdate();
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }

        public void stopIt() {
            this.bContinue = false;
        }
    }
}

