/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import com.aelitis.azureus.core.AzureusCore;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.update.UpdateManagerListener;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;
import org.gudy.azureus2.update.CoreUpdateChecker;

public class UpdateMonitor
implements UpdateCheckInstanceListener {
    public static final long AUTO_UPDATE_CHECK_PERIOD = 82800000L;
    protected static UpdateMonitor singleton;
    protected static AEMonitor class_mon;
    protected AzureusCore azureus_core;
    protected UpdateWindow current_update_window;
    protected UpdateCheckInstance current_update_instance;
    static /* synthetic */ Class class$0;

    static {
        class_mon = new AEMonitor("UpdateMonitor:class");
    }

    public static UpdateMonitor getSingleton(AzureusCore core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UpdateMonitor(core);
            }
            UpdateMonitor updateMonitor = singleton;
            class_mon.exit();
            return updateMonitor;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected UpdateMonitor(AzureusCore _azureus_core) {
        this.azureus_core = _azureus_core;
        UpdateManager um = this.azureus_core.getPluginManager().getDefaultPluginInterface().getUpdateManager();
        um.addListener(new UpdateManagerListener(){

            public void checkInstanceCreated(UpdateCheckInstance instance) {
                instance.addListener(UpdateMonitor.this);
            }
        });
        SimpleTimer.addPeriodicEvent(82800000L, new TimerEventPerformer(){

            public void perform(TimerEvent ev) {
                UpdateMonitor.this.performAutoCheck(false);
            }
        });
        new DelayedEvent(2500L, new AERunnable(){

            public void runSupport() {
                UpdateMonitor.this.performAutoCheck(true);
            }
        });
    }

    protected void performAutoCheck(final boolean start_of_day) {
        boolean check_at_start = false;
        boolean check_periodic = false;
        if (!SystemProperties.isJavaWebStartInstance()) {
            check_at_start = COConfigurationManager.getBooleanParameter("update.start", true);
            check_periodic = COConfigurationManager.getBooleanParameter("update.periodic", true);
        }
        boolean bl = check_at_start = check_at_start || check_periodic;
        if (check_at_start && start_of_day || check_periodic && !start_of_day) {
            this.performCheck();
        } else {
            new DelayedEvent(5000L, new AERunnable(){

                public void runSupport() {
                    if (start_of_day) {
                        MainWindow mainWindow = MainWindow.getWindow();
                        mainWindow.setStatusText("Azureus 2.2.0.2 / MainWindow.status.latestversionunchecked");
                    }
                    CoreUpdateChecker.doUsageStats();
                }
            });
        }
    }

    public void performCheck() {
        if (SystemProperties.isJavaWebStartInstance()) {
            LGLogger.log("skipping update check as java web start");
            return;
        }
        if (this.current_update_window != null && !this.current_update_window.isDisposed()) {
            SWTThread.getInstance().getDisplay().syncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    UpdateMonitor.this.current_update_window.dispose();
                }
            });
        }
        if (this.current_update_instance != null) {
            this.current_update_instance.cancel();
        }
        MainWindow mainWindow = MainWindow.getWindow();
        mainWindow.setStatusText("Azureus 2.2.0.2 / MainWindow.status.checking ...");
        UpdateManager um = this.azureus_core.getPluginManager().getDefaultPluginInterface().getUpdateManager();
        this.current_update_instance = um.createUpdateCheckInstance(2, "update.instance.update");
        this.current_update_instance.start();
    }

    public void complete(UpdateCheckInstance instance) {
        boolean update_action;
        boolean bl = update_action = instance.getType() == 2;
        if (update_action) {
            PluginManager pluginManager = this.azureus_core.getPluginManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.gudy.azureus2.update.CoreUpdateChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PluginInterface core_plugin = pluginManager.getPluginInterfaceByClass(clazz);
            String latest_version = core_plugin.getPluginProperties().getProperty("latest_version");
            MainWindow mainWindow = MainWindow.getWindow();
            mainWindow.setStatusText("Azureus 2.2.0.2 / MainWindow.status.latestversion " + (latest_version == null ? "Unknown" : latest_version));
        }
        Update[] us = instance.getUpdates();
        boolean show_window = false;
        int i = 0;
        while (i < us.length) {
            if (us[i].getDownloaders().length > 0) {
                show_window = true;
                break;
            }
            ++i;
        }
        if (show_window) {
            UpdateWindow this_window = null;
            if (update_action) {
                if (this.current_update_window == null || this.current_update_window.isDisposed()) {
                    this_window = this.current_update_window = new UpdateWindow(this.azureus_core, instance);
                }
            } else {
                this_window = new UpdateWindow(this.azureus_core, instance);
            }
            if (this_window != null) {
                int i2 = 0;
                while (i2 < us.length) {
                    if (us[i2].getDownloaders().length > 0) {
                        this_window.addUpdate(us[i2]);
                    }
                    ++i2;
                }
                this_window.updateAdditionComplete();
            } else {
                LGLogger.log("UpdateMonitor: user dialog already in progress, updates skipped");
            }
        } else {
            LGLogger.log("UpdateMonitor: check instance resulted in no user-actionable updates");
        }
    }

    public void cancelled(UpdateCheckInstance instance) {
        MainWindow mainWindow = MainWindow.getWindow();
        mainWindow.setStatusText("Azureus 2.2.0.2 / MainWindow.status.latestversion Unknown");
    }
}

