/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;

public abstract class BufferedTableItem {
    private BufferedTableRow row;
    private int position;
    private Color ourFGColor = null;

    public BufferedTableItem(BufferedTableRow row, int position) {
        this.row = row;
        this.position = position;
    }

    public String getText() {
        if (this.position != -1) {
            return this.row.getText(this.position);
        }
        return "";
    }

    public boolean setText(String text) {
        if (this.position != -1) {
            return this.row.setText(this.position, text);
        }
        return false;
    }

    public void setImage(Image img) {
        if (this.position != -1) {
            this.row.setImage(this.position, img);
        }
    }

    public void setRowForeground(Color color) {
        this.row.setForeground(color);
    }

    public boolean setItemForeground(Color color) {
        boolean ok;
        if (this.position == -1) {
            return false;
        }
        if (this.ourFGColor != null) {
            Color oldColor = this.row.getForeground(this.position);
            ok = this.row.setForeground(this.position, color);
            if (ok) {
                if (!color.isDisposed()) {
                    color.dispose();
                }
                this.ourFGColor = null;
            }
        } else {
            ok = this.row.setForeground(this.position, color);
        }
        return ok;
    }

    public boolean setItemForeground(int red, int green, int blue) {
        if (this.position == -1) {
            return false;
        }
        Color oldColor = this.row.getForeground(this.position);
        RGB newRGB = new RGB(red, green, blue);
        if (oldColor.getRGB().equals((Object)newRGB)) {
            return false;
        }
        Color newColor = new Color((Device)this.row.getItem().getDisplay(), newRGB);
        boolean ok = this.row.setForeground(this.position, newColor);
        if (ok) {
            if (this.ourFGColor != null && !this.ourFGColor.isDisposed()) {
                this.ourFGColor.dispose();
            }
            this.ourFGColor = newColor;
        } else if (!newColor.isDisposed()) {
            newColor.dispose();
        }
        return ok;
    }

    public Color getBackground() {
        return this.row.getBackground();
    }

    public Rectangle getBounds() {
        if (this.position != -1) {
            return this.row.getBounds(this.position);
        }
        return null;
    }

    public Table getTable() {
        return this.row.getTable();
    }

    public TableItem getTableItem() {
        return this.row.getItem();
    }

    public abstract void refresh();

    public void dispose() {
        if (this.ourFGColor != null && !this.ourFGColor.isDisposed()) {
            this.ourFGColor.dispose();
        }
    }

    public boolean isShown() {
        return this.position != -1;
    }

    public boolean needsPainting() {
        return false;
    }

    public void doPaint(GC gc) {
    }

    public void locationChanged() {
    }

    public int getPosition() {
        return this.position;
    }

    public String getColumnName() {
        if (!this.isShown()) {
            return null;
        }
        Table table = this.row.getTable();
        if (table != null && !table.isDisposed() && this.position >= 0 && this.position < table.getColumnCount()) {
            return table.getColumn(this.position).getText();
        }
        return null;
    }

    public void debugOut(String s, boolean bStackTrace) {
        Table table = this.row.getTable();
        if (table == null || table.isDisposed()) {
            return;
        }
        TableItem[] ti = table.getSelection();
        int i = 0;
        while (i < ti.length) {
            if (ti[i] == this.row.getItem()) {
                System.out.println(String.valueOf(i) + "-" + ti[i] + ": " + s);
                if (!bStackTrace) break;
                Debug.outStackTrace(3);
                break;
            }
            ++i;
        }
    }
}

