/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.auth;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;

public class CertificateCreatorWindow {
    public CertificateCreatorWindow() {
        this.createCertificate();
    }

    public void createCertificate() {
        final Display display = MainWindow.getWindow().getDisplay();
        if (display.isDisposed()) {
            return;
        }
        try {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    new createDialog(display);
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected class createDialog {
        protected Shell shell;

        protected createDialog(Display display) {
            if (display.isDisposed()) {
                return;
            }
            this.shell = new Shell(display, 67680);
            if (!Constants.isOSX) {
                this.shell.setImage(ImageRepository.getImage("azureus"));
            }
            this.shell.setText(MessageText.getString("security.certcreate.title"));
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            this.shell.setLayout((Layout)layout);
            Label info_label = new Label((Composite)this.shell, 0);
            info_label.setText(MessageText.getString("security.certcreate.intro"));
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 3;
            info_label.setLayoutData((Object)gridData);
            Label alias_label = new Label((Composite)this.shell, 0);
            alias_label.setText(MessageText.getString("security.certcreate.alias"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            alias_label.setLayoutData((Object)gridData);
            Text alias_field = new Text((Composite)this.shell, 2048);
            alias_field.setText("Azureus");
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            alias_field.setLayoutData((Object)gridData);
            Label strength_label = new Label((Composite)this.shell, 0);
            strength_label.setText(MessageText.getString("security.certcreate.strength"));
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            strength_label.setLayoutData((Object)gridData);
            Combo strength_combo = new Combo((Composite)this.shell, 12);
            int[] strengths = new int[]{512, 1024, 1536, 2048};
            int i = 0;
            while (i < strengths.length) {
                strength_combo.add("" + strengths[i]);
                ++i;
            }
            strength_combo.select(1);
            Label label = new Label((Composite)this.shell, 0);
            String[] field_names = new String[]{"security.certcreate.firstlastname", "security.certcreate.orgunit", "security.certcreate.org", "security.certcreate.city", "security.certcreate.state", "security.certcreate.country"};
            String[] field_rns = new String[]{"CN", "OU", "O", "L", "ST", "C"};
            Text[] fields = new Text[field_names.length];
            int i2 = 0;
            while (i2 < fields.length) {
                Label resource_label = new Label((Composite)this.shell, 0);
                resource_label.setText(MessageText.getString(field_names[i2]));
                gridData = new GridData(1808);
                gridData.horizontalSpan = 1;
                resource_label.setLayoutData((Object)gridData);
                Text field = fields[i2] = new Text((Composite)this.shell, 2048);
                gridData = new GridData(1808);
                gridData.horizontalSpan = 2;
                field.setLayoutData((Object)gridData);
                ++i2;
            }
            Label labelSeparator = new Label((Composite)this.shell, 258);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            labelSeparator.setLayoutData((Object)gridData);
            new Label((Composite)this.shell, 0);
            Composite comp = new Composite((Composite)this.shell, 0);
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            comp.setLayoutData((Object)gridData);
            GridLayout layoutButtons = new GridLayout();
            layoutButtons.numColumns = 2;
            comp.setLayout((Layout)layoutButtons);
            Button bYes = new Button(comp, 8);
            bYes.setText(MessageText.getString("security.certcreate.ok"));
            gridData = new GridData(896);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 70;
            bYes.setLayoutData((Object)gridData);
            bYes.addListener(13, new Listener(this, alias_field, strengths, strength_combo, fields, field_rns){
                final /* synthetic */ createDialog this$1;
                private final /* synthetic */ Text val$alias_field;
                private final /* synthetic */ int[] val$strengths;
                private final /* synthetic */ Combo val$strength_combo;
                private final /* synthetic */ Text[] val$fields;
                private final /* synthetic */ String[] val$field_rns;
                {
                    this.this$1 = createDialog2;
                    this.val$alias_field = text;
                    this.val$strengths = nArray;
                    this.val$strength_combo = combo;
                    this.val$fields = textArray;
                    this.val$field_rns = stringArray;
                }

                public void handleEvent(Event e) {
                    String alias = this.val$alias_field.getText().trim();
                    int strength = this.val$strengths[this.val$strength_combo.getSelectionIndex()];
                    String dn = "";
                    int i = 0;
                    while (i < this.val$fields.length) {
                        String rn = this.val$fields[i].getText().trim();
                        if (rn.length() == 0) {
                            rn = "Unknown";
                        }
                        dn = String.valueOf(dn) + (dn.length() == 0 ? "" : ",") + this.val$field_rns[i] + "=" + rn;
                        ++i;
                    }
                    try {
                        SESecurityManager.createSelfSignedCertificate(alias, dn, strength);
                        this.this$1.close(true);
                        LGLogger.logUnrepeatableAlert(0, String.valueOf(MessageText.getString("security.certcreate.createok")) + "\n" + alias + ":" + strength + "\n" + dn + "\n" + SystemTime.getCurrentTime());
                    }
                    catch (Throwable f) {
                        LGLogger.logUnrepeatableAlert(String.valueOf(MessageText.getString("security.certcreate.createfail")) + "\n" + SystemTime.getCurrentTime(), f);
                    }
                }
            });
            Button bNo = new Button(comp, 8);
            bNo.setText(MessageText.getString("security.certcreate.cancel"));
            gridData = new GridData(128);
            gridData.grabExcessHorizontalSpace = false;
            gridData.widthHint = 70;
            bNo.setLayoutData((Object)gridData);
            bNo.addListener(13, new Listener(this){
                final /* synthetic */ createDialog this$1;
                {
                    this.this$1 = createDialog2;
                }

                public void handleEvent(Event e) {
                    this.this$1.close(false);
                }
            });
            this.shell.setDefaultButton(bYes);
            this.shell.addListener(31, new Listener(this){
                final /* synthetic */ createDialog this$1;
                {
                    this.this$1 = createDialog2;
                }

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        this.this$1.close(false);
                    }
                }
            });
            this.shell.pack();
            Utils.centreWindow(this.shell);
            this.shell.open();
        }

        protected void close(boolean ok) {
            this.shell.dispose();
        }
    }
}

