/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.associations;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerException;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;

public class AssociationChecker {
    protected PlatformManager platform;
    protected Display display;
    protected Shell shell;

    public static void checkAssociations() {
        try {
            PlatformManager platform = PlatformManagerFactory.getPlatformManager();
            if (platform != null && platform.getPlatformType() == 1 && COConfigurationManager.getBooleanParameter("config.interface.checkassoc", true) && !platform.isApplicationRegistered()) {
                new AssociationChecker(platform);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected AssociationChecker(PlatformManager _platform) {
        this.platform = _platform;
        this.display = MainWindow.getWindow().getDisplay();
        if (this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                AssociationChecker.this.check();
            }
        });
    }

    protected void check() {
        this.shell = new Shell(this.display, 67680);
        if (!Constants.isOSX) {
            this.shell.setImage(ImageRepository.getImage("azureus"));
        }
        this.shell.setText(MessageText.getString("dialog.associations.title"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.shell.setLayout((Layout)layout);
        Label user_label = new Label((Composite)this.shell, 0);
        user_label.setText(MessageText.getString("dialog.associations.prompt"));
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        user_label.setLayoutData((Object)gridData);
        Label label = new Label((Composite)this.shell, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "dialog.associations.askagain");
        final Button checkBox = new Button((Composite)this.shell, 32);
        checkBox.setSelection(true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gridData);
        Label labelSeparator = new Label((Composite)this.shell, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        label = new Label((Composite)this.shell, 0);
        Button bYes = new Button((Composite)this.shell, 8);
        bYes.setText(MessageText.getString("Button.yes"));
        gridData = new GridData(896);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 70;
        bYes.setLayoutData((Object)gridData);
        bYes.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AssociationChecker.this.close(true, checkBox.getSelection());
            }
        });
        Button bNo = new Button((Composite)this.shell, 8);
        bNo.setText(MessageText.getString("Button.no"));
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        bNo.setLayoutData((Object)gridData);
        bNo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AssociationChecker.this.close(false, checkBox.getSelection());
            }
        });
        this.shell.setDefaultButton(bYes);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    AssociationChecker.this.close(false, true);
                }
            }
        });
        this.shell.pack();
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    protected void close(boolean ok, boolean check_on_startup) {
        if (check_on_startup != COConfigurationManager.getBooleanParameter("config.interface.checkassoc", true)) {
            COConfigurationManager.setParameter("config.interface.checkassoc", check_on_startup);
            COConfigurationManager.save();
        }
        if (ok) {
            try {
                this.platform.registerApplication();
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        this.shell.dispose();
    }
}

