/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import java.io.IOException;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.LocaleUtilSWT;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.StartSocket;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;

public class Main {
    public static final String PR_MULTI_INSTANCE = "MULTI_INSTANCE";
    StartServer startServer;

    public Main(String[] args) {
        try {
            String mi_str = System.getProperty(PR_MULTI_INSTANCE);
            boolean mi = mi_str != null && mi_str.equalsIgnoreCase("true");
            AzureusCore core = AzureusCoreFactory.create();
            new LocaleUtilSWT(core);
            this.startServer = new StartServer(core);
            boolean debugGUI = Boolean.getBoolean("debug");
            if (mi || debugGUI) {
                new Initializer(core, this.startServer, args);
                return;
            }
            int i = 0;
            while (i < args.length) {
                String filename = args[i];
                try {
                    args[i] = new File(filename).getCanonicalPath();
                    LGLogger.log("Main::main: args[" + i + "] exists = " + new File(filename).exists());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++i;
            }
            if (this.startServer.getState() == 1) {
                this.startServer.pollForConnections();
                new Initializer(core, this.startServer, args);
            } else {
                new StartSocket(args);
                try {
                    Thread.sleep(2500L);
                }
                catch (Throwable e) {}
            }
        }
        catch (AzureusCoreException e) {
            LGLogger.log(3, "Start failed");
            Debug.printStackTrace(e);
        }
    }

    public static void main(String[] args) {
        new Main(args);
    }
}

