/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;

public class LocaleUtilSWT
implements LocaleUtilListener {
    protected static boolean rememberEncodingDecision = true;
    protected static LocaleUtilDecoder rememberedDecoder = null;
    protected static Object remembered_on_behalf_of;

    public LocaleUtilSWT(AzureusCore core) {
        core.getLocaleUtil().addListener(this);
    }

    public LocaleUtilDecoderCandidate selectDecoder(LocaleUtil locale_util, Object decision_owner, LocaleUtilDecoderCandidate[] candidates) throws LocaleUtilEncodingException {
        int i;
        if (decision_owner != remembered_on_behalf_of) {
            remembered_on_behalf_of = decision_owner;
            rememberedDecoder = null;
        }
        if (rememberEncodingDecision && rememberedDecoder != null) {
            int i2 = 0;
            while (i2 < candidates.length) {
                if (candidates[i2].getValue() != null && rememberedDecoder == candidates[i2].getDecoder()) {
                    return candidates[i2];
                }
                ++i2;
            }
        }
        LocaleUtilDecoderCandidate default_candidate = candidates[0];
        String defaultString = candidates[0].getValue();
        Arrays.sort(candidates);
        boolean always_prompt = COConfigurationManager.getBooleanParameter("File.Decoder.Prompt", false);
        if (!always_prompt) {
            int minlength = candidates[0].getValue().length();
            if (defaultString != null && defaultString.length() == minlength) {
                return default_candidate;
            }
            String default_name = COConfigurationManager.getStringParameter("File.Decoder.Default", "");
            if (default_name.length() > 0) {
                i = 0;
                while (i < candidates.length) {
                    if (candidates[i].getValue() != null && candidates[i].getDecoder().getName().equals(default_name)) {
                        return candidates[i];
                    }
                    ++i;
                }
            }
        }
        ArrayList<LocaleUtilDecoderCandidate> choosableCandidates = new ArrayList<LocaleUtilDecoderCandidate>();
        if (defaultString != null) {
            choosableCandidates.add(default_candidate);
        }
        LocaleUtilDecoder[] general_decoders = locale_util.getGeneralDecoders();
        int j = 0;
        while (j < general_decoders.length) {
            int i3 = 0;
            while (i3 < candidates.length) {
                if (candidates[i3].getValue() != null && candidates[i3].getDecoder() != null && general_decoders[j] != null && general_decoders[j].getName().equals(candidates[i3].getDecoder().getName()) && !choosableCandidates.contains(candidates[i3])) {
                    choosableCandidates.add(candidates[i3]);
                    break;
                }
                ++i3;
            }
            ++j;
        }
        i = 0;
        while (i < candidates.length) {
            if (candidates[i].getValue() != null && candidates[i].getDecoder() != null && !choosableCandidates.contains(candidates[i])) {
                choosableCandidates.add(candidates[i]);
            }
            ++i;
        }
        final LocaleUtilDecoderCandidate[] candidatesToChoose = choosableCandidates.toArray(new LocaleUtilDecoderCandidate[choosableCandidates.size()]);
        final LocaleUtilDecoderCandidate[] selected_candidate = new LocaleUtilDecoderCandidate[1];
        MainWindow window = MainWindow.getWindow();
        if (window == null) {
            return default_candidate;
        }
        final AESemaphore[] lock = new AESemaphore[]{new AESemaphore("LocaleUtilSWT")};
        MainWindow.getWindow().getDisplay().asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                try {
                    LocaleUtilSWT.this.showChoosableEncodingWindow(lock[0], MainWindow.getWindow().getShell(), candidatesToChoose, selected_candidate);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    lock[0].release();
                }
            }
        });
        lock[0].reserve();
        if (selected_candidate[0] == null) {
            throw new LocaleUtilEncodingException(true);
        }
        return selected_candidate[0];
    }

    private void showChoosableEncodingWindow(final AESemaphore lock, Shell shell, final LocaleUtilDecoderCandidate[] candidates, final LocaleUtilDecoderCandidate[] selected_candidate) {
        final Shell s = new Shell(shell, 32816);
        if (!Constants.isOSX) {
            s.setImage(ImageRepository.getImage("azureus"));
        }
        s.setText(MessageText.getString("LocaleUtil.title"));
        s.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label((Composite)s, 16384);
        Messages.setLanguageText((Widget)label, "LocaleUtil.label.chooseencoding");
        final Table table = new Table((Composite)s, 68100);
        GridData gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] titlesPieces = new String[]{"filename", "encoding"};
        int i = 0;
        while (i < titlesPieces.length) {
            TableColumn column = new TableColumn(table, 16384);
            Messages.setLanguageText((Widget)column, "LocaleUtil.column.".concat(titlesPieces[i]));
            ++i;
        }
        i = 0;
        while (i < candidates.length) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, candidates[i].getValue());
            item.setText(1, candidates[i].getDecoder().getName());
            ++i;
        }
        int lastSelectedIndex = 0;
        int i2 = 1;
        while (i2 < candidates.length) {
            if (candidates[i2].getValue() != null && candidates[i2].getDecoder() == rememberedDecoder) {
                lastSelectedIndex = i2;
                break;
            }
            ++i2;
        }
        table.select(lastSelectedIndex);
        table.getColumn(0).pack();
        table.getColumn(1).pack();
        label = new Label((Composite)s, 16384);
        Messages.setLanguageText((Widget)label, "LocaleUtil.label.hint.doubleclick");
        Composite composite = new Composite((Composite)s, 0);
        gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout subLayout = new GridLayout();
        subLayout.numColumns = 2;
        composite.setLayout((Layout)subLayout);
        final Button checkBox = new Button(composite, 32);
        checkBox.setLayoutData((Object)new GridData(32));
        checkBox.setSelection(rememberEncodingDecision);
        Messages.setLanguageText((Widget)checkBox, "LocaleUtil.label.checkbox.rememberdecision");
        Button ok = new Button(composite, 8);
        ok.setText(" ".concat(MessageText.getString("Button.next")).concat(" "));
        gridData = new GridData(3);
        gridData.widthHint = 100;
        ok.setLayoutData((Object)gridData);
        s.setSize(500, 500);
        s.layout();
        Utils.centreWindow(s);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocaleUtilSWT.this.setSelectedIndex(s, table, checkBox, candidates, selected_candidate);
                lock.release();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mEvent) {
                LocaleUtilSWT.this.setSelectedIndex(s, table, checkBox, candidates, selected_candidate);
                lock.release();
            }
        });
        s.open();
    }

    private void setSelectedIndex(Shell s, Table table, Button checkBox, LocaleUtilDecoderCandidate[] candidates, LocaleUtilDecoderCandidate[] selected_candidate) {
        int selectedIndex = table.getSelectionIndex();
        if (-1 == selectedIndex) {
            return;
        }
        rememberEncodingDecision = checkBox.getSelection();
        selected_candidate[0] = candidates[selectedIndex];
        rememberedDecoder = rememberEncodingDecision ? selected_candidate[0].getDecoder() : null;
        s.dispose();
    }

    private void abandonSelection(Shell s) {
        s.dispose();
    }
}

