/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.download;

import java.io.File;
import java.net.URL;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.download.RPDownload;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPDownloadManager
extends RPObject
implements DownloadManager {
    protected transient DownloadManager delegate;

    public static RPDownloadManager create(DownloadManager _delegate) {
        RPDownloadManager res = (RPDownloadManager)RPObject._lookupLocal(_delegate);
        if (res == null) {
            res = new RPDownloadManager(_delegate);
        }
        return res;
    }

    protected RPDownloadManager(DownloadManager _delegate) {
        super(_delegate);
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (DownloadManager)_delegate;
    }

    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        Object[] params = request2.getParams();
        if (method.equals("getDownloads")) {
            Download[] downloads = this.delegate.getDownloads();
            RPDownload[] res = new RPDownload[downloads.length];
            int i = 0;
            while (i < res.length) {
                res[i] = RPDownload.create(downloads[i]);
                ++i;
            }
            return new RPReply(res);
        }
        if (method.equals("getDownloads[boolean]")) {
            Download[] downloads = this.delegate.getDownloads((Boolean)request2.getParams()[0]);
            RPDownload[] res = new RPDownload[downloads.length];
            int i = 0;
            while (i < res.length) {
                res[i] = RPDownload.create(downloads[i]);
                ++i;
            }
            return new RPReply(res);
        }
        if (method.equals("addDownload[Torrent]")) {
            try {
                RPTorrent torrent = (RPTorrent)request2.getParams()[0];
                Download res = this.delegate.addDownload((Torrent)torrent._setLocal());
                return new RPReply(RPDownload.create(res));
            }
            catch (DownloadException e) {
                throw new RPException("DownloadManager::addDownload failed", e);
            }
        }
        if (method.equals("addDownload[Torrent,String,String]")) {
            try {
                RPTorrent torrent = (RPTorrent)request2.getParams()[0];
                File f1 = params[1] == null ? null : new File((String)params[1]);
                File f2 = params[2] == null ? null : new File((String)params[2]);
                Download res = this.delegate.addDownload((Torrent)torrent._setLocal(), f1, f2);
                return new RPReply(RPDownload.create(res));
            }
            catch (DownloadException e) {
                throw new RPException("DownloadManager::addDownload failed", e);
            }
        }
        if (method.equals("addDownload[URL]")) {
            try {
                this.delegate.addDownload((URL)request2.getParams()[0]);
            }
            catch (DownloadException e) {
                throw new RPException("DownloadManager::addDownload failed", e);
            }
            return new RPReply(null);
        }
        if (method.equals("pauseDownloads")) {
            this.delegate.pauseDownloads();
            return null;
        }
        if (method.equals("resumeDownloads")) {
            this.delegate.resumeDownloads();
            return null;
        }
        if (method.equals("stopAllDownloads")) {
            this.delegate.stopAllDownloads();
            return null;
        }
        if (method.equals("startAllDownloads")) {
            this.delegate.startAllDownloads();
            return null;
        }
        throw new RPException("Unknown method: " + method);
    }

    public void addDownload(File torrent_file) throws DownloadException {
        this.notSupported();
    }

    public void addDownload(URL url, URL referer) {
    }

    public void addDownload(URL url) throws DownloadException {
        this._dispatcher.dispatch(new RPRequest(this, "addDownload[URL]", new Object[]{url})).getResponse();
    }

    public Download addDownload(Torrent torrent) throws DownloadException {
        try {
            RPDownload res = (RPDownload)this._dispatcher.dispatch(new RPRequest(this, "addDownload[Torrent]", new Object[]{torrent})).getResponse();
            res._setRemote(this._dispatcher);
            return res;
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public Download addDownload(Torrent torrent, File torrent_location, File data_location) throws DownloadException {
        try {
            RPDownload res = (RPDownload)this._dispatcher.dispatch(new RPRequest(this, "addDownload[Torrent,String,String]", new Object[]{torrent, torrent_location == null ? null : torrent_location.toString(), data_location == null ? null : data_location.toString()})).getResponse();
            res._setRemote(this._dispatcher);
            return res;
        }
        catch (RPException e) {
            if (e.getCause() instanceof DownloadException) {
                throw (DownloadException)e.getCause();
            }
            throw e;
        }
    }

    public Download addNonPersistentDownload(Torrent torrent, File torrent_location, File data_location) throws DownloadException {
        this.notSupported();
        return null;
    }

    public Download getDownload(Torrent torrent) {
        this.notSupported();
        return null;
    }

    public Download[] getDownloads() {
        Download[] res = (RPDownload[])this._dispatcher.dispatch(new RPRequest(this, "getDownloads", null)).getResponse();
        int i = 0;
        while (i < res.length) {
            ((RPDownload)res[i])._setRemote(this._dispatcher);
            ++i;
        }
        return res;
    }

    public Download[] getDownloads(boolean bSort) {
        Download[] res = (RPDownload[])this._dispatcher.dispatch(new RPRequest(this, "getDownloads[boolean]", new Object[]{new Boolean(bSort)})).getResponse();
        int i = 0;
        while (i < res.length) {
            ((RPDownload)res[i])._setRemote(this._dispatcher);
            ++i;
        }
        return res;
    }

    public void pauseDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "pauseDownloads", null)).getResponse();
    }

    public void resumeDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "resumeDownloads", null)).getResponse();
    }

    public void startAllDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "startAllDownloads", null)).getResponse();
    }

    public void stopAllDownloads() {
        this._dispatcher.dispatch(new RPRequest(this, "stopAllDownloads", null)).getResponse();
    }

    public void addListener(DownloadManagerListener l) {
        this.notSupported();
    }

    public void removeListener(DownloadManagerListener l) {
        this.notSupported();
    }
}

