/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.ui.config.EnablerParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.pluginsimpl.local.ui.config.BooleanParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ColorParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.DirectoryParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.FileParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.IntsParameter;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringListParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.StringParameterImpl;

public class PluginConfigUIFactoryImpl
implements PluginConfigUIFactory {
    String pluginKey;
    PluginConfig config;

    public PluginConfigUIFactoryImpl(PluginConfig _config, String _pluginKey) {
        this.config = _config;
        this.pluginKey = _pluginKey;
    }

    public Parameter createIntParameter(String key, String label, int defaultValue, int[] values, String[] labels) {
        return new IntsParameter(this.config, String.valueOf(this.pluginKey) + "." + key, label, defaultValue, values, labels);
    }

    public EnablerParameter createBooleanParameter(String key, String label, boolean defaultValue) {
        return new BooleanParameterImpl(this.config, String.valueOf(this.pluginKey) + "." + key, label, defaultValue);
    }

    public Parameter createIntParameter(String key, String label, int defaultValue) {
        return new IntParameterImpl(this.config, String.valueOf(this.pluginKey) + "." + key, label, defaultValue);
    }

    public Parameter createStringParameter(String key, String label, String defaultValue) {
        return new StringParameterImpl(this.config, String.valueOf(this.pluginKey) + "." + key, label, defaultValue);
    }

    public Parameter createStringParameter(String key, String label, String defaultValue, String[] values, String[] labels) {
        return new StringListParameterImpl(this.config, String.valueOf(this.pluginKey) + "." + key, label, defaultValue, values, labels);
    }

    public Parameter createFileParameter(String key, String label, String defaultValue) {
        return new FileParameter(this.config, String.valueOf(this.pluginKey) + "." + key, label, defaultValue);
    }

    public Parameter createDirectoryParameter(String key, String label, String defaultValue) {
        return new DirectoryParameterImpl(this.config, String.valueOf(this.pluginKey) + "." + key, label, defaultValue);
    }

    public Parameter createColorParameter(String key, String label, int defaultValueRed, int defaultValueGreen, int defaultValueBlue) {
        return new ColorParameter(this.config, String.valueOf(this.pluginKey) + "." + key, label, defaultValueRed, defaultValueGreen, defaultValueBlue);
    }
}

