/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWCHelper;

public class TrackerWebContextImpl
extends TrackerWCHelper
implements TRTrackerServerListener {
    protected TRTrackerServer server;
    protected List auth_listeners = new ArrayList();

    public TrackerWebContextImpl(TrackerImpl _tracker, String name, int port, int protocol) throws TrackerException {
        this.setTracker(_tracker);
        try {
            this.server = protocol == 1 ? TRTrackerServerFactory.create(name, 1, port, false) : TRTrackerServerFactory.createSSL(name, 1, port, false);
            this.server.addListener(this);
        }
        catch (TRTrackerServerException e) {
            throw new TrackerException("TRTrackerServerFactory failed", e);
        }
    }

    public String getName() {
        return this.server.getName();
    }

    public URL[] getURLs() {
        try {
            return new URL[]{new URL(String.valueOf(this.server.isSSL() ? "https" : "http") + "://" + this.server.getHost() + ":" + this.server.getPort() + "/")};
        }
        catch (MalformedURLException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public int getProtocol() {
        return this.server.isSSL() ? 2 : 1;
    }

    public String getHostName() {
        return this.server.getHost();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public boolean permitted(byte[] hash, boolean explicit) {
        return false;
    }

    public boolean denied(byte[] hash, boolean explicit) {
        return false;
    }

    public boolean authenticate(URL resource, String user, String password) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                boolean res = ((TrackerAuthenticationListener)this.auth_listeners.get(i)).authenticate(resource, user, password);
                if (res) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return false;
    }

    public byte[] authenticate(URL resource, String user) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                byte[] res = ((TrackerAuthenticationListener)this.auth_listeners.get(i)).authenticate(resource, user);
                if (res != null) {
                    return res;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return null;
    }

    public void addAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(l);
            if (this.auth_listeners.size() == 1) {
                this.server.addAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(l);
            if (this.auth_listeners.size() == 0) {
                this.server.removeAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

