/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentEncodingException;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.torrent.TorrentManagerEvent;
import org.gudy.azureus2.plugins.torrent.TorrentManagerListener;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentDownloaderImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class TorrentManagerImpl
implements TorrentManager,
TOTorrentProgressListener {
    protected static TorrentManagerImpl singleton;
    protected static AEMonitor class_mon;
    protected static TorrentAttribute category_attribute;
    protected List listeners = new ArrayList();

    static {
        class_mon = new AEMonitor("TorrentManager");
        category_attribute = new TorrentAttributeImpl();
    }

    public static TorrentManagerImpl getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TorrentManagerImpl();
            }
            TorrentManagerImpl torrentManagerImpl = singleton;
            class_mon.exit();
            return torrentManagerImpl;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    protected TorrentManagerImpl() {
    }

    public TorrentDownloader getURLDownloader(URL url) throws TorrentException {
        return new TorrentDownloaderImpl(this, url);
    }

    public TorrentDownloader getURLDownloader(URL url, String user_name, String password) throws TorrentException {
        return new TorrentDownloaderImpl(this, url, user_name, password);
    }

    public Torrent createFromBEncodedFile(File file) throws TorrentException {
        try {
            return new TorrentImpl(TorrentUtils.readFromFile(file, false));
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Torrent createFromBEncodedData(byte[] data) throws TorrentException {
        ByteArrayInputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(data);
                TorrentImpl torrentImpl = new TorrentImpl(TOTorrentFactory.deserialiseFromBEncodedInputStream(is));
                try {
                    is.close();
                    return torrentImpl;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                return torrentImpl;
            }
            catch (TOTorrentException e) {
                throw new TorrentException("TorrentManager::createFromBEncodedData Fails", e);
            }
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (Throwable e2) {
                Debug.printStackTrace(e2);
            }
            throw throwable;
        }
    }

    public Torrent createFromDataFile(File data, URL announce_url) throws TorrentException {
        return this.createFromDataFile(data, announce_url, false);
    }

    public Torrent createFromDataFile(File data, URL announce_url, boolean include_other_hashes) throws TorrentException {
        try {
            TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(data, announce_url, include_other_hashes);
            c.addListener(this);
            return new TorrentImpl(c.create());
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromDataFile Fails", e);
        }
    }

    public TorrentAttribute[] getDefinedAttributes() {
        return new TorrentAttribute[]{category_attribute};
    }

    public TorrentAttribute getAttribute(String name) {
        if (name.equals(category_attribute.getName())) {
            return category_attribute;
        }
        return null;
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(final String task_description) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((TorrentManagerListener)this.listeners.get(i)).event(new TorrentManagerEvent(){

                public Object getData() {
                    return task_description;
                }
            });
            ++i;
        }
    }

    protected void tryToSetTorrentEncoding(TOTorrent torrent, String encoding) throws TorrentEncodingException {
        try {
            LocaleUtil.getSingleton().setTorrentEncoding(torrent, encoding);
        }
        catch (LocaleUtilEncodingException e) {
            String[] charsets = e.getValidCharsets();
            if (charsets == null) {
                throw new TorrentEncodingException("Failed to set requested encoding", e);
            }
            throw new TorrentEncodingException(charsets, e.getValidTorrentNames());
        }
    }

    protected void tryToSetDefaultTorrentEncoding(TOTorrent torrent) throws TorrentException {
        try {
            LocaleUtil.getSingleton().setDefaultTorrentEncoding(torrent);
        }
        catch (LocaleUtilEncodingException e) {
            String[] charsets = e.getValidCharsets();
            if (charsets == null) {
                throw new TorrentEncodingException("Failed to set default encoding", e);
            }
            throw new TorrentEncodingException(charsets, e.getValidTorrentNames());
        }
    }

    public void addListener(TorrentManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(TorrentManagerListener l) {
        this.listeners.remove(l);
    }
}

