/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.plugins.peers.PeerManagerStats;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.pluginsimpl.local.disk.DiskManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;

public class PeerManagerImpl
implements PeerManager {
    protected PEPeerManager manager;
    protected static AEMonitor pm_map_mon = new AEMonitor("PeerManager:Map");
    protected Map foreign_map = new WeakHashMap();
    protected Map listener_map = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("PeerManager");

    public static PeerManagerImpl getPeerManager(PEPeerManager _manager) {
        try {
            pm_map_mon.enter();
            PeerManagerImpl res = (PeerManagerImpl)_manager.getData("PluginPeerManager");
            if (res == null) {
                res = new PeerManagerImpl(_manager);
                _manager.setData("PluginPeerManager", res);
            }
            PeerManagerImpl peerManagerImpl = res;
            pm_map_mon.exit();
            return peerManagerImpl;
        }
        catch (Throwable throwable) {
            pm_map_mon.exit();
            throw throwable;
        }
    }

    protected PeerManagerImpl(PEPeerManager _manager) {
        this.manager = _manager;
    }

    public PEPeerManager getDelegate() {
        return this.manager;
    }

    public DiskManager getDiskManager() {
        return new DiskManagerImpl(this);
    }

    public PeerManagerStats getStats() {
        return new PeerManagerStatsImpl(this.manager);
    }

    public boolean isSeeding() {
        return this.manager.getState() == 3;
    }

    public Download getDownload() throws DownloadException {
        return DownloadManagerImpl.getDownloadStatic(this.manager.getDownloadManager());
    }

    public PeerStats createPeerStats() {
        return new PeerStatsImpl(this.manager, this.manager.createPeerStats());
    }

    public void addPeer(Peer peer) {
        this.manager.addPeer(this.mapForeignPeer(peer));
    }

    public void removePeer(Peer peer) {
        this.manager.removePeer(this.mapForeignPeer(peer));
    }

    protected void peerAdded(Peer peer) {
        this.manager.peerAdded(this.mapForeignPeer(peer));
    }

    protected void peerRemoved(Peer peer) {
        this.manager.peerRemoved(this.mapForeignPeer(peer));
    }

    public PEPeer mapForeignPeer(Peer _foreign) {
        Debug.out("Fix this!!!!");
        PEPeer local = (PEPeer)this.foreign_map.get(_foreign);
        if (local == null) {
            local = new PeerForeignDelegate(this, _foreign);
            this.foreign_map.put(_foreign, local);
        }
        return local;
    }

    public List mapForeignPeers(Peer[] _foreigns) {
        ArrayList<PEPeer> res = new ArrayList<PEPeer>();
        int i = 0;
        while (i < _foreigns.length) {
            PEPeer local = this.mapForeignPeer(_foreigns[i]);
            if (!res.contains(local)) {
                res.add(local);
            }
            ++i;
        }
        return res;
    }

    public void addListener(final PeerManagerListener l) {
        try {
            this.this_mon.enter();
            final HashMap peer_map = new HashMap();
            DownloadManagerPeerListener pml = new DownloadManagerPeerListener(){

                public void peerManagerAdded(PEPeerManager manager) {
                }

                public void peerManagerRemoved(PEPeerManager manager) {
                }

                public void peerAdded(PEPeer peer) {
                    PeerImpl pi = new PeerImpl(peer);
                    peer_map.put(peer, pi);
                    l.peerAdded(PeerManagerImpl.this, pi);
                }

                public void peerRemoved(PEPeer peer) {
                    PeerImpl pi = (PeerImpl)peer_map.remove(peer);
                    if (pi != null) {
                        l.peerRemoved(PeerManagerImpl.this, pi);
                    }
                }

                public void pieceAdded(PEPiece piece) {
                }

                public void pieceRemoved(PEPiece piece) {
                }
            };
            this.listener_map.put(l, pml);
            this.manager.getDownloadManager().addPeerListener(pml);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeListener(PeerManagerListener l) {
        try {
            this.this_mon.enter();
            DownloadManagerPeerListener pml = (DownloadManagerPeerListener)this.listener_map.get(l);
            if (pml != null) {
                this.manager.getDownloadManager().removePeerListener(pml);
                this.listener_map.remove(l);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

