/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.xml.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.gudy.azureus2.core3.util.Debug;

public class XUXmlWriter {
    private static final int INDENT_AMOUNT = 4;
    private String current_indent_string;
    private PrintWriter writer;

    protected XUXmlWriter() {
        this.resetIndent();
    }

    protected XUXmlWriter(OutputStream _output_stream) {
        this.setOutputStream(_output_stream);
        this.resetIndent();
    }

    protected void setOutputStream(OutputStream _output_stream) {
        try {
            this.writer = new PrintWriter(new OutputStreamWriter(_output_stream, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            this.writer = new PrintWriter(_output_stream);
        }
    }

    protected void writeTag(String tag, String content) {
        this.writeLineRaw("<" + tag + ">" + this.escapeXML(content) + "</" + tag + ">");
    }

    protected void writeTag(String tag, long content) {
        this.writeLineRaw("<" + tag + ">" + content + "</" + tag + ">");
    }

    protected void writeTag(String tag, boolean content) {
        this.writeLineRaw("<" + tag + ">" + (content ? "YES" : "NO") + "</" + tag + ">");
    }

    protected void writeLineRaw(String str) {
        this.writer.println(String.valueOf(this.current_indent_string) + str);
    }

    protected void writeLineEscaped(String str) {
        this.writer.println(String.valueOf(this.current_indent_string) + this.escapeXML(str));
    }

    protected void resetIndent() {
        this.current_indent_string = "";
    }

    protected void indent() {
        int i = 0;
        while (i < 4) {
            this.current_indent_string = String.valueOf(this.current_indent_string) + " ";
            ++i;
        }
    }

    protected void exdent() {
        this.current_indent_string = this.current_indent_string.length() >= 4 ? this.current_indent_string.substring(0, this.current_indent_string.length() - 4) : "";
    }

    protected String escapeXML(String str) {
        if (str == null) {
            return "";
        }
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("--", "&#45;&#45;");
        return str;
    }

    protected void flushOutputStream() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    protected void closeOutputStream() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }
}

