/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.Arrays;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class SystemTime {
    public static final long TIME_GRANULARITY_MILLIS = 20L;
    private static final SystemTime instance = new SystemTime();
    private final Thread updater;
    private volatile long currentTime = 0L;
    private long prevTime = 0L;
    private long errorStartTime = 0L;
    private final long[] errorTimes = new long[]{1000L, 5000L, 10000L, 30000L, 60000L, 300000L, 600000L};
    private volatile boolean[] errorStates = new boolean[this.errorTimes.length];
    private volatile long lastTimeChange = 0L;

    private SystemTime() {
        Arrays.fill(this.errorStates, false);
        this.updater = new AEThread("SystemTime"){

            public void runSupport() {
                while (true) {
                    int i;
                    SystemTime.this.currentTime = System.currentTimeMillis();
                    if (SystemTime.this.currentTime < SystemTime.this.prevTime) {
                        SystemTime.this.lastTimeChange = SystemTime.this.prevTime - SystemTime.this.currentTime;
                        LGLogger.log(0, "SystemTime: caught clock time set backwards " + SystemTime.this.lastTimeChange + " ms");
                        SystemTime.this.errorStartTime = SystemTime.this.currentTime;
                        i = 0;
                        while (i < SystemTime.this.errorStates.length) {
                            ((SystemTime)SystemTime.this).errorStates[i] = true;
                            ++i;
                        }
                    }
                    SystemTime.this.prevTime = SystemTime.this.currentTime;
                    if (SystemTime.this.errorStartTime != 0L) {
                        i = 0;
                        while (i < SystemTime.this.errorTimes.length) {
                            if (SystemTime.this.errorStates[i] && SystemTime.this.currentTime - SystemTime.this.errorStartTime > SystemTime.this.errorTimes[i]) {
                                ((SystemTime)SystemTime.this).errorStates[i] = false;
                                if (i == SystemTime.this.errorTimes.length - 1) {
                                    SystemTime.this.errorStartTime = 0L;
                                }
                            }
                            ++i;
                        }
                    }
                    try {
                        Thread.sleep(20L);
                        continue;
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                        continue;
                    }
                    break;
                }
            }
        };
        this.updater.setDaemon(true);
        this.updater.setPriority(10);
        this.updater.start();
    }

    public static long getCurrentTime() {
        return SystemTime.instance.currentTime;
    }

    public static boolean isErrorLast1sec() {
        return SystemTime.instance.errorStates[0];
    }

    public static boolean isErrorLast5sec() {
        return SystemTime.instance.errorStates[1];
    }

    public static boolean isErrorLast10sec() {
        return SystemTime.instance.errorStates[2];
    }

    public static boolean isErrorLast30sec() {
        return SystemTime.instance.errorStates[3];
    }

    public static boolean isErrorLast1min() {
        return SystemTime.instance.errorStates[4];
    }

    public static boolean isErrorLast5min() {
        return SystemTime.instance.errorStates[5];
    }

    public static boolean isErrorLast10min() {
        return SystemTime.instance.errorStates[6];
    }

    public static long getErrorTimeChange() {
        return SystemTime.instance.lastTimeChange;
    }
}

