/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.test;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;

public class Main
implements Plugin,
PluginListener {
    protected static AESemaphore init_sem = new AESemaphore("TrackerServerTest");
    private static AEMonitor class_mon = new AEMonitor("TrackerServerTest:class");
    protected static Main singleton;
    protected AEMonitor this_mon = new AEMonitor("TrackerServerTest");
    protected PluginInterface plugin_interface;
    long count = 0L;
    long peer_id_next = 2000000000L;
    long ip_address_next = 2000000000L;
    long now = System.currentTimeMillis();
    final int num_want_base = 50;
    final String event = "started";
    final boolean random_want = true;
    final boolean do_scrape = false;
    final boolean mix = false;
    static /* synthetic */ Class class$0;

    static void usage() {
        System.err.println("Usage:");
        SESecurityManager.exitVM(1);
    }

    public static void main(String[] args) {
        HashWrapper hash = new HashWrapper("kjlklk".getBytes());
        TRTrackerServerTorrentImpl torrent = new TRTrackerServerTorrentImpl(hash);
        Runtime rt = Runtime.getRuntime();
        System.out.println("used = " + (rt.totalMemory() - rt.freeMemory()));
        int x = 0;
        while (x < 1000) {
            int i = 0;
            while (i < 50000) {
                try {
                    int cfr_ignored_0 = i % 1000;
                    torrent.peerContact("started", new HashWrapper(("xxxxxxxxxxxxxxxx" + i).getBytes()), 1234, "xxxxxxx" + i, false, "kkkkkkkk", 0L, 0L, 0L, 100000L);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                ++i;
            }
            rt.gc();
            System.out.println("used = " + (rt.totalMemory() - rt.freeMemory()));
            ++x;
        }
    }

    public static Main getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                new AEThread("plugin initialiser "){

                    public void runSupport() {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.gudy.azureus2.core3.tracker.server.test.Main");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        PluginManager.registerPlugin(clazz);
                        Properties props = new Properties();
                        props.put("MULTI_INSTANCE", "true");
                        PluginManager.startAzureus(1, props);
                    }
                }.start();
                init_sem.reserve();
            }
            Main main = singleton;
            class_mon.exit();
            return main;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    public void initialize(PluginInterface _pi) {
        this.plugin_interface = _pi;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Tracker Server Tester");
        singleton = this;
        init_sem.release();
        LoggerChannel log = this.plugin_interface.getLogger().getChannel("Plugin Test");
        log.log(1, "Plugin Initialised");
        this.plugin_interface.addListener(this);
    }

    public void initializationComplete() {
        new Thread(){

            public void run() {
                Main.this.plugin_interface.getTracker().addListener(new TrackerListener(this){
                    final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void torrentAdded(TrackerTorrent torrent) {
                        2.access$0(this.this$1).processTorrent(torrent);
                    }

                    public void torrentChanged(TrackerTorrent torrent) {
                    }

                    public void torrentRemoved(TrackerTorrent torrent) {
                    }
                });
            }

            static /* synthetic */ Main access$0(2 var0) {
                return var0.Main.this;
            }
        }.start();
    }

    protected void processTorrent(TrackerTorrent torrent) {
        Tracker tracker = this.plugin_interface.getTracker();
        URL tracker_url = tracker.getURLs()[0];
        String t_info_hash = null;
        try {
            t_info_hash = URLEncoder.encode(new String(torrent.getTorrent().getHash(), "ISO-8859-1"), "ISO-8859-1");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        String info_hash = t_info_hash;
        String url_scrape = "http://127.0.0.1:" + tracker_url.getPort() + "/scrape?info_hash=" + info_hash;
        this.loadTest(tracker_url, info_hash, url_scrape);
    }

    protected void loadTest(final URL tracker_url, final String info_hash, String url_scrape) {
        System.out.println("starting load test");
        System.out.println("    tracker = " + tracker_url.toString());
        System.out.println("    info = " + info_hash);
        System.out.println("    scrape = " + url_scrape);
        int i = 0;
        while (i < 6) {
            new Thread(){

                public void run() {
                    int j = 0;
                    while (j < 10000) {
                        int num_want = (int)(50.0 + Math.random() * 25.0);
                        String url_start = "http://127.0.0.1:" + tracker_url.getPort() + "/announce?info_hash=" + info_hash + "&peer_id=-AZ2103-aa";
                        String url_end = "&port=6881&uploaded=0&downloaded=0&left=10&event=started&numwant=" + num_want + "&ip=IP";
                        try {
                            Main.this.this_mon.enter();
                            ++Main.this.count;
                            if (Main.this.count % 100L == 0L) {
                                System.out.println(String.valueOf(Main.this.count) + ": " + 100000L / (System.currentTimeMillis() - Main.this.now));
                                Main.this.now = System.currentTimeMillis();
                            }
                            ++Main.this.peer_id_next;
                            ++Main.this.ip_address_next;
                        }
                        finally {
                            Main.this.this_mon.exit();
                        }
                        try {
                            long address;
                            long peer_id;
                            Thread.sleep(50L);
                            boolean did_scrape = false;
                            String url_str = String.valueOf(url_start) + peer_id + url_end + address;
                            URL url = new URL(url_str);
                            HttpURLConnection con = (HttpURLConnection)url.openConnection();
                            con.addRequestProperty("Accept-Encoding", "gzip");
                            con.setDoInput(true);
                            con.connect();
                            GZIPInputStream is = new GZIPInputStream(con.getInputStream());
                            byte[] data = new byte[1024];
                            int total = 0;
                            String str = "";
                            while (true) {
                                int len;
                                if ((len = ((InputStream)is).read(data)) > 0) {
                                    str = String.valueOf(str) + new String(data, 0, len);
                                    total += len;
                                    continue;
                                }
                                if (len != 0) break;
                                Thread.sleep(20L);
                            }
                            if (did_scrape) {
                                if (str.indexOf("files") == -1) {
                                    System.out.println("scrape_fail:" + str);
                                }
                            } else if (str.indexOf("peer id") == -1) {
                                System.out.println("->" + total + "-" + str);
                            }
                            ((InputStream)is).close();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        ++j;
                    }
                }
            }.start();
            ++i;
        }
    }

    public void closedownInitiated() {
    }

    public void closedownComplete() {
    }
}

