/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerStats;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerStatsImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public abstract class TRTrackerServerImpl
implements TRTrackerServer {
    public static int RETRY_MINIMUM_SECS = 60;
    public static int RETRY_MINIMUM_MILLIS = RETRY_MINIMUM_SECS * 1000;
    public static int CLIENT_TIMEOUT_MULTIPLIER = 3;
    public static int TIMEOUT_CHECK = RETRY_MINIMUM_MILLIS * CLIENT_TIMEOUT_MULTIPLIER;
    public static int max_peers_to_send = 0;
    public static boolean send_peer_ids = true;
    public static int announce_cache_period = 500;
    public static int scrape_cache_period = 5000;
    public static int announce_cache_threshold = 500;
    public static int max_seed_retention = 0;
    protected IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    protected Map torrent_map = new HashMap();
    protected long current_announce_retry_interval;
    protected long current_scrape_retry_interval;
    protected long current_total_clients;
    protected int current_min_poll_interval;
    protected TRTrackerServerStatsImpl stats = new TRTrackerServerStatsImpl();
    protected String name;
    protected boolean web_password_enabled;
    protected boolean web_password_https_only;
    protected boolean tracker_password_enabled;
    protected String password_user;
    protected byte[] password_pw;
    protected boolean compact_enabled;
    protected boolean key_enabled;
    protected Vector listeners = new Vector();
    protected List auth_listeners = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServer");

    static {
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerServerImpl.readConfig();
            }
        });
        TRTrackerServerImpl.readConfig();
    }

    protected static void readConfig() {
        send_peer_ids = COConfigurationManager.getBooleanParameter("Tracker Send Peer IDs", true);
        max_peers_to_send = COConfigurationManager.getIntParameter("Tracker Max Peers Returned", 0);
        scrape_cache_period = COConfigurationManager.getIntParameter("Tracker Scrape Cache", 5000);
        announce_cache_period = COConfigurationManager.getIntParameter("Tracker Announce Cache", 500);
        announce_cache_threshold = COConfigurationManager.getIntParameter("Tracker Announce Cache Min Peers", 500);
        max_seed_retention = COConfigurationManager.getIntParameter("Tracker Max Seeds Retained", 0);
    }

    protected static boolean getSendPeerIds() {
        return send_peer_ids;
    }

    protected static int getMaxPeersToSend() {
        return max_peers_to_send;
    }

    protected static int getScrapeCachePeriod() {
        return scrape_cache_period;
    }

    protected static int getAnnounceCachePeriod() {
        return announce_cache_period;
    }

    protected static int getAnnounceCachePeerThreshold() {
        return announce_cache_threshold;
    }

    protected static int getMaxSeedRetention() {
        return max_seed_retention;
    }

    public TRTrackerServerImpl(String _name) {
        this.name = _name == null ? "Azureus" : _name;
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerServerImpl.this.readConfigSettings();
            }
        });
        this.readConfigSettings();
        this.current_min_poll_interval = COConfigurationManager.getIntParameter("Tracker Poll Interval Min", 120);
        int scrape_percentage = COConfigurationManager.getIntParameter("Tracker Scrape Retry Percentage", 200);
        this.current_announce_retry_interval = this.current_min_poll_interval;
        this.current_scrape_retry_interval = this.current_announce_retry_interval * (long)scrape_percentage / 100L;
        AEThread timer_thread = new AEThread("TrackerServer:timer.loop"){

            public void runSupport() {
                TRTrackerServerImpl.this.timerLoop();
            }
        };
        timer_thread.setDaemon(true);
        timer_thread.start();
    }

    protected void readConfigSettings() {
        this.web_password_enabled = COConfigurationManager.getBooleanParameter("Tracker Password Enable Web");
        this.tracker_password_enabled = COConfigurationManager.getBooleanParameter("Tracker Password Enable Torrent");
        this.web_password_https_only = COConfigurationManager.getBooleanParameter("Tracker Password Web HTTPS Only");
        if (this.web_password_enabled || this.tracker_password_enabled) {
            this.password_user = COConfigurationManager.getStringParameter("Tracker Username", "");
            this.password_pw = COConfigurationManager.getByteParameter("Tracker Password", new byte[0]);
        }
        this.compact_enabled = COConfigurationManager.getBooleanParameter("Tracker Compact Enable");
        this.key_enabled = COConfigurationManager.getBooleanParameter("Tracker Key Enable Server");
    }

    public boolean isWebPasswordEnabled() {
        return this.web_password_enabled || this.auth_listeners.size() > 0;
    }

    public boolean isTrackerPasswordEnabled() {
        return this.tracker_password_enabled || this.auth_listeners.size() > 0;
    }

    public boolean isWebPasswordHTTPSOnly() {
        return this.web_password_https_only;
    }

    public boolean hasExternalAuthorisation() {
        return this.auth_listeners.size() > 0;
    }

    public boolean hasInternalAuthorisation() {
        return this.web_password_enabled || this.tracker_password_enabled;
    }

    public boolean performExternalAuthorisation(URL resource, String user, String password) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                if (((TRTrackerServerAuthenticationListener)this.auth_listeners.get(i)).authenticate(resource, user, password)) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return false;
    }

    public byte[] performExternalAuthorisation(URL resource, String user) {
        int i = 0;
        while (i < this.auth_listeners.size()) {
            try {
                byte[] sha_pw = ((TRTrackerServerAuthenticationListener)this.auth_listeners.get(i)).authenticate(resource, user);
                if (sha_pw != null) {
                    return sha_pw;
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCompactEnabled() {
        return this.compact_enabled;
    }

    public boolean isKeyEnabled() {
        return this.key_enabled;
    }

    public String getUsername() {
        return this.password_user;
    }

    public byte[] getPassword() {
        return this.password_pw;
    }

    public long getAnnounceRetryInterval(TRTrackerServerTorrentImpl torrent) {
        long clients = this.current_total_clients;
        if (clients == 0L) {
            return this.current_announce_retry_interval;
        }
        long res = (long)torrent.getPeerCount() * this.current_announce_retry_interval / clients;
        if (res < (long)this.current_min_poll_interval) {
            res = this.current_min_poll_interval;
        }
        return res;
    }

    public long getScrapeRetryInterval(TRTrackerServerTorrentImpl torrent) {
        long clients = this.current_total_clients;
        if (torrent == null || clients == 0L) {
            return this.current_scrape_retry_interval;
        }
        long res = (long)torrent.getPeerCount() * this.current_scrape_retry_interval / clients;
        if (res < (long)this.current_min_poll_interval) {
            res = this.current_min_poll_interval;
        }
        return res;
    }

    public TRTrackerServerStats getStats() {
        return this.stats;
    }

    public void updateStats(TRTrackerServerTorrentImpl torrent, int bytes_in, int bytes_out) {
        try {
            this.this_mon.enter();
            this.stats.update(bytes_in, bytes_out);
            if (torrent != null) {
                torrent.updateXferStats(bytes_in, bytes_out);
            } else {
                int num = this.torrent_map.size();
                if (num > 0) {
                    int ave_in = bytes_in / num;
                    int ave_out = bytes_out / num;
                    int rem_in = bytes_in - ave_in * num;
                    int rem_out = bytes_out - ave_out * num;
                    Iterator it = this.torrent_map.values().iterator();
                    while (it.hasNext()) {
                        TRTrackerServerTorrentImpl this_torrent = (TRTrackerServerTorrentImpl)it.next();
                        if (it.hasNext()) {
                            this_torrent.updateXferStats(ave_in, ave_out);
                            continue;
                        }
                        this_torrent.updateXferStats(ave_in + rem_in, ave_out + rem_out);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void timerLoop() {
        long time_to_go = TIMEOUT_CHECK;
        block8: while (true) {
            try {
                TRTrackerServerTorrentImpl t;
                Iterator it;
                Thread.sleep(RETRY_MINIMUM_MILLIS);
                time_to_go -= (long)RETRY_MINIMUM_MILLIS;
                int min = this.current_min_poll_interval = COConfigurationManager.getIntParameter("Tracker Poll Interval Min", 120);
                int max = COConfigurationManager.getIntParameter("Tracker Poll Interval Max", 3600);
                int inc_by = COConfigurationManager.getIntParameter("Tracker Poll Inc By", 60);
                int inc_per = COConfigurationManager.getIntParameter("Tracker Poll Inc Per", 10);
                int scrape_percentage = COConfigurationManager.getIntParameter("Tracker Scrape Retry Percentage", 200);
                int retry = min;
                int clients = 0;
                try {
                    this.this_mon.enter();
                    it = this.torrent_map.values().iterator();
                    while (it.hasNext()) {
                        t = (TRTrackerServerTorrentImpl)it.next();
                        clients += t.getPeerCount();
                    }
                }
                finally {
                    this.this_mon.exit();
                }
                if (inc_by > 0 && inc_per > 0) {
                    retry += inc_by * (clients / inc_per);
                }
                if (max > 0 && retry > max) {
                    retry = max;
                }
                if (retry < RETRY_MINIMUM_SECS) {
                    retry = RETRY_MINIMUM_SECS;
                }
                this.current_announce_retry_interval = retry;
                this.current_scrape_retry_interval = this.current_announce_retry_interval * (long)scrape_percentage / 100L;
                this.current_total_clients = clients;
                if (time_to_go > 0L) continue;
                time_to_go = TIMEOUT_CHECK;
                try {
                    this.this_mon.enter();
                    it = this.torrent_map.values().iterator();
                    while (true) {
                        if (!it.hasNext()) continue block8;
                        t = (TRTrackerServerTorrentImpl)it.next();
                        t.checkTimeouts();
                    }
                }
                finally {
                    this.this_mon.exit();
                    continue;
                }
            }
            catch (InterruptedException e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    public TRTrackerServerTorrent permit(byte[] _hash, boolean _explicit) throws TRTrackerServerException {
        HashWrapper hash = new HashWrapper(_hash);
        TRTrackerServerTorrentImpl entry2 = (TRTrackerServerTorrentImpl)this.torrent_map.get(hash);
        if (entry2 == null) {
            int i = 0;
            while (i < this.listeners.size()) {
                if (!((TRTrackerServerListener)this.listeners.elementAt(i)).permitted(_hash, _explicit)) {
                    throw new TRTrackerServerException("operation denied");
                }
                ++i;
            }
        }
        try {
            this.this_mon.enter();
            entry2 = (TRTrackerServerTorrentImpl)this.torrent_map.get(hash);
            if (entry2 == null) {
                entry2 = new TRTrackerServerTorrentImpl(hash);
                this.torrent_map.put(hash, entry2);
            }
        }
        finally {
            this.this_mon.exit();
        }
        return entry2;
    }

    public void deny(byte[] _hash, boolean _explicit) throws TRTrackerServerException {
        HashWrapper hash = new HashWrapper(_hash);
        int i = 0;
        while (i < this.listeners.size()) {
            if (!((TRTrackerServerListener)this.listeners.elementAt(i)).denied(_hash, _explicit)) {
                throw new TRTrackerServerException("operation denied");
            }
            ++i;
        }
        try {
            this.this_mon.enter();
            TRTrackerServerTorrentImpl entry2 = (TRTrackerServerTorrentImpl)this.torrent_map.get(hash);
            if (entry2 != null) {
                entry2.delete();
            }
            this.torrent_map.remove(hash);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public TRTrackerServerTorrentImpl getTorrent(byte[] hash) {
        return (TRTrackerServerTorrentImpl)this.torrent_map.get(new HashWrapper(hash));
    }

    public TRTrackerServerTorrentImpl[] getTorrents() {
        try {
            this.this_mon.enter();
            TRTrackerServerTorrentImpl[] res = new TRTrackerServerTorrentImpl[this.torrent_map.size()];
            this.torrent_map.values().toArray(res);
            TRTrackerServerTorrentImpl[] tRTrackerServerTorrentImplArray = res;
            this.this_mon.exit();
            return tRTrackerServerTorrentImplArray;
        }
        catch (Throwable throwable) {
            this.this_mon.exit();
            throw throwable;
        }
    }

    public TRTrackerServerTorrentStats getStats(byte[] hash) {
        TRTrackerServerTorrentImpl torrent = this.getTorrent(hash);
        if (torrent == null) {
            return null;
        }
        return torrent.getStats();
    }

    public TRTrackerServerPeer[] getPeers(byte[] hash) {
        TRTrackerServerTorrentImpl torrent = this.getTorrent(hash);
        if (torrent == null) {
            return null;
        }
        return torrent.getPeers();
    }

    public void addListener(TRTrackerServerListener l) {
        try {
            this.this_mon.enter();
            this.listeners.addElement(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void removeListener(TRTrackerServerListener l) {
        try {
            this.this_mon.enter();
            this.listeners.removeElement(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addAuthenticationListener(TRTrackerServerAuthenticationListener l) {
        this.auth_listeners.add(l);
    }

    public void removeAuthenticationListener(TRTrackerServerAuthenticationListener l) {
        this.auth_listeners.remove(l);
    }
}

