/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class TOTorrentXMLDeserialiser {
    public TOTorrent deserialise(File file) throws TOTorrentException {
        try {
            SimpleXMLParserDocument doc = SimpleXMLParserDocumentFactory.create(file);
            TOTorrent res = this.decodeRoot(doc);
            return res;
        }
        catch (SimpleXMLParserDocumentException e) {
            throw new TOTorrentException("XML Parse Fails: " + e.getMessage(), 6);
        }
    }

    protected TOTorrent decodeRoot(SimpleXMLParserDocument doc) throws TOTorrentException {
        String root_name = doc.getName();
        if (root_name.equalsIgnoreCase("TORRENT")) {
            TOTorrentImpl torrent = new TOTorrentImpl();
            SimpleXMLParserDocumentNode[] kids = doc.getChildren();
            URL announce_url = null;
            Object info_node = null;
            byte[] torrent_hash = null;
            int i = 0;
            while (i < kids.length) {
                SimpleXMLParserDocumentNode kid = kids[i];
                String name = kid.getName();
                if (name.equalsIgnoreCase("ANNOUNCE_URL")) {
                    try {
                        announce_url = new URL(kid.getValue());
                    }
                    catch (MalformedURLException e) {
                        throw new TOTorrentException("ANNOUNCE_URL malformed", 6);
                    }
                }
                if (name.equalsIgnoreCase("ANNOUNCE_LIST")) {
                    SimpleXMLParserDocumentNode[] set_nodes = kid.getChildren();
                    TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                    TOTorrentAnnounceURLSet[] sets = new TOTorrentAnnounceURLSet[set_nodes.length];
                    int j = 0;
                    while (j < sets.length) {
                        SimpleXMLParserDocumentNode[] url_nodes = set_nodes[j].getChildren();
                        URL[] urls = new URL[url_nodes.length];
                        int k = 0;
                        while (k < urls.length) {
                            try {
                                urls[k] = new URL(url_nodes[k].getValue());
                            }
                            catch (MalformedURLException e) {
                                throw new TOTorrentException("ANNOUNCE_LIST malformed", 6);
                            }
                            ++k;
                        }
                        sets[j] = group.createAnnounceURLSet(urls);
                        ++j;
                    }
                    group.setAnnounceURLSets(sets);
                } else if (name.equalsIgnoreCase("COMMENT")) {
                    torrent.setComment(this.readLocalisableString(kid));
                } else if (name.equalsIgnoreCase("CREATED_BY")) {
                    torrent.setCreatedBy(this.readLocalisableString(kid));
                } else if (name.equalsIgnoreCase("CREATION_DATE")) {
                    torrent.setCreationDate(this.readGenericLong(kid));
                } else if (name.equalsIgnoreCase("TORRENT_HASH")) {
                    torrent_hash = this.readGenericBytes(kid);
                } else if (name.equalsIgnoreCase("INFO")) {
                    this.decodeInfo(kid, torrent);
                } else {
                    mapEntry entry2 = this.readGenericMapEntry(kid);
                    torrent.addAdditionalProperty(entry2.name, entry2.value);
                }
                ++i;
            }
            if (announce_url == null) {
                throw new TOTorrentException("ANNOUNCE_URL missing", 6);
            }
            torrent.setAnnounceURL(announce_url);
            if (torrent_hash != null && !Arrays.equals(torrent.getHash(), torrent_hash)) {
                throw new TOTorrentException("Hash differs - declared TORRENT_HASH and computed hash differ. If this really is the intent (unlikely) then remove the TORRENT_HASH element", 6);
            }
            return torrent;
        }
        throw new TOTorrentException("Invalid root element", 6);
    }

    protected void decodeInfo(SimpleXMLParserDocumentNode doc, TOTorrentImpl torrent) throws TOTorrentException {
        SimpleXMLParserDocumentNode[] kids = doc.getChildren();
        byte[] torrent_name = null;
        long torrent_length = 0L;
        int i = 0;
        while (i < kids.length) {
            int j;
            SimpleXMLParserDocumentNode kid = kids[i];
            String name = kid.getName();
            if (name.equalsIgnoreCase("PIECE_LENGTH")) {
                torrent.setPieceLength(this.readGenericLong(kid));
            } else if (name.equalsIgnoreCase("LENGTH")) {
                torrent.setSimpleTorrent(true);
                torrent_length = this.readGenericLong(kid);
            } else if (name.equalsIgnoreCase("NAME")) {
                torrent.setName(this.readLocalisableString(kid));
            } else if (name.equalsIgnoreCase("FILES")) {
                torrent.setSimpleTorrent(false);
                SimpleXMLParserDocumentNode[] file_nodes = kid.getChildren();
                TOTorrentFileImpl[] files = new TOTorrentFileImpl[file_nodes.length];
                j = 0;
                while (j < files.length) {
                    SimpleXMLParserDocumentNode file_node = file_nodes[j];
                    SimpleXMLParserDocumentNode[] file_entries = file_node.getChildren();
                    long file_length = 0L;
                    boolean length_entry_found = false;
                    byte[][] path_comps = null;
                    Vector<mapEntry> additional_props = new Vector<mapEntry>();
                    int k = 0;
                    while (k < file_entries.length) {
                        SimpleXMLParserDocumentNode file_entry = file_entries[k];
                        String entry_name = file_entry.getName();
                        if (entry_name.equalsIgnoreCase("LENGTH")) {
                            file_length = this.readGenericLong(file_entry);
                            length_entry_found = true;
                        } else if (entry_name.equalsIgnoreCase("PATH")) {
                            SimpleXMLParserDocumentNode[] path_nodes = file_entry.getChildren();
                            path_comps = new byte[path_nodes.length][];
                            int n = 0;
                            while (n < path_nodes.length) {
                                path_comps[n] = this.readLocalisableString(path_nodes[n]);
                                ++n;
                            }
                        } else {
                            additional_props.addElement(this.readGenericMapEntry(file_entry));
                        }
                        ++k;
                    }
                    if (!length_entry_found || path_comps == null) {
                        throw new TOTorrentException("FILE element invalid (file length = " + file_length + ")", 6);
                    }
                    files[j] = new TOTorrentFileImpl((TOTorrent)torrent, file_length, path_comps);
                    k = 0;
                    while (k < additional_props.size()) {
                        mapEntry entry2 = (mapEntry)additional_props.elementAt(k);
                        files[j].setAdditionalProperty(entry2.name, entry2.value);
                        ++k;
                    }
                    ++j;
                }
                torrent.setFiles(files);
            } else if (name.equalsIgnoreCase("PIECES")) {
                SimpleXMLParserDocumentNode[] piece_nodes = kid.getChildren();
                byte[][] pieces = new byte[piece_nodes.length][];
                j = 0;
                while (j < pieces.length) {
                    pieces[j] = this.readGenericBytes(piece_nodes[j]);
                    ++j;
                }
                torrent.setPieces(pieces);
            } else {
                mapEntry entry3 = this.readGenericMapEntry(kid);
                torrent.addAdditionalInfoProperty(entry3.name, entry3.value);
            }
            ++i;
        }
        if (torrent.isSimpleTorrent()) {
            torrent.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)torrent, torrent_length, new byte[][]{torrent.getName()})});
        }
    }

    protected mapEntry readGenericMapEntry(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        if (!node.getName().equalsIgnoreCase("KEY")) {
            throw new TOTorrentException("Additional property invalid, must be KEY node", 6);
        }
        String name = node.getAttribute("name").getValue();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        if (kids.length != 1) {
            throw new TOTorrentException("Additional property invalid, KEY must have one child", 6);
        }
        String type = kids[0].getName();
        Object value = this.readGenericValue(kids[0]);
        return new mapEntry(name, value);
    }

    protected Object readGenericValue(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String name = node.getName();
        if (name.equalsIgnoreCase("BYTES")) {
            return this.readGenericBytes(node);
        }
        if (name.equalsIgnoreCase("LONG")) {
            return this.readGenericLong(node);
        }
        if (name.equalsIgnoreCase("LIST")) {
            return this.readGenericList(node);
        }
        if (name.equalsIgnoreCase("MAP")) {
            return this.readGenericMap(node);
        }
        throw new TOTorrentException("Additional property invalid, sub-key '" + name + "' not recognised", 6);
    }

    protected byte[] readGenericBytes(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String value = node.getValue();
        byte[] res = new byte[value.length() / 2];
        int i = 0;
        while (i < res.length) {
            res[i] = (byte)Integer.parseInt(value.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return res;
    }

    protected Long readGenericLong(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        String value = node.getValue();
        try {
            return new Long(value);
        }
        catch (Throwable e) {
            throw new TOTorrentException("long value invalid for '" + node.getName() + "'", 6);
        }
    }

    protected Map readGenericMap(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        int i = 0;
        while (i < kids.length) {
            mapEntry entry2 = this.readGenericMapEntry(kids[i]);
            res.put(entry2.name, entry2.value);
            ++i;
        }
        return res;
    }

    protected byte[] readLocalisableString(SimpleXMLParserDocumentNode kid) throws TOTorrentException {
        SimpleXMLParserDocumentAttribute attr = kid.getAttribute("encoding");
        if (attr == null || attr.getValue().equalsIgnoreCase("bytes")) {
            return this.readGenericBytes(kid);
        }
        try {
            return kid.getValue().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TOTorrentException("bytes invalid - unsupported encoding", 6);
        }
    }

    protected List readGenericList(SimpleXMLParserDocumentNode node) throws TOTorrentException {
        ArrayList<Object> res = new ArrayList<Object>();
        SimpleXMLParserDocumentNode[] kids = node.getChildren();
        int i = 0;
        while (i < kids.length) {
            res.add(this.readGenericValue(kids[i]));
            ++i;
        }
        return res;
    }

    protected class mapEntry {
        String name;
        Object value;

        mapEntry(String _name, Object _value) {
            this.name = _name;
            this.value = _value;
        }
    }
}

