/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;

public class TOTorrentFileImpl
implements TOTorrentFile {
    protected TOTorrent torrent;
    protected long file_length;
    protected byte[][] path_components;
    protected Map additional_properties = new HashMap();
    protected boolean is_utf8;

    protected TOTorrentFileImpl(TOTorrent _torrent, long _len, String _path) throws TOTorrentException {
        this.torrent = _torrent;
        this.is_utf8 = true;
        try {
            this.file_length = _len;
            Vector<byte[]> temp = new Vector<byte[]>();
            int pos = 0;
            while (true) {
                int p1;
                if ((p1 = _path.indexOf(File.separator, pos)) == -1) break;
                temp.add(_path.substring(pos, p1).getBytes("UTF8"));
                pos = p1 + 1;
            }
            temp.add(_path.substring(pos).getBytes("UTF8"));
            this.path_components = new byte[temp.size()][];
            temp.copyInto((Object[])this.path_components);
            this.checkComponents();
        }
        catch (UnsupportedEncodingException e) {
            throw new TOTorrentException("Unsupported encoding for '" + _path + "'", 7);
        }
    }

    protected TOTorrentFileImpl(TOTorrent _torrent, long _len, byte[][] _path_components) throws TOTorrentException {
        this.torrent = _torrent;
        this.file_length = _len;
        this.path_components = _path_components;
        this.checkComponents();
    }

    protected void checkComponents() throws TOTorrentException {
        int i = 0;
        while (i < this.path_components.length) {
            byte[] comp = this.path_components[i];
            if (comp.length == 2 && comp[0] == 46 && comp[1] == 46) {
                throw new TOTorrentException("Torrent file contains illegal '..' component", 6);
            }
            ++i;
        }
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public long getLength() {
        return this.file_length;
    }

    public byte[][] getPathComponents() {
        return this.path_components;
    }

    protected boolean isUTF8() {
        return this.is_utf8;
    }

    protected void setAdditionalProperty(String name, Object value) {
        this.additional_properties.put(name, value);
    }

    protected Map getAdditionalProperties() {
        return this.additional_properties;
    }
}

