/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport.base;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LGLogger;
import org.gudy.azureus2.core3.peer.PEPeerServerListener;
import org.gudy.azureus2.core3.peer.impl.PEPeerServerAdapter;
import org.gudy.azureus2.core3.peer.impl.PEPeerServerHelper;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.transport.base.PEPeerTransportImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class PEPeerServerImpl
extends AEThread
implements PEPeerServerHelper {
    public static final int componentID = 4;
    public static final int evtLyfeCycle = 0;
    public static final int evtNewConnection = 1;
    public static final int evtErrors = 2;
    protected static serverHelperDelegate server_delegate;
    private static AEMonitor class_mon;
    int TCPListenPort;
    private ServerSocketChannel sck;
    private boolean bContinue;
    private PEPeerServerAdapter adapter;

    static {
        class_mon = new AEMonitor("PEPeerServer");
    }

    public static PEPeerServerHelper create() {
        try {
            class_mon.enter();
            int port = COConfigurationManager.getIntParameter("TCP.Listen.Port", 6881);
            if (server_delegate != null) {
                server_delegate.setPort(port);
            } else {
                COConfigurationManager.addParameterListener("TCP.Listen.Port", new ParameterListener(){

                    public void parameterChanged(String param) {
                        PEPeerServerImpl.create();
                    }
                });
                server_delegate = new serverHelperDelegate(port);
            }
            serverHelperDelegate serverHelperDelegate2 = server_delegate;
            class_mon.exit();
            return serverHelperDelegate2;
        }
        catch (Throwable throwable) {
            class_mon.exit();
            throw throwable;
        }
    }

    private PEPeerServerImpl(int _port) {
        super("PEPeerServer:port=" + _port);
        String bindIP = COConfigurationManager.getStringParameter("Bind IP", "");
        this.TCPListenPort = _port;
        this.sck = null;
        this.bContinue = true;
        this.setPriority(1);
        try {
            this.sck = ServerSocketChannel.open();
            this.sck.socket().setReuseAddress(true);
            int rcv_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
            if (rcv_size > 0) {
                this.sck.socket().setReceiveBufferSize(rcv_size);
            }
            if (bindIP.length() < 7) {
                this.sck.socket().bind(new InetSocketAddress(this.TCPListenPort));
            } else {
                this.sck.socket().bind(new InetSocketAddress(InetAddress.getByName(bindIP), this.TCPListenPort));
            }
        }
        catch (Exception e) {
            LGLogger.log(4, 2, 3, "PEPeerServer was unable to bind port " + this.TCPListenPort + ", reason : " + e);
            if (this.sck != null && this.sck.isOpen()) {
                try {
                    this.sck.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.sck = null;
        }
        if (this.sck != null) {
            LGLogger.log(4, 0, 0, "PEPeerServer is bound on port " + this.TCPListenPort);
        } else {
            LGLogger.log(4, 0, 0, "BT was unable to bind to port " + this.TCPListenPort);
        }
    }

    public void runSupport() {
        LGLogger.log(4, 0, 0, "PEPeerServer is ready to accept incoming connections");
        long successfull_accepts = 0L;
        long failed_accepts = 0L;
        while (this.bContinue) {
            try {
                SocketChannel sckClient = this.sck.accept();
                ++successfull_accepts;
                if (sckClient != null) {
                    String ip_tos;
                    LGLogger.log(4, 1, 1, "PEPeerServer has accepted an incoming connection from : " + sckClient.socket().getInetAddress().getHostAddress());
                    int snd_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF");
                    if (snd_size > 0) {
                        sckClient.socket().setSendBufferSize(snd_size);
                    }
                    if ((ip_tos = COConfigurationManager.getStringParameter("network.tcp.socket.IPTOS")).length() > 0) {
                        sckClient.socket().setTrafficClass(Integer.decode(ip_tos));
                    }
                    sckClient.configureBlocking(false);
                    this.adapter.addPeerTransport(sckClient);
                    sckClient = null;
                    continue;
                }
                LGLogger.log(4, 0, 0, "PEPeerServer SocketChannel is null");
                Thread.sleep(1000L);
            }
            catch (Throwable e) {
                LGLogger.log("PEPeerServer: listener failed on port " + this.TCPListenPort, e);
                if (++failed_accepts <= 100L || successfull_accepts != 0L) continue;
                LGLogger.logUnrepeatableAlertUsingResource(3, "Network.alert.acceptfail", new String[]{"" + this.TCPListenPort, "TCP"});
                break;
            }
        }
        LGLogger.log(4, 0, 0, "PEPeerServer is stopped");
    }

    public PEPeerTransport createPeerTransport(Object param) {
        return new PEPeerTransportImpl(this.adapter.getControl(), (SocketChannel)param, null);
    }

    public void startServer() {
        this.setDaemon(true);
        this.start();
    }

    public void stopServer() {
        this.bContinue = false;
        try {
            LGLogger.log(4, 0, 0, "PEPeerServer is stopping");
            this.sck.close();
        }
        catch (Exception e) {
            LGLogger.log(4, 2, 3, "Error catched while stopping server : " + e);
        }
    }

    public int getPort() {
        return this.TCPListenPort;
    }

    public void setServerAdapter(PEPeerServerAdapter _adapter) {
        this.adapter = _adapter;
    }

    public void clearServerAdapter() {
        this.adapter = null;
    }

    public void addListener(PEPeerServerListener l) {
    }

    public void removeListener(PEPeerServerListener l) {
    }

    /* synthetic */ PEPeerServerImpl(int n, PEPeerServerImpl pEPeerServerImpl) {
        this(n);
    }

    protected static class serverHelperDelegate
    implements PEPeerServerHelper {
        protected PEPeerServerHelper _delegate;
        protected int port;
        protected boolean started;
        protected PEPeerServerAdapter adapter;
        protected List listeners = new ArrayList();

        protected serverHelperDelegate(int _port) {
            this.port = _port;
            this._delegate = new PEPeerServerImpl(this.port, null);
        }

        protected void setPort(int _port) {
            if (this.started) {
                this._delegate.stopServer();
            }
            this._delegate.clearServerAdapter();
            this.port = _port;
            this._delegate = new PEPeerServerImpl(this.port, null);
            if (this.adapter != null) {
                this._delegate.setServerAdapter(this.adapter);
            }
            if (this.started) {
                this._delegate.startServer();
            }
            int i = 0;
            while (i < this.listeners.size()) {
                ((PEPeerServerListener)this.listeners.get(i)).portChanged(this.port);
                ++i;
            }
        }

        public int getPort() {
            return this.port;
        }

        public void startServer() {
            this.started = true;
            PEPeerServerHelper delegate = this._delegate;
            if (delegate == null) {
                Debug.out("PEPeerServer::serverHelperDelegate::startServer: delegate is null");
            } else {
                delegate.startServer();
            }
        }

        public void stopServer() {
            this.started = false;
            PEPeerServerHelper delegate = this._delegate;
            if (delegate == null) {
                Debug.out("PEPeerServer::serverHelperDelegate::stopServer: delegate is null");
            } else {
                delegate.stopServer();
            }
        }

        public void setServerAdapter(PEPeerServerAdapter _adapter) {
            this.adapter = _adapter;
            PEPeerServerHelper delegate = this._delegate;
            if (delegate == null) {
                Debug.out("PEPeerServer::serverHelperDelegate::setServerAdapter: delegate is null");
            } else {
                delegate.setServerAdapter(this.adapter);
            }
        }

        public void clearServerAdapter() {
            this.adapter = null;
            PEPeerServerHelper delegate = this._delegate;
            if (delegate == null) {
                Debug.out("PEPeerServer::serverHelperDelegate::clearServerAdapter: delegate is null");
            } else {
                delegate.clearServerAdapter();
            }
        }

        public PEPeerTransport createPeerTransport(Object param) {
            PEPeerServerHelper delegate = this._delegate;
            if (delegate == null) {
                Debug.out("PEPeerServer::serverHelperDelegate::createPeerTransport: delegate is null");
                return null;
            }
            return delegate.createPeerTransport(param);
        }

        public void addListener(PEPeerServerListener l) {
            this.listeners.add(l);
        }

        public void removeListener(PEPeerServerListener l) {
            this.listeners.remove(l);
        }
    }
}

