/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.util.Average;

public class PEPeerManagerStatsImpl
implements PEPeerManagerStats {
    private long totalReceived;
    private long totalSent;
    private long totalDiscarded;
    private long totalHave;
    private Average receptionSpeed = Average.getInstance(1000, 10);
    private Average sendingSpeed = Average.getInstance(1000, 5);
    private Average overallSpeed = Average.getInstance(5000, 100);

    public void discarded(int length) {
        this.totalDiscarded += (long)length;
    }

    public void received(int length) {
        this.totalReceived += (long)length;
        this.receptionSpeed.addValue(length);
    }

    public void sent(int length) {
        this.totalSent += (long)length;
        this.sendingSpeed.addValue(length);
    }

    public void haveNewPiece(int pieceLength) {
        this.totalHave += (long)pieceLength;
        this.overallSpeed.addValue(pieceLength);
    }

    public long getDownloadAverage() {
        return this.receptionSpeed.getAverage();
    }

    public long getUploadAverage() {
        return this.sendingSpeed.getAverage();
    }

    public long getTotalDiscarded() {
        return this.totalDiscarded;
    }

    public void setTotalDiscarded(long total) {
        this.totalDiscarded = total;
    }

    public long getTotalSent() {
        return this.totalSent;
    }

    public long getTotalReceived() {
        return this.totalReceived;
    }

    public long getTotalAverage() {
        return this.overallSpeed.getAverage();
    }
}

