/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.util.Debug;

public class LocaleUtilDecoderReal
implements LocaleUtilDecoder {
    protected CharsetDecoder decoder;
    protected int index;

    protected LocaleUtilDecoderReal(int _index, CharsetDecoder _decoder) {
        this.index = _index;
        this.decoder = _decoder;
    }

    public String getName() {
        return this.decoder.charset().name();
    }

    public int getIndex() {
        return this.index;
    }

    public String tryDecode(byte[] array, boolean lax) {
        try {
            ByteBuffer bb = ByteBuffer.wrap(array);
            CharBuffer cb = CharBuffer.allocate(array.length);
            CoderResult cr = this.decoder.decode(bb, cb, true);
            if (!cr.isError()) {
                cb.flip();
                String str = cb.toString();
                if (lax) {
                    return str;
                }
                byte[] b2 = str.getBytes(this.getName());
                if (Arrays.equals(array, b2)) {
                    return str;
                }
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String decodeString(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        CharBuffer cb = CharBuffer.allocate(bytes.length);
        CoderResult cr = this.decoder.decode(bb, cb, true);
        try {
            if (!cr.isError()) {
                cb.flip();
                String str = cb.toString();
                byte[] b2 = str.getBytes(this.decoder.charset().name());
                if (Arrays.equals(bytes, b2)) {
                    return str;
                }
            }
        }
        catch (Throwable str) {
            // empty catch block
        }
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            return new String(bytes);
        }
    }
}

