/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.upnp;

import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPMappingListener;
import com.aelitis.azureus.plugins.upnp.UPnPMappingManagerListener;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;

public class UPnPMappingManager {
    protected static UPnPMappingManager singleton = new UPnPMappingManager();
    protected List mappings = new ArrayList();
    protected List listeners = new ArrayList();

    public static UPnPMappingManager getSingleton() {
        return singleton;
    }

    protected UPnPMappingManager() {
        this.addConfigPort("upnp.mapping.dataportudp", false, "Server Enable UDP", "TCP.Listen.Port");
        this.addConfigPort("upnp.mapping.dataport", true, "TCP.Listen.Port", true);
        this.addConfigPort("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port");
        this.addConfigPort("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL");
        this.addConfigPort("upnp.mapping.udptrackerport", false, "Tracker Port UDP Enable", "Tracker Port");
    }

    protected UPnPMapping addConfigPort(String name_resource, boolean tcp, final String int_param_name, boolean enabled) {
        int value = COConfigurationManager.getIntParameter(int_param_name);
        final UPnPMapping mapping = this.addMapping(name_resource, tcp, value, enabled);
        COConfigurationManager.addParameterListener(int_param_name, new ParameterListener(){

            public void parameterChanged(String name) {
                mapping.setPort(COConfigurationManager.getIntParameter(int_param_name));
            }
        });
        return mapping;
    }

    protected UPnPMapping addConfigPort(String name_resource, boolean tcp, final String enabler_param_name, String int_param_name) {
        boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
        final UPnPMapping mapping = this.addConfigPort(name_resource, tcp, int_param_name, enabled);
        COConfigurationManager.addParameterListener(enabler_param_name, new ParameterListener(){

            public void parameterChanged(String name) {
                mapping.setEnabled(COConfigurationManager.getBooleanParameter(enabler_param_name));
            }
        });
        return mapping;
    }

    public UPnPMapping addMapping(String desc_resource, boolean tcp, int port, boolean enabled) {
        UPnPMapping mapping = new UPnPMapping(desc_resource, tcp, port, enabled);
        this.mappings.add(mapping);
        this.added(mapping);
        return mapping;
    }

    public UPnPMapping[] getMappings() {
        UPnPMapping[] res = new UPnPMapping[this.mappings.size()];
        this.mappings.toArray(res);
        return res;
    }

    public UPnPMapping getMapping(boolean tcp, int port) {
        int i = 0;
        while (i < this.mappings.size()) {
            UPnPMapping mapping = (UPnPMapping)this.mappings.get(i);
            if (mapping.isTCP() == tcp && mapping.getPort() == port) {
                return mapping;
            }
            ++i;
        }
        return null;
    }

    protected void added(UPnPMapping mapping) {
        mapping.addListener(new UPnPMappingListener(){

            public void mappingChanged(UPnPMapping mapping) {
            }

            public void mappingDestroyed(UPnPMapping mapping) {
                UPnPMappingManager.this.mappings.remove(mapping);
            }
        });
        int i = 0;
        while (i < this.listeners.size()) {
            ((UPnPMappingManagerListener)this.listeners.get(i)).mappingAdded(mapping);
            ++i;
        }
    }

    public void addListener(UPnPMappingManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UPnPMappingManagerListener l) {
        this.listeners.remove(l);
    }
}

