/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager;

import com.aelitis.azureus.core.networkmanager.ByteBucket;
import com.aelitis.azureus.core.networkmanager.Connection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.peermanager.LimitedRateGroup;
import com.aelitis.azureus.core.peermanager.UploadEntityController;
import com.aelitis.azureus.core.peermanager.messages.ProtocolMessage;
import java.util.HashMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEMonitor;

public class UploadManager {
    private static final int UNLIMITED_WRITE_RATE = 0x6400000;
    private static final UploadManager instance = new UploadManager();
    private int standard_max_rate_bps;
    private final ByteBucket standard_bucket;
    private final HashMap standard_peer_connections = new HashMap();
    private final AEMonitor standard_peer_connections_mon = new AEMonitor("UploadManager:SPC");
    private final UploadEntityController standard_entity_controller;
    private final HashMap group_buckets = new HashMap();
    private final AEMonitor group_buckets_mon = new AEMonitor("UploadManager:GB");

    private UploadManager() {
        int max_rateKBs = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
        this.standard_max_rate_bps = max_rateKBs == 0 ? 0x6400000 : max_rateKBs * 1024;
        COConfigurationManager.addParameterListener("Max Upload Speed KBs", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                int rateKBs = COConfigurationManager.getIntParameter("Max Upload Speed KBs");
                UploadManager.this.standard_max_rate_bps = rateKBs == 0 ? 0x6400000 : rateKBs * 1024;
            }
        });
        this.standard_bucket = new ByteBucket(this.standard_max_rate_bps);
        this.standard_entity_controller = new UploadEntityController(new RateHandler(){

            public int getCurrentNumBytesAllowed() {
                if (UploadManager.this.standard_bucket.getRate() != UploadManager.this.standard_max_rate_bps) {
                    UploadManager.this.standard_bucket.setRate(UploadManager.this.standard_max_rate_bps);
                }
                return UploadManager.this.standard_bucket.getAvailableByteCount();
            }

            public void bytesWritten(int num_bytes_written) {
                UploadManager.this.standard_bucket.setBytesUsed(num_bytes_written);
            }
        });
    }

    public static UploadManager getSingleton() {
        return instance;
    }

    public void registerStandardPeerConnection(final Connection connection, final LimitedRateGroup group) {
        GroupData group_data;
        final ConnectionData conn_data = new ConnectionData();
        OutgoingMessageQueue.MessageQueueListener listener = new OutgoingMessageQueue.MessageQueueListener(){

            public void messageAdded(ProtocolMessage message) {
                if (message.getType() == 7 && conn_data.state == 0) {
                    UploadManager.this.standard_entity_controller.upgradePeerConnection(connection, new RateHandler(this, group, conn_data){
                        final /* synthetic */ 3 this$1;
                        private final /* synthetic */ LimitedRateGroup val$group;
                        private final /* synthetic */ ConnectionData val$conn_data;
                        {
                            this.this$1 = var1_1;
                            this.val$group = limitedRateGroup;
                            this.val$conn_data = connectionData2;
                        }

                        public int getCurrentNumBytesAllowed() {
                            if (UploadManager.access$1(3.access$0(this.this$1)).getRate() != UploadManager.access$2(3.access$0(this.this$1))) {
                                UploadManager.access$1(3.access$0(this.this$1)).setRate(UploadManager.access$2(3.access$0(this.this$1)));
                            }
                            int group_rate = UploadManager.access$4(3.access$0(this.this$1), this.val$group);
                            if (ConnectionData.access$1(this.val$conn_data).getRate() != group_rate) {
                                ConnectionData.access$1(this.val$conn_data).setRate(group_rate);
                            }
                            int group_allowed = ConnectionData.access$1(this.val$conn_data).getAvailableByteCount();
                            int global_allowed = UploadManager.access$1(3.access$0(this.this$1)).getAvailableByteCount();
                            if (UploadManager.access$3(3.access$0(this.this$1)).isGeneralPoolWriteNeeded() && (global_allowed -= NetworkManager.getSingleton().getTcpMssSize()) < 0) {
                                global_allowed = 0;
                            }
                            int allowed = group_allowed > global_allowed ? global_allowed : group_allowed;
                            return allowed;
                        }

                        public void bytesWritten(int num_bytes_written) {
                            ConnectionData.access$1(this.val$conn_data).setBytesUsed(num_bytes_written);
                            UploadManager.access$1(3.access$0(this.this$1)).setBytesUsed(num_bytes_written);
                        }
                    });
                    conn_data.state = 1;
                }
            }

            public void messageSent(ProtocolMessage message) {
                if (message.getType() == 0 && conn_data.state == 1) {
                    UploadManager.this.standard_entity_controller.downgradePeerConnection(connection);
                    conn_data.state = 0;
                }
            }

            public void messageRemoved(ProtocolMessage message) {
            }

            public void protocolBytesSent(int byte_count) {
            }

            public void dataBytesSent(int byte_count) {
            }

            static /* synthetic */ UploadManager access$0(3 var0) {
                return var0.UploadManager.this;
            }
        };
        try {
            this.group_buckets_mon.enter();
            group_data = (GroupData)this.group_buckets.get(group);
            if (group_data == null) {
                int limit = this.getTranslatedLimit(group);
                group_data = new GroupData(new ByteBucket(limit));
                this.group_buckets.put(group, group_data);
            }
            GroupData groupData = group_data;
            groupData.group_size = groupData.group_size + 1;
        }
        finally {
            this.group_buckets_mon.exit();
        }
        conn_data.group_bucket = group_data.bucket;
        conn_data.queue_listener = listener;
        conn_data.state = 0;
        conn_data.group = group;
        try {
            this.standard_peer_connections_mon.enter();
            this.standard_peer_connections.put(connection, conn_data);
        }
        finally {
            this.standard_peer_connections_mon.exit();
        }
        connection.getOutgoingMessageQueue().registerQueueListener(listener);
        this.standard_entity_controller.registerPeerConnection(connection);
    }

    public void cancelStandardPeerConnection(Connection connection) {
        ConnectionData conn_data = null;
        try {
            this.standard_peer_connections_mon.enter();
            conn_data = (ConnectionData)this.standard_peer_connections.remove(connection);
        }
        finally {
            this.standard_peer_connections_mon.exit();
        }
        if (conn_data != null) {
            connection.getOutgoingMessageQueue().cancelQueueListener(conn_data.queue_listener);
            try {
                this.group_buckets_mon.enter();
                GroupData group_data = (GroupData)this.group_buckets.get(conn_data.group);
                if (group_data.group_size == 1) {
                    this.group_buckets.remove(conn_data.group);
                } else {
                    GroupData groupData = group_data;
                    groupData.group_size = groupData.group_size - 1;
                }
            }
            finally {
                this.group_buckets_mon.exit();
            }
        }
        this.standard_entity_controller.cancelPeerConnection(connection);
    }

    private int getTranslatedLimit(LimitedRateGroup group) {
        int limit = group.getRateLimitBytesPerSecond();
        if (limit == 0) {
            limit = 0x6400000;
        } else if (limit < 0) {
            limit = 0;
        }
        return limit;
    }

    static /* synthetic */ int access$4(UploadManager uploadManager, LimitedRateGroup limitedRateGroup) {
        return uploadManager.getTranslatedLimit(limitedRateGroup);
    }

    private static class ConnectionData {
        private static final int STATE_NORMAL = 0;
        private static final int STATE_UPGRADED = 1;
        private OutgoingMessageQueue.MessageQueueListener queue_listener;
        private int state;
        private LimitedRateGroup group;
        private ByteBucket group_bucket;

        ConnectionData() {
        }

        static /* synthetic */ ByteBucket access$1(ConnectionData connectionData2) {
            return connectionData2.group_bucket;
        }
    }

    private static class GroupData {
        private final ByteBucket bucket;
        private int group_size = 0;

        GroupData(ByteBucket bucket) {
            this.bucket = bucket;
        }
    }
}

