/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager;

import com.aelitis.azureus.core.networkmanager.Connection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RateControlledWriteEntity;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.peermanager.messages.ProtocolMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PacketFillingMultiPeerUploader
implements RateControlledWriteEntity {
    private static final int FLUSH_CHECK_LOOP_TIME = 250;
    private static final int FLUSH_WAIT_TIME = 3000;
    private final RateHandler rate_handler;
    private boolean destroyed = false;
    private final HashMap waiting_connections = new HashMap();
    private final LinkedList ready_connections = new LinkedList();
    private final AEMonitor lists_lock = new AEMonitor("PacketFillingMultiPeerUploader:lists_lock");

    public PacketFillingMultiPeerUploader(RateHandler rate_handler) {
        this.rate_handler = rate_handler;
        AEThread flush_checker = new AEThread("PacketFillingMultiPeerUploader:FlushChecker"){

            public void runSupport() {
                PacketFillingMultiPeerUploader.this.flushCheckLoop();
            }
        };
        flush_checker.setDaemon(true);
        flush_checker.start();
    }

    private void flushCheckLoop() {
        while (!this.destroyed) {
            long start_time = SystemTime.getCurrentTime();
            try {
                this.lists_lock.enter();
                long current_time = SystemTime.getCurrentTime();
                Iterator i = this.waiting_connections.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry2 = i.next();
                    PeerData peer_data = (PeerData)entry2.getValue();
                    long wait_time = current_time - peer_data.last_message_added_time;
                    if (wait_time <= 3000L && wait_time >= 0L) continue;
                    Connection conn = (Connection)entry2.getKey();
                    if (conn.getOutgoingMessageQueue().getTotalSize() > 0) {
                        conn.getOutgoingMessageQueue().cancelQueueListener(peer_data.queue_listener);
                        i.remove();
                        this.addToReadyList(conn);
                        continue;
                    }
                    peer_data.last_message_added_time = current_time;
                }
            }
            finally {
                this.lists_lock.exit();
            }
            long total_time = SystemTime.getCurrentTime() - start_time;
            if (total_time >= 250L || total_time < 0L) continue;
            try {
                Thread.sleep(250L - total_time);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void destroy() {
        this.destroyed = true;
        try {
            this.lists_lock.enter();
            Iterator i = this.waiting_connections.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry2 = i.next();
                Connection conn = (Connection)entry2.getKey();
                PeerData data = (PeerData)entry2.getValue();
                conn.getOutgoingMessageQueue().cancelQueueListener(data.queue_listener);
            }
            this.waiting_connections.clear();
            this.ready_connections.clear();
        }
        finally {
            this.lists_lock.exit();
        }
    }

    public void addPeerConnection(Connection peer_connection) {
        int mss_size = NetworkManager.getSingleton().getTcpMssSize();
        boolean has_urgent_data = peer_connection.getOutgoingMessageQueue().hasUrgentMessage();
        int num_bytes_ready = peer_connection.getOutgoingMessageQueue().getTotalSize();
        if (num_bytes_ready >= mss_size || has_urgent_data) {
            this.addToReadyList(peer_connection);
        } else {
            this.addToWaitingList(peer_connection);
        }
    }

    public boolean removePeerConnection(Connection peer_connection) {
        block5: {
            block4: {
                try {
                    this.lists_lock.enter();
                    PeerData peer_data = (PeerData)this.waiting_connections.remove(peer_connection);
                    if (peer_data == null) break block4;
                    peer_connection.getOutgoingMessageQueue().cancelQueueListener(peer_data.queue_listener);
                    this.lists_lock.exit();
                    return true;
                }
                catch (Throwable throwable) {
                    this.lists_lock.exit();
                    throw throwable;
                }
            }
            if (!this.ready_connections.remove(peer_connection)) break block5;
            this.lists_lock.exit();
            return true;
        }
        this.lists_lock.exit();
        return false;
    }

    private void addToWaitingList(final Connection conn) {
        final PeerData peer_data = new PeerData();
        OutgoingMessageQueue.MessageQueueListener listener = new OutgoingMessageQueue.MessageQueueListener(){

            public void messageAdded(ProtocolMessage message) {
                try {
                    PacketFillingMultiPeerUploader.this.lists_lock.enter();
                    if (PacketFillingMultiPeerUploader.this.waiting_connections.get(conn) == null) {
                        PacketFillingMultiPeerUploader.this.lists_lock.exit();
                        return;
                    }
                    int mss_size = NetworkManager.getSingleton().getTcpMssSize();
                    boolean has_urgent_data = conn.getOutgoingMessageQueue().hasUrgentMessage();
                    int num_bytes_ready = conn.getOutgoingMessageQueue().getTotalSize();
                    if (num_bytes_ready >= mss_size || has_urgent_data) {
                        PacketFillingMultiPeerUploader.this.waiting_connections.remove(conn);
                        conn.getOutgoingMessageQueue().cancelQueueListener(this);
                        PacketFillingMultiPeerUploader.this.addToReadyList(conn);
                    } else {
                        peer_data.last_message_added_time = SystemTime.getCurrentTime();
                    }
                }
                finally {
                    PacketFillingMultiPeerUploader.this.lists_lock.exit();
                }
            }

            public void messageRemoved(ProtocolMessage message) {
            }

            public void messageSent(ProtocolMessage message) {
            }

            public void protocolBytesSent(int byte_count) {
            }

            public void dataBytesSent(int byte_count) {
            }
        };
        peer_data.queue_listener = listener;
        peer_data.last_message_added_time = SystemTime.getCurrentTime();
        try {
            this.lists_lock.enter();
            this.waiting_connections.put(conn, peer_data);
            conn.getOutgoingMessageQueue().registerQueueListener(listener);
        }
        finally {
            this.lists_lock.exit();
        }
    }

    private void addToReadyList(Connection conn) {
        if (conn.getOutgoingMessageQueue().getTotalSize() < 1) {
            Debug.out("~~~ added conn size < 1 ");
        }
        try {
            this.lists_lock.enter();
            this.ready_connections.addLast(conn);
        }
        finally {
            this.lists_lock.exit();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int write(int num_bytes_to_write) {
        Connection conn;
        if (num_bytes_to_write < 1) {
            Debug.out("num_bytes_to_write < 1");
            return 0;
        }
        HashMap<Connection, IOException> connections_to_notify_of_exception = new HashMap<Connection, IOException>();
        ArrayList<Connection> manual_notifications = new ArrayList<Connection>();
        int num_bytes_remaining = num_bytes_to_write;
        try {
            this.lists_lock.enter();
            int num_unusable_connections = 0;
            while (num_bytes_remaining > 0 && num_unusable_connections < this.ready_connections.size()) {
                int num_bytes_available;
                conn = (Connection)this.ready_connections.removeFirst();
                if (!conn.getTransport().isReadyForWrite()) {
                    this.ready_connections.addLast(conn);
                    ++num_unusable_connections;
                    continue;
                }
                int total_size = conn.getOutgoingMessageQueue().getTotalSize();
                if (total_size < 1) {
                    this.addToWaitingList(conn);
                    continue;
                }
                int mss_size = NetworkManager.getSingleton().getTcpMssSize();
                int num_bytes_allowed = num_bytes_remaining > mss_size ? mss_size : num_bytes_remaining;
                int n = num_bytes_available = total_size > mss_size ? mss_size : total_size;
                if (num_bytes_allowed >= num_bytes_available) {
                    int written = 0;
                    try {
                        written = conn.getOutgoingMessageQueue().deliverToTransport(conn.getTransport(), num_bytes_available, true);
                        if (written > 0) {
                            manual_notifications.add(conn);
                        }
                        boolean has_urgent_data = conn.getOutgoingMessageQueue().hasUrgentMessage();
                        int remaining = conn.getOutgoingMessageQueue().getTotalSize();
                        if (remaining >= mss_size || has_urgent_data) {
                            this.ready_connections.addLast(conn);
                            num_unusable_connections = 0;
                        } else {
                            this.addToWaitingList(conn);
                        }
                    }
                    catch (IOException e) {
                        connections_to_notify_of_exception.put(conn, e);
                        this.addToWaitingList(conn);
                    }
                    num_bytes_remaining -= written;
                    continue;
                }
                this.ready_connections.addLast(conn);
                ++num_unusable_connections;
            }
        }
        finally {
            this.lists_lock.exit();
        }
        int i = 0;
        while (i < manual_notifications.size()) {
            conn = (Connection)manual_notifications.get(i);
            conn.getOutgoingMessageQueue().doListenerNotifications();
            ++i;
        }
        Iterator i2 = connections_to_notify_of_exception.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry entry2 = i2.next();
            Connection conn2 = (Connection)entry2.getKey();
            IOException exception = (IOException)entry2.getValue();
            conn2.notifyOfException(exception);
        }
        int num_bytes_written = num_bytes_to_write - num_bytes_remaining;
        if (num_bytes_written > 0) {
            this.rate_handler.bytesWritten(num_bytes_written);
        }
        return num_bytes_written;
    }

    public boolean hasWriteDataAvailable() {
        return !this.ready_connections.isEmpty();
    }

    public boolean canWrite() {
        if (this.ready_connections.isEmpty()) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public boolean doWrite() {
        return this.write(this.rate_handler.getCurrentNumBytesAllowed()) > 0;
    }

    public int getPriority() {
        return 1;
    }

    private static class PeerData {
        private OutgoingMessageQueue.MessageQueueListener queue_listener;
        private long last_message_added_time;

        PeerData() {
        }
    }
}

