/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFile;
import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.FMFileOwner;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.FileUtil;

public abstract class FMFileImpl
implements FMFile {
    protected static final int WRITE_RETRY_LIMIT = 10;
    protected static final int WRITE_RETRY_DELAY = 100;
    protected static final boolean DEBUG = true;
    protected static final boolean DEBUG_VERBOSE = false;
    protected static Map file_map = new HashMap();
    protected static AEMonitor file_map_mon = new AEMonitor("FMFile:map");
    protected FMFileOwner owner;
    protected int access_mode = 1;
    protected File file;
    protected String canonical_path;
    protected RandomAccessFile raf;
    protected AEMonitor this_mon = new AEMonitor("FMFile");

    protected FMFileImpl(FMFileOwner _owner, File _file) throws FMFileManagerException {
        this.owner = _owner;
        this.file = _file;
        try {
            this.canonical_path = this.file.getCanonicalPath();
            this.reserveFile();
        }
        catch (Throwable e) {
            throw new FMFileManagerException("getCanonicalPath fails", e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getAccessMode() {
        return this.access_mode;
    }

    public void moveFile(File new_file) throws FMFileManagerException {
        block12: {
            try {
                String new_canonical_path;
                this.this_mon.enter();
                try {
                    new_canonical_path = new_file.getCanonicalPath();
                }
                catch (Throwable e) {
                    throw new FMFileManagerException("getCanonicalPath fails", e);
                }
                if (new_file.exists()) {
                    throw new FMFileManagerException("moveFile fails - file '" + new_canonical_path + "' already exists");
                }
                boolean was_open = this.raf != null;
                this.close();
                if (FileUtil.renameFile(this.file, new_file)) {
                    this.file = new_file;
                    this.canonical_path = new_canonical_path;
                    this.reserveFile();
                    this.openSupport();
                    break block12;
                }
                try {
                    this.reserveFile();
                }
                catch (FMFileManagerException e) {
                    Debug.printStackTrace(e);
                }
                if (was_open) {
                    try {
                        this.openSupport();
                    }
                    catch (FMFileManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
                throw new FMFileManagerException("moveFile fails");
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    public void ensureOpen() throws FMFileManagerException {
        try {
            this.this_mon.enter();
            if (this.raf != null) {
                this.this_mon.exit();
                return;
            }
            if (this.raf == null) {
                this.openSupport();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getLengthSupport() throws FMFileManagerException {
        try {
            return this.raf.length();
        }
        catch (Throwable e) {
            throw new FMFileManagerException("getLength fails", e);
        }
    }

    protected void setLengthSupport(long length) throws FMFileManagerException {
        try {
            this.raf.setLength(length);
        }
        catch (Throwable e) {
            throw new FMFileManagerException("setLength fails", e);
        }
    }

    protected long getSizeSupport() throws FMFileManagerException {
        if (this.raf == null) {
            throw new FMFileManagerException("getSize: raf is null");
        }
        try {
            FileChannel channel = this.raf.getChannel();
            if (channel.isOpen()) {
                return channel.size();
            }
            Debug.out("FileChannel is not open");
            throw new FMFileManagerException("getSize: channel not open");
        }
        catch (Throwable e) {
            throw new FMFileManagerException("getSize fails", e);
        }
    }

    protected void openSupport() throws FMFileManagerException {
        if (this.raf != null) {
            this.closeSupport(true);
        }
        try {
            this.raf = new RandomAccessFile(this.file, this.access_mode == 1 ? "r" : "rwd");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new FMFileManagerException("open fails", e);
        }
    }

    protected void closeSupport(boolean explicit) throws FMFileManagerException {
        if (this.raf == null) {
            if (explicit) {
                this.releaseFile();
            }
            return;
        }
        try {
            try {
                this.raf.close();
            }
            catch (Throwable e) {
                throw new FMFileManagerException("close fails", e);
            }
        }
        finally {
            this.raf = null;
            if (explicit) {
                this.releaseFile();
            }
        }
    }

    protected void readSupport(DirectByteBuffer buffer, long offset) throws FMFileManagerException {
        if (this.raf == null) {
            throw new FMFileManagerException("read: raf is null");
        }
        FileChannel fc = this.raf.getChannel();
        if (!fc.isOpen()) {
            Debug.out("FileChannel is closed: " + this.file.getAbsolutePath());
            throw new FMFileManagerException("read - file is closed");
        }
        long lRemainingBeforeRead = buffer.remaining((byte)4);
        try {
            fc.position(offset);
            while (fc.position() < fc.size() && buffer.hasRemaining((byte)4)) {
                buffer.read((byte)4, fc);
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            throw new FMFileManagerException("read fails", e);
        }
    }

    protected void writeSupport(DirectByteBuffer buffer, long position) throws FMFileManagerException {
        this.writeSupport(new DirectByteBuffer[]{buffer}, position);
    }

    protected void writeSupport(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        block14: {
            if (this.raf == null) {
                throw new FMFileManagerException("write fails: raf is null");
            }
            FileChannel fc = this.raf.getChannel();
            try {
                if (fc.isOpen()) {
                    long expected_write = 0L;
                    long actual_write = 0L;
                    boolean partial_write = false;
                    int i = 0;
                    while (i < buffers.length) {
                        expected_write += (long)(buffers[i].limit((byte)4) - buffers[i].position((byte)4));
                        ++i;
                    }
                    fc.position(position);
                    ByteBuffer[] bbs = new ByteBuffer[buffers.length];
                    Buffer last_bb = null;
                    int i2 = 0;
                    while (i2 < bbs.length) {
                        bbs[i2] = buffers[i2].getBuffer((byte)4);
                        if (bbs[i2].position() != bbs[i2].limit()) {
                            last_bb = bbs[i2];
                        }
                        ++i2;
                    }
                    if (last_bb != null) {
                        int loop = 0;
                        while (last_bb.position() != last_bb.limit()) {
                            long written = fc.write(bbs);
                            actual_write += written;
                            if (written > 0L) {
                                loop = 0;
                                if (last_bb.position() == last_bb.limit()) continue;
                                partial_write = true;
                                continue;
                            }
                            if (++loop == 10) {
                                Debug.out("FMFile::write: zero length write - abandoning");
                                throw new FMFileManagerException("write fails: retry limit exceeded");
                            }
                            try {
                                Thread.sleep(100 * loop);
                            }
                            catch (InterruptedException e) {
                                throw new FMFileManagerException("write fails: interrupted");
                            }
                        }
                    }
                    if (expected_write != actual_write) {
                        Debug.out("FMFile::write: **** partial write **** failed: expected = " + expected_write + ", actual = " + actual_write);
                        throw new FMFileManagerException("write fails: expected write/actual write mismatch");
                    }
                    break block14;
                }
                Debug.out("file channel is not open !");
                throw new FMFileManagerException("write fails ");
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
                throw new FMFileManagerException("write fails", e);
            }
        }
    }

    protected void reserveFile() throws FMFileManagerException {
        try {
            file_map_mon.enter();
            FMFileOwner existing_owner = (FMFileOwner)file_map.get(this.canonical_path);
            if (existing_owner == null) {
                file_map.put(this.canonical_path, this.owner);
            } else if (!existing_owner.getName().equals(this.owner.getName())) {
                throw new FMFileManagerException("File '" + this.canonical_path + "' is in use by '" + existing_owner.getName() + "'");
            }
        }
        finally {
            file_map_mon.exit();
        }
    }

    protected void releaseFile() {
        try {
            file_map_mon.enter();
            file_map.remove(this.canonical_path);
        }
        finally {
            file_map_mon.exit();
        }
    }
}

