/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included  with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.system;

import org.apache.avalon.framework.component.Component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The Excalibur Role Manager is used for Excalibur Role Mappings.  All of the
 * information is hard-coded.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 * @version CVS $Revision: 1.3 $ $Date: 2002/01/30 15:44:06 $
 * @since 4.1
 */
public class ExcaliburRoleManager
    extends AbstractRoleManager
{
    /**
     * Default constructor--this RoleManager has no parent.
     */
    public ExcaliburRoleManager()
    {
        super( null );
    }

    /**
     * Alternate constructor--this RoleManager has the specified
     * parent.
     *
     * @param parent  The parent <code>RoleManager</code>.
     */
    public ExcaliburRoleManager(RoleManager parent)
    {
        super( parent, Thread.currentThread().getContextClassLoader() );
    }

    /**
     * Alternate constructor--this RoleManager has the specified
     * parent and a classloader.
     *
     * @param parent  The parent <code>RoleManager</code>.
     */
    public ExcaliburRoleManager(RoleManager parent, ClassLoader loader)
    {
        super( parent, loader );

        HashMap shorts = new HashMap( 10 );
        HashMap classes = new HashMap( 10 );
        HashMap handlers = new HashMap( 10 );

        /* Set up Cache relations */
        setup( shorts, classes, handlers, "cache",
               "org.apache.avalon.excalibur.cache.Cache",
               "org.apache.avalon.excalibur.cache.DefaultCache",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "lru-cache",
               "org.apache.avalon.excalibur.cache.Cache",
               "org.apache.avalon.excalibur.cache.LRUCache",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );

        /* Set up DataSource relations */
        setup( shorts, classes, handlers, "jdbc-datasource",
               "org.apache.avalon.excalibur.datasource.DataSourceComponent",
               "org.apache.avalon.excalibur.datasource.JdbcDataSource",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "j2ee-datasource",
               "org.apache.avalon.excalibur.datasource.DataSourceComponent",
               "org.apache.avalon.excalibur.datasource.J2eeDataSource",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "informix-datasource",
               "org.apache.avalon.excalibur.datasource.DataSourceComponent",
               "org.apache.avalon.excalibur.datasource.InformixDataSource",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );

        /* Set up i18n relations */
        setup( shorts, classes, handlers, "i18n",
               "org.apache.avalon.excalibur.i18n.BundleSelector",
               "org.apache.avalon.excalibur.i18n.BundleSelector",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );

        /* Set up Monitor relations */
        setup( shorts, classes, handlers, "monitor",
               "org.apache.avalon.excalibur.monitor.Monitor",
               "org.apache.avalon.excalibur.monitor.ActiveMonitor",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "passive-monitor",
               "org.apache.avalon.excalibur.monitor.Monitor",
               "org.apache.avalon.excalibur.monitor.PassiveMonitor",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );

        /* Set up XPath relations */
        setup( shorts, classes, handlers, "xalan-xpath",
               "org.apache.avalon.excalibur.xml.xpath.XPathProcessor",
               "org.apache.avalon.excalibur.xml.xpath.XPathProcessorImpl",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );
        setup( shorts, classes, handlers, "jaxpath",
               "org.apache.avalon.excalibur.xml.xpath.XPathProcessor",
               "org.apache.avalon.excalibur.xml.xpath.JaxenProcessorImpl",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );

        /* Set up SourceResolver relations */
        setup( shorts, classes, handlers, "jaxpath",
               "org.apache.avalon.excalibur.source.SourceResolver",
               "org.apache.avalon.excalibur.source.SourceResolverImpl",
               "org.apache.avalon.excalibur.system.handler.ThreadSafeComponentHandler" );

        /* Set up XML parser relations */
        setup( shorts, classes, handlers, "parser",
               "org.apache.avalon.excalibur.xml.Parser",
               "org.apache.avalon.excalibur.xml.JaxpParser",
               "org.apache.avalon.excalibur.system.handler.PoolableComponentHandler" );
        setup( shorts, classes, handlers, "xerces-parser",
               "org.apache.avalon.excalibur.xml.Parser",
               "org.apache.avalon.excalibur.xml.XercesParser",
               "org.apache.avalon.excalibur.system.handler.FactoryComponentHandler" );

        m_shorthands = Collections.unmodifiableMap( shorts );
        m_classNames = Collections.unmodifiableMap( classes );
        m_handlerNames = Collections.unmodifiableMap( handlers );
    }
}
