/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.lang;

import java.util.HashMap;
import java.util.Map;

/**
 * This object represents a Layer in the <code>LayeredThreadContext</code>.
 *
 * Note: LayeredThreadContext assumes Layers are immutable in duplicate() method.
 * 
 * @author <a href="mailto:peter@apache.org">Peter Donald</a>
 */
final class Layer
{
    private Object  m_key;
    private Map     m_map;
    private boolean m_isDivider;

    public Layer( final Object key, final Map map, final boolean isDivider )
    {
        m_key = key;
        m_map = map;
        m_isDivider = isDivider;
    }

    protected boolean matchesKey( final Object other )
    {
        return m_key.equals( other );
    }

    protected boolean isDivider()
    {
        return m_isDivider;
    }

    protected boolean containsKey( final String key )
    {
        return m_map.containsKey( key );
    }

    protected Object get( final String key )
    {
        return m_map.get( key );
    }
}

