/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.profile;

/**
 * The ProfilPoint interface is to mark objects that can be sampled by a
 * Profiler. The interface only has one sampling method to simplify the items
 * that can be sampled.
 *
 * @author <a href="mailto:bloritsch@apache.org">Berin Loritsch</a>
 */
public abstract class AbstractProfilePoint implements ProfilePoint
{
    private final String m_name;

    /**
     * Initializes the ProfilePoint with a name.
     */
    public AbstractProfilePoint( String name )
    {
        m_name = name;
    }

    /**
     * Get the ProfilePoint's name.  The Profiler uses this so that the
     * heading for the sample data makes sense.
     */
    public final String getName()
    {
        return m_name;
    }
}
