.TH ATARI800 1 "March 26, 2009"

.SH NAME
atari800 \- Atari 800 Emulator, Version 2.1.0

.SH SYNOPSIS
\fBatari800\fP [options] [files...]

.SH DESCRIPTION
\fIatari800\fP emulates the Atari 800, Atari 800 XL, Atari 130 XE and
Atari 5200 Games System.

.SS Options

.TP
\fB-help
Print complete and up-to-date list of command line switches
.TP
\fB-v
Print emulator version
.TP
\fB-verbose
Display framerate when exiting
.TP
\fB-config filename
Specify an alternative configuration filename

.TP
\fB-osa_rom filename
Path to file containing Atari Rev.A Operating System.
Used to override paths defined at compile time.
.TP
\fB-osb_rom filename
Path to file containing Atari Rev.B Operating System.
Used to override paths defined at compile time.
.TP
\fB-xlxe_rom filename
Path to file containing Atari XL/XE Operating System.
Used to override paths defined at compile time.
.TP
\fB-5200_rom filename
Path to file containing Atari 5200 Games System ROM.
Used to override paths defined at compile time.
.TP
\fB-basic_rom filename
Path to file containing Atari BASIC ROM.
Used to override paths defined at compile time.

.TP
\fB-atari
Emulate Atari 800
.TP
\fB-xl
Emulate Atari 800 XL
.TP
\fB-xe
Emulate Atari 130 XE
.TP
\fB-320xe
Emulate Atari 320 XE (Compy Shop)
.TP
\fB-rambo
Emulate Atari 320 XE (Rambo)
.TP
\fB-5200
Emulate Atari 5200
.TP
\fB-emuos
Use EmuOS

.TP
\fB-a
Use Atari OS/A for Atari 800
.TP
\fB-b
Use Atari OS/B for Atari 800
.TP
\fB-c
Enable RAM between 0xc000 and 0xcfff in Atari 800

.TP
\fB-axlon <n>
Use Atari 800 Axlon memory expansion: <n> k total RAM
.TP
\fB-axlon0f
Use Axlon shadow at 0x0fc0-0x0fff
.TP
\fB-mosaic <n>
Use 400/800 Mosaic memory expansion: <n> k total RAM

.TP
\fB-pal
Emulate PAL TV mode
.TP
\fB-ntsc
Emulate NTSC TV mode

.TP
\fB-nobasic
Used to disable Basic when starting the emulator in XL/XE mode.
Simulates the Option key being held down during system boot.
.TP
\fB-basic
Turn on Atari BASIC ROM

.TP
\fB-cart <filename>
Insert cartridge (CART or raw format)
.TP
\fB-run <filename>
Run Atari program (EXE, COM, XEX, BAS, LST)
.TP
\fB-state <filename>
Load saved-state file
.TP
\fB-tape <filename>
Attach cassette image (CAS format or raw file)
.TP
\fB-boottape <filename>
Attach cassette image and boot it

.TP
\fB-1400
Emulate the Atari 1400XL
.TP
\fB-xld
Emulate the Atari 1450XLD
.TP
\fB-bb
Emulate the CSS Black Box
.TP
\fB-mio
Emulate the ICD MIO board

.TP
\fB-nopatch
Normally the OS is patched giving very fast I/O. This options prevents
the patch from being applied so that the OS accesses the serial port
hardware directly. This option will probably never be needed since
programs that access the serial hardware should work even if the OS
has been patched.
.TP
\fB-nopatchall
Don't patch OS at all, H:, P: and R: devices won't work

.TP
\fB-H1 <path>
Set path for H1: device
.TP
\fB-H2 <path>
Set path for H2: device
.TP
\fB-H3 <path>
Set path for H3: device
.TP
\fB-H4 <path>
Set path for H4: device
.TP
\fB-Hpath <path>
Set path for Atari executables on the H: device
.TP
\fB-hreadonly
Enable read-only mode for H: device
.TP
\fB-hreadwrite
Disable read-only mode for H: device
.TP
\fB-devbug
Put debugging messages for H: and P: devices in log file

.TP
\fB-rtime
Enable R-Time 8 emulation
.TP
\fB-nortime
Disable R-Time 8 emulation

.TP
\fBrdevice [<dev>]
Enable R: device. If <dev> is specified then it's used as host serial device
name (e.g. /dev/ttyS0 on linux). If there is no <dev> specified then R:
is directed to network.

.TP
\fB-mouse off
Do not use mouse
.TP
\fB-mouse pad
Emulate paddles
.TP
\fB-mouse touch
Emulate Atari Touch Tablet
.TP
\fB-mouse koala
Emulate Koala Pad
.TP
\fB-mouse pen
Emulate Light Pen
.TP
\fB-mouse gun
Emulate Light Gun
.TP
\fB-mouse amiga
Emulate Amiga mouse
.TP
\fB-mouse st
Emulate Atari ST mouse
.TP
\fB-mouse trak
Emulate Atari Trak-Ball
.TP
\fB-mouse joy
Emulate joystick using mouse
.TP
\fB-mouseport <num>
Set mouse port 1-4 (default 1)
.TP
\fB-mousespeed <num>
Set mouse speed 1-9 (default 3)
.TP
\fB-multijoy
Emulate MultiJoy4 interface
.TP
\fB-directmouse
Use mouse's absolute position
.TP
\fB-cx85 <num>
Emulate CX85 numeric keypad on port <num>
.TP
\fB-grabmouse
SDL only, prevent mouse pointer from leaving the window

.TP
\fB-record <filename>
Record all input events to <filename>. Can be used for gaming contests
(highest score etc).
.TP
\fB-playback <filename>
Playback input events from <filename>. Watch an expert play the game.

.TP
\fB-refresh
Controls screen refresh rate. A numerical value follows this option
which specifies how many emulated screen updates are required before
the actual screen is updated. This value effects the speed of the
emulation: A higher value results in faster CPU emulation but a
less frequently updated screen.

.TP
\fB-artif <mode>
Set artifacting mode 0-4 (0 = disable)
.TP
\fB-paletten/p <filename>
Read Atari NTSC/PAL colors from ACT file
.TP
\fB-blackn/p <num>
Set NTSC/PAL black level 0-255
.TP
\fB-whiten/p <num>
Set NTSC/PAL white level 0-255
.TP
\fB-colorsn/p <num>
Set NTSC/PAL color intensity
.TP
\fB-genpaln/p
Generate artifical NTSC/PAL palette
.TP
\fB-colshiftn/p <num>
Set color shift (-genpal only)
.TP
\fB-screenshots <pattern>
Set filename pattern for screenshots. Use to override the default
atari000.png, atari001.png etc. filenames. Hashes are replaced with
raising numbers. Existing files are overwritten only if all the files
defined by the pattern exist.

.TP
\fB-showspeed
Show percentage of actual speed

.TP
\fB-sound
Enable sound
.TP
\fB-nosound
Disable sound
.TP
\fB-dsprate <freq>
Set mixing frequency (Hz)
.TP
\fB-snddelay <time>
Set sound delay (milliseconds)

.SS Curses Options

.TP
\fB-left
Use columns 0 to 39
.TP
\fB-central
Use columns 20 to 59
.TP
\fB-right
Use columns 40 to 79
.TP
\fB-wide1
Use columns 0 to 79. In this mode only the even character positions
are used. The odd locations are filled with spaces.
.TP
\fB-wide2
Use columns 0 to 79. This mode is similar to \fB-wide1\fP except that
the spaces are in reverse video if the previous character was also
in reverse video.

.SS Falcon Options

.TP
\fB-interlace <x>
Generate Falcon screen only every x frame
.TP
\fB-videl
Direct VIDEL programming (Falcon/VGA only)
.TP
\fB-double
Double the screen size on NOVA
.TP
\fB-delta
Delta screen output (differences only)
.TP
\fB-joyswap
Swap joysticks

.SS Java NestedVM

.TP
\fB-scale <n>
Scale width and height by <n>

.SS SDL Options

.TP
\fB-fullscreen
Start in fullscreen mode (tries to switch to 336x240 resolution)
.TP
\fB-windowed
Start in a window (does not change your working resolution)
.TP
\fB-rotate90
Run the emulator with rotated display (useful for devices with 240x320
screen)
.TP
\fB-width number-of-pixels
Host horizontal resolution for fullscreen
.TP
\fB-height number-of-pixels
Host vertical resolution for fullscreen
.TP
\fB-bpp number-of-bits
Host color depth for running in fullscreen

.TP
\fB-audio16
Enable 16-bit sound output

.TP
\fB-nojoystick
Do not initialize SDL joysticks
.TP
\fB-joy0 path-to-device
Define path to device used in LPTjoy 0. Available on linux-ia32 only.
.TP
\fB-joy1 path-to-device
Define path to device used in LPTjoy 1. Available on linux-ia32 only.

.TP
\fB-ntscemu
Emulate NTSC composite video (640x480x16 only)
This includes NTSC TV artifacts.  "-artif" is not needed in this mode and will
not work.  This mode does not use a palette.  The video signal is emulated
instead.  Palette options such as -genpaln have no effect in this mode.
The following items are for -ntscemu only:

.TP
\fB-ntsc_hue <n>
Set NTSC hue -1..1 (like TV Tint control)
.TP
\fB-ntsc_sat <n>
Set NTSC saturation (like TV Colour control)
.TP
\fB-ntsc_cont <n>
Set NTSC contrast (also called white level)
.TP
\fB-ntsc_bright <n>
Set NTSC brightness (also called black level)
.TP
\fB-ntsc_sharp <n>
Set NTSC sharpness
.TP
\fB-ntsc_burst <n>
Set NTSC burst phase (artificating colours) (CTIA?) Drol, Choplifter,
Ultima: 0.70
.TP
\fB-ntsc_gauss <n>
Set NTSC Gaussian factor (can affect artifacting colours, sharpness and
ghosting)
.TP
\fB-ntsc_gamma <n>
Set NTSC gamma adjustment
.TP
\fB-ntsc_ramp <n>
Set NTSC saturation ramp factor (amount by which bright colours become
desaturated or washed out)
.TP
\fB-scanlines <n>
Set scanlines percentage (ntscemu only)
.TP
\fB-scanlinesnoint
Disable scanlines interpolation (ntscemu only)
.TP
\fB-proto80
Emulate a prototype 80 column board for the 1090
.TP
\fB-xep80
Emulate the XEP80
.TP
\fB-xep80port <n>
Use XEP80 on joystick port <n>


.SS X11 Options

.TP
\fB-small
Run the emulator in a small window where each Atari 800 pixel is
represented by one X Window pixel
.TP
\fB-large
Runs the emulator in a large window where each Atari 800 pixel is
represented by a 2x2 X Window rectange. This mode is selected by
default.
.TP
\fB-huge
Runs the emulator in a huge window where each Atari 800 pixel is
represented by a 3x3 X Window rectange
.TP
\fB-clip_x number-of-pixels
Set left offset for clipping
.TP
\fB-clip_width number-of-pixels
Set the width of the clipping-area
.TP
\fB-clip_y number-of-pixels
Set top offset for clipping
.TP
\fB-clip_height number-of-pixels
Set the height of the clipping-area
.TP
\fB-private_cmap
Use private colormap
.TP
\fB-sio
Show SIO monitor
.TP
\fB-x11bug
Enable debug code in atari_x11.c

.TP
\fB-keypad
Keypad mode

.PD 0

.SH KEYBOARD, JOYSTICK AND OTHER CONTROLLERS

.TP
\fBF1
Built in user interface
.TP
\fBF2
Option key
.TP
\fBF3
Select key
.TP
\fBF4
Start key
.TP
\fBF5
Reset key ("warm reset")
.TP
\fBShift+F5
Reboot ("cold reset")
.TP
\fBF6
Help key (XL/XE only)
.TP
\fBF7
Break key
.TP
\fBF8
Enter monitor
.TP
\fBF9
Exit emulator
.TP
\fBF10
Save screenshot
.TP
\fBShift+F10
Save interlaced screenshot
.TP
\fBAlt+R
Run Atari program
.TP
\fBAlt+D
Disk management
.TP
\fBAlt+C
Cartridge management
.TP
\fBAlt+Y
Select system
.TP
\fBAlt+O
Sound settings
.TP
\fBAlt+W
Sound recording start/stop
.TP
\fBAlt+S
Save state file
.TP
\fBAlt+L
Load state file
.TP
\fBAlt+A
About the emulator
.TP
\fBInsert
Insert line (Atari Shift+'>')
.TP
\fBCtrl+Insert
Insert character (Atari Ctrl+'>')
.TP
\fBShift+Ctrl+Insert
Shift+Ctrl+'>'
.TP
\fBDelete
Delete line (Atari Shift+Backspace)
.TP
\fBShift+Backspace
Delete line (Atari Shift+Backspace)
.TP
\fBCtrl+Delete
Delete character (Atari Ctrl+Backspace)
.TP
\fBCtrl+Backspace
Delete character (Atari Ctrl+Backspace)
.TP
\fBShift+Ctrl+Delete
Shift+Ctrl+Backspace
.TP
\fBShift+Ctrl+Backspace
Shift+Ctrl+Backspace
.TP
\fBHome
Clear (Atari Shift+'<')
.TP
\fBCtrl+Home
Ctrl+'<' (also clears screen)
.TP
\fBShift+Ctrl+Home
Shift+Ctrl+'<'
.TP
\fB~
Inverse video
.TP
\fBUp
Up (Atari Ctrl+'-')
.TP
\fBDown
Down (Atari Ctrl+'=')
.TP
\fBLeft
Left (Atari ctrl+'+')
.TP
\fBRight
Right (Atari ctrl+'*')
.TP
\fBCtrl+Up
-
.TP
\fBCtrl+Down
=
.TP
\fBCtrl+Left
+
.TP
\fBCtrl+Right
*
.TP
\fBShift+Up
_ (Atari Shift+'-')
.TP
\fBShift+Down
| (Atari Shift+'=')
.TP
\fBShift+Left
\ (Atari Shift+'+')
.TP
\fBShift+Right
^ (Atari Shift+'*')
.TP
\fBShift+Ctrl+Up
Shift+Ctrl+-
.TP
\fBShift+Ctrl+Down
Shift+Ctrl+=
.TP
\fBCtrl+'\\'
Ctrl+Esc  (Workaround for Windows)
.TP
\fBShift+Ctrl+'\\'
Shift+Ctrl+Esc (Workaround for Windows)

.PP
CX85 Keypad (if enabled):
.TP
\fBhost keypad 0123456789-.
0123456789-.
.TP
\fBhost keypad /
NO
.TP
\fBhost keypad Ctrl+/
ESCAPE
.TP
\fBhost keypad *
DELETE
.TP
\fBhost keypad +
YES
.TP
\fBhost keypad Enter
+ENTER

.PP
Paddles, Atari touch tablet, Koala pad, light pen, light gun,
ST/Amiga mouse, Atari trak-ball, joystick and Atari 5200 analog
controller are emulated using mouse on ports that support it.
See the options above for how to enable mouse.

.SS Basic

No function keys or Alt+letter shortcuts.
Use Ctrl+C to enter the monitor.
Controllers not supported in this version.

.SS Curses

F10 (Save screenshot) does not work in the default CURSES_BASIC build.
Shift+F5 and Shift+F10 don't work at all.
Avoid Ctrl + C, H, J, M, Q, S and Z. The remaining control characters
can be typed. Control characters are displayed on the screen
with the associated upper case character in bold.

Controllers not supported in this version.

.SS Falcon

.TP
\fBHelp
Help key (XL/XE)

.PP
Joystick 0 is operated by the numeric keypad (make sure that the numeric
keypad has been enabled).

        7 8 9
         \\|/
        4 5 6
         /|\\
        1 2 3

        And 0 is the fire key.

Mouse not supported in this version.

.SS SDL

.TP
\fB`
Atari/Inverse key
.TP
\fBLSUPER
Atari/Inverse key (unusable under Windows)
.TP
\fBRSUPER
CapsToggle (+Shift = CapsLock)

.TP
\fBLAlt+F
Switch fullscreen (probably doesn't work in Windows)
.TP
\fBLAlt+G
Switch WIDTH_MODE (so you can set 320x240)
.TP
\fBLAlt+B
Switch BLACK-AND-WHITE
.TP
\fBLAlt+J
Swap \fBkeyboard_emulated\fP joysticks
.TP
\fBLAlt+E
Switch bpp (for debug only, will be removed soon)
.TP
\fBLAlt+M
Grab mouse (prevents mouse pointer from leaving the window)

These keys work with the NTSC composite video emualtion (-ntscemu):
(This interface should be considered experimental and is subject to change)
.TP
\fBLAlt+1
Decrease NTSC sharpness 
.TP
\fBLAlt+2
Increase NTSC sharpness 
.TP
\fBLAlt+3
Decrease NTSC saturation (like TV Colour control)
.TP
\fBLAlt+4
Increase NTSC saturation
.TP
\fBLAlt+5
Decrease NTSC brightness (also called black level)
.TP
\fBLAlt+6
Increase NTSC brightness
.TP
\fBLAlt+7
Decrease NTSC contrast (also called white level) 
.TP
\fBLAlt+8
Increase NTSC contrast
.TP
\fBLAlt+9
Decrease NTSC burst phase (use this to change artifacting colours) 
.TP
\fBLAlt+0
Increase NTSC burst phase
.TP
\fBLAlt+-
Decrease NTSC Gaussian factor (ghosting, sharpness, artif colours)
.TP
\fBLAlt+=
Increase NTSC Gaussian factor (ghosting, sharpness, artif colours)
.TP
\fBLAlt+[
Decrease scanlines percentage (NTSC mode only)
.TP
\fBLAlt+]
Increase scanlines percentage (NTSC mode only)
.TP
\fBLAlt+;
Decrease NTSC hue (like TV Tint control)
.TP
\fBLAlt+'
Increase NTSC hue (like TV Tint control)
.TP
\fBLAlt+Ins
Decrease NTSC saturation ramp(reduce saturation for bright colours) 
.TP
\fBLAlt+Ins
Increase NTSC saturation ramp(reduce saturation for bright colours) 
.TP
\fBLAlt+Shift+X
Enable/disable XEP80 screen (use with -xep80)


.PP
Apart from standard joysticks (handled by the SDL) up to two keyboard joysticks
are supported. The keys used for joystick directions and the trigger can be
freely defined in the config UI (Controller Config -> Define layout).
Keyboard joystick emulation can be enabled/disabled in the Controller Config.
By default, joy 0 is enabled and joy 1 is disabled (to not steal normal
AWDS keys in the emulator).

.SS X11

.TP
\fBAlt
Atari key (either Alt key will work)

.PP
Joystick 0 is operated by the mouse position relative to the center of
the screen. The mouse button acts as the trigger.  On Linux, standard
joysticks are also supported.

.PD 1

.SH FILES
.TP
\fI/usr/share/atari800/ATARIOSA.ROM\fR
Atari O/S A
.TP
\fI/usr/share/atari800/ATARIOSB.ROM\fR
Atari O/S B
.TP
\fI/usr/share/atari800/ATARIXL.ROM\fR
Atari 800 XL O/S
.TP
\fI/usr/share/atari800/ATARI5200.ROM\fR
Atari 5200 O/S
.TP
\fI/usr/share/atari800/ATARIBAS.ROM\fR
Atari Basic

.SH BUGS
See the BUGS file.
