/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Member;
import java.util.Collections;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Checker;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.AnnotationPointcut;
import org.aspectj.weaver.patterns.ArgsAnnotationPointcut;
import org.aspectj.weaver.patterns.ArgsPointcut;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.CflowPointcut;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.HandlerPointcut;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.PatternParser;
import org.aspectj.weaver.patterns.PointcutExpressionMatching;
import org.aspectj.weaver.patterns.ReferencePointcut;
import org.aspectj.weaver.patterns.ThisOrTargetAnnotationPointcut;
import org.aspectj.weaver.patterns.ThisOrTargetPointcut;
import org.aspectj.weaver.patterns.WithinAnnotationPointcut;
import org.aspectj.weaver.patterns.WithinCodeAnnotationPointcut;
import org.aspectj.weaver.patterns.WithinPointcut;
import org.aspectj.weaver.patterns.WithincodePointcut;

public abstract class Pointcut
extends PatternNode
implements PointcutExpressionMatching {
    public String[] m_ignoreUnboundBindingForNames = new String[0];
    public static final State SYMBOLIC = new State("symbolic", 0);
    public static final State RESOLVED = new State("resolved", 1);
    public static final State CONCRETE = new State("concrete", 2);
    protected byte pointcutKind;
    public State state = SYMBOLIC;
    protected int lastMatchedShadowId;
    private FuzzyBoolean lastMatchedShadowResult;
    private Test lastMatchedShadowResidue;
    public static final byte KINDED = 1;
    public static final byte WITHIN = 2;
    public static final byte THIS_OR_TARGET = 3;
    public static final byte ARGS = 4;
    public static final byte AND = 5;
    public static final byte OR = 6;
    public static final byte NOT = 7;
    public static final byte REFERENCE = 8;
    public static final byte IF = 9;
    public static final byte CFLOW = 10;
    public static final byte WITHINCODE = 12;
    public static final byte HANDLER = 13;
    public static final byte IF_TRUE = 14;
    public static final byte IF_FALSE = 15;
    public static final byte ANNOTATION = 16;
    public static final byte ATWITHIN = 17;
    public static final byte ATWITHINCODE = 18;
    public static final byte ATTHIS_OR_TARGET = 19;
    public static final byte ATARGS = 20;
    public static final byte NONE = 40;

    public abstract FuzzyBoolean fastMatch(FastMatchInfo var1);

    public abstract Set couldMatchKinds();

    public final FuzzyBoolean match(Shadow shadow) {
        if (shadow.shadowId == this.lastMatchedShadowId) {
            return this.lastMatchedShadowResult;
        }
        FuzzyBoolean ret = this.couldMatchKinds().contains(shadow.getKind()) ? this.matchInternal(shadow) : FuzzyBoolean.NO;
        this.lastMatchedShadowId = shadow.shadowId;
        this.lastMatchedShadowResult = ret;
        return ret;
    }

    protected abstract FuzzyBoolean matchInternal(Shadow var1);

    public FuzzyBoolean match(JoinPoint jp, JoinPoint.StaticPart enclosingJoinPoint) {
        return this.match(jp.getStaticPart());
    }

    public FuzzyBoolean match(JoinPoint.StaticPart jpsp) {
        throw new UnsupportedOperationException("Pointcut expression " + this.toString() + "cannot be matched at runtime");
    }

    public boolean matchesDynamically(Object thisObject, Object targetObject, Object[] args) {
        throw new UnsupportedOperationException("Pointcut expression " + this.toString() + "cannot be matched by this operation");
    }

    public FuzzyBoolean matchesStatically(String joinpointKind, Member member, Class thisClass, Class targetClass, Member withinCode) {
        throw new UnsupportedOperationException("Pointcut expression " + this.toString() + "cannot be matched by this operation");
    }

    public byte getPointcutKind() {
        return this.pointcutKind;
    }

    protected abstract void resolveBindings(IScope var1, Bindings var2);

    protected abstract void resolveBindingsFromRTTI();

    public final Pointcut resolve(IScope scope) {
        this.assertState(SYMBOLIC);
        Bindings bindingTable = new Bindings(scope.getFormalCount());
        this.resolveBindings(scope, bindingTable);
        bindingTable.checkAllBound(scope);
        this.state = RESOLVED;
        return this;
    }

    public Pointcut resolve() {
        this.assertState(SYMBOLIC);
        this.resolveBindingsFromRTTI();
        this.state = RESOLVED;
        return this;
    }

    public final Pointcut concretize(ResolvedTypeX inAspect, int arity) {
        Pointcut ret = this.concretize(inAspect, IntMap.idMap(arity));
        ret.m_ignoreUnboundBindingForNames = this.m_ignoreUnboundBindingForNames;
        return ret;
    }

    public final Pointcut concretize(ResolvedTypeX inAspect, int arity, ShadowMunger advice) {
        IntMap map = IntMap.idMap(arity);
        map.setEnclosingAdvice(advice);
        map.setConcreteAspect(inAspect);
        return this.concretize(inAspect, map);
    }

    public boolean isDeclare(ShadowMunger munger) {
        if (munger == null) {
            return false;
        }
        if (munger instanceof Checker) {
            return true;
        }
        return ((Advice)munger).getKind().equals(AdviceKind.Softener);
    }

    public final Pointcut concretize(ResolvedTypeX inAspect, IntMap bindings) {
        Pointcut ret = this.concretize1(inAspect, bindings);
        if (this.shouldCopyLocationForConcretize()) {
            ret.copyLocationFrom(this);
        }
        ret.state = CONCRETE;
        ret.m_ignoreUnboundBindingForNames = this.m_ignoreUnboundBindingForNames;
        return ret;
    }

    protected boolean shouldCopyLocationForConcretize() {
        return true;
    }

    protected abstract Pointcut concretize1(ResolvedTypeX var1, IntMap var2);

    public final Test findResidue(Shadow shadow, ExposedState state) {
        Test ret = this.findResidueInternal(shadow, state);
        this.lastMatchedShadowId = shadow.shadowId;
        return ret;
    }

    protected abstract Test findResidueInternal(Shadow var1, ExposedState var2);

    public void postRead(ResolvedTypeX enclosingType) {
    }

    public static Pointcut read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        Pointcut ret;
        byte kind = s.readByte();
        switch (kind) {
            case 1: {
                ret = KindedPointcut.read(s, context);
                break;
            }
            case 2: {
                ret = WithinPointcut.read(s, context);
                break;
            }
            case 3: {
                ret = ThisOrTargetPointcut.read(s, context);
                break;
            }
            case 4: {
                ret = ArgsPointcut.read(s, context);
                break;
            }
            case 5: {
                ret = AndPointcut.read(s, context);
                break;
            }
            case 6: {
                ret = OrPointcut.read(s, context);
                break;
            }
            case 7: {
                ret = NotPointcut.read(s, context);
                break;
            }
            case 8: {
                ret = ReferencePointcut.read(s, context);
                break;
            }
            case 9: {
                ret = IfPointcut.read(s, context);
                break;
            }
            case 10: {
                ret = CflowPointcut.read(s, context);
                break;
            }
            case 12: {
                ret = WithincodePointcut.read(s, context);
                break;
            }
            case 13: {
                ret = HandlerPointcut.read(s, context);
                break;
            }
            case 14: {
                ret = IfPointcut.makeIfTruePointcut(RESOLVED);
                break;
            }
            case 15: {
                ret = IfPointcut.makeIfFalsePointcut(RESOLVED);
                break;
            }
            case 16: {
                ret = AnnotationPointcut.read(s, context);
                break;
            }
            case 17: {
                ret = WithinAnnotationPointcut.read(s, context);
                break;
            }
            case 18: {
                ret = WithinCodeAnnotationPointcut.read(s, context);
                break;
            }
            case 19: {
                ret = ThisOrTargetAnnotationPointcut.read(s, context);
                break;
            }
            case 20: {
                ret = ArgsAnnotationPointcut.read(s, context);
                break;
            }
            case 40: {
                ret = Pointcut.makeMatchesNothing(RESOLVED);
                break;
            }
            default: {
                throw new BCException("unknown kind: " + kind);
            }
        }
        ret.state = RESOLVED;
        ret.pointcutKind = kind;
        return ret;
    }

    public static Pointcut fromString(String str) {
        PatternParser parser = new PatternParser(str);
        return parser.parsePointcut();
    }

    public static Pointcut makeMatchesNothing(State state) {
        MatchesNothingPointcut ret = new MatchesNothingPointcut();
        ret.state = state;
        return ret;
    }

    public void assertState(State state) {
        if (this.state != state) {
            throw new BCException("expected state: " + state + " got: " + this.state);
        }
    }

    private static class MatchesNothingPointcut
    extends Pointcut {
        private MatchesNothingPointcut() {
        }

        protected Test findResidueInternal(Shadow shadow, ExposedState state) {
            return Literal.FALSE;
        }

        public Set couldMatchKinds() {
            return Collections.EMPTY_SET;
        }

        public FuzzyBoolean fastMatch(FastMatchInfo type) {
            return FuzzyBoolean.NO;
        }

        protected FuzzyBoolean matchInternal(Shadow shadow) {
            return FuzzyBoolean.NO;
        }

        public FuzzyBoolean match(JoinPoint.StaticPart jpsp) {
            return FuzzyBoolean.NO;
        }

        public boolean matchesDynamically(Object thisObject, Object targetObject, Object[] args) {
            return false;
        }

        public FuzzyBoolean matchesStatically(String joinpointKind, Member member, Class thisClass, Class targetClass, Member withinCode) {
            return FuzzyBoolean.NO;
        }

        public void resolveBindings(IScope scope, Bindings bindings) {
        }

        public void resolveBindingsFromRTTI() {
        }

        public void postRead(ResolvedTypeX enclosingType) {
        }

        public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
            return Pointcut.makeMatchesNothing(this.state);
        }

        public void write(DataOutputStream s) throws IOException {
            s.writeByte(40);
        }

        public String toString() {
            return "";
        }
    }

    public static final class State
    extends TypeSafeEnum {
        public State(String name, int key) {
            super(name, key);
        }
    }
}

