/*
 * Linux Dependent system file 
 */

#ifdef linux

#define __LINUX_C

#include "xmame.h"
#include "sound.h"

#ifdef USE_JOYSTICK
#include <linux/joystick.h>
struct 	 JS_DATA_TYPE joy_data,joy_orig;
int	 joy_fd; /* joystick file descriptor */
#endif

static int linux_sound_init(void);

/*
 * Put anything here you need to do when the program is started.
 * Return 0 if initialization was successful, nonzero otherwise.
 */

int sysdep_init ()
{
	/* initialize joystick device */
#ifdef USE_JOYSTICK
#ifdef I386_JOYSTICK
    	if (use_joystick) {
		fprintf(stderr_file, "Linux Joystick interface initialization...\n");
		if ((joy_fd = open ("/dev/js0", O_RDONLY | O_NONBLOCK)) < 0) {
		  fprintf(stderr_file, "Couldn't open joystick device /dev/js0 \n");
		  fprintf(stderr_file, "Be sure to joystick module is instaled\n");
		  use_joystick = FALSE;
		}
	else if ( read(joy_fd,&joy_orig,sizeof(struct JS_DATA_TYPE)) < 0) {
	  	 fprintf(stderr_file, "Cannot read joystic device.sorry\n");
	 	 exit(1);
		}
		/* mask x e y pos to skip "flickering" */
		if (swapjoyaxis)
		{
		    int a      = joy_orig.y;
		    joy_orig.y = joy_orig.x;
		    joy_orig.x = a;
		}

    	}
#endif
#endif
	/* initialize sound */
    	if (play_sound && (linux_sound_init()<0) )
	    fprintf(stderr_file,"Sound device init failed. Sound disabled\n");
	
	return (TRUE);
}


/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int linux_sound_init(void) {
	int log_2_frag, frag;
	int format = AFMT_U8;
	int stereo = 0;
	int corrected_frag_size;
#ifndef USE_TIMER	
	audio_buf_info info;
#endif	
	
	fprintf(stderr_file,"Linux Sound Driver initialization... \n");
	
	if((audio_fd = open(audiodevice,O_WRONLY,0)) < 0) {
		perror("/dev/dsp");
		play_sound = 0;
		return -1;
	}
	if (ioctl(audio_fd,SNDCTL_DSP_SETFMT,&format) < 0) {
		perror("SNDCTL_DSP_SETFMT");
		play_sound = 0;
	}
	if (ioctl(audio_fd,SNDCTL_DSP_STEREO,&stereo) < 0) {
                perror("SNDCTL_DSP_STEREO");
                play_sound = 0;
        }
	if (ioctl(audio_fd,SNDCTL_DSP_SPEED,&options.samplerate) < 0) {
                perror("SNDCTL_DSP_SPEED");
                play_sound = 0;
        }
        
	corrected_frag_size = (options.samplerate * frag_size) / 22050;
	for (log_2_frag=0; (1 << log_2_frag) < corrected_frag_size; log_2_frag++) {}
	frag = log_2_frag + (num_frags << 16);
	
	fprintf(stderr_file, "Setting fragsize to %d, numfrags to %d\n",
		1 << (frag&0x0000FFFF), frag >> 16);
	
	if (ioctl(audio_fd,SNDCTL_DSP_SETFRAGMENT,&frag) < 0) {
                perror("SNDCTL_DSP_SETFRAGMENT");
                play_sound = 0;
	}

#ifndef USE_TIMER
        /* don't do this in timer mode, usually people use timer mode cause
           this doesn't work. Just hope OSS get's it right */
	if (ioctl(audio_fd,SNDCTL_DSP_GETOSPACE,&info) < 0) {
		perror("SNDCTL_DSP_GETOSPACE");
		play_sound = 0;
	}
#endif
	
	if(play_sound == 0) { close(audio_fd); return (-1); }
	
#ifndef USE_TIMER
	frag_size = info.fragsize;
	num_frags = info.fragstotal;
	fprintf(stderr_file,"Fragsize = %d, Numfrags = %d\n", frag_size, num_frags);
#endif
	fprintf(stderr_file,"Audio device %s set to 8bit linear mono %dHz\n",
		audiodevice, options.samplerate);

        return 0;   
}

/*
 * Cleanup routines to be executed when the program is terminated.
 */

void sysdep_exit (void) {
	if (play_sound)	{
                int n;
                /* stop and release voices */
                for (n = 0; n < AUDIO_NUM_VOICES; n++) osd_stop_sample(n);
		close(audio_fd);
        }
#ifdef USE_JOYSTICK
  	if (use_joystick)	close (joy_fd);
#endif
}

long sysdep_get_audio_freespace() {
#ifndef USE_TIMER
       audio_buf_info info;
       int i=ioctl(audio_fd,SNDCTL_DSP_GETOSPACE,&info);
       if (i<0) { perror("SNDCTL_DSP_GETOSPACE"); return -1; }
       return (long)(info.bytes);
#else
       return 0;
#endif              
}

int sysdep_play_audio (byte * buf, int bufsize)
{
	return write(audio_fd,buf,bufsize);
}

#endif
/****** end of Linux dependent code; DO NOT WRITE BELOW THIS LINE *********/
