/*
 * X-mame main-routine
 */

#define __MAIN_C_
#include "xmame.h"
#include "sound.h"
#include "driver.h"

#ifdef MESS

#ifdef ggi
char *title="X-Mess (GGI) version 0.1.0";
#elif svgalib
char *title="X-Mess (SVGALib) version 0.1.0";
#else
char *title="X-Mess (X11) version 0.1.0";
#endif

#else

#ifdef ggi
char *title="X-Mame (GGI) version 0.33rc1.1";
#elif svgalib
char *title="X-Mame (SVGALib) version 0.33rc1.1";
#else
char *title="X-Mame (X11) version 0.33rc1.1";
#endif

#endif

/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int osd_init(void)
{
	/* now invoice system-dependent initialization */
	sysdep_keyboard_init();
	sysdep_mouse_init();
	sysdep_joy_initvars();
	sysdep_audio_initvars();
	
#ifdef USE_TIMER
#ifndef svgalib
	/* in svgalib mode must start timer AFTER open display */
	if (play_sound)
	   if (start_timer()==OSD_NOT_OK) return(OSD_NOT_OK);
#endif
#endif
	return OSD_OK;
}

/*
 * Cleanup routines to be executed when the program is terminated.
 */

void osd_exit (void)
{
	/* to allow profiling info to be saved change to home's directory */
	chdir(getenv("HOME"));
	/* actually no global options: invoice directly unix-dep routines */
	sysdep_keyboard_close();
	sysdep_mouse_close();
	sysdep_joy_close();
	sysdep_exit();
}


int main (int argc, char **argv)
{
	int res;

#ifdef svgalib
        /* first let's try to init svgalib */
        /* and give up those evil root rights, */
        /* esp since the rest of the code is full of bufferoveruns ;( */
	vga_init();
#endif
#ifdef ggi
	/* ggi needs to be initialized too */
     	ggiInit();
#endif

	/* parse configuration file and environment */
	if (get_config() == OSD_NOT_OK) return OSD_NOT_OK;

#ifndef MESS
	/* try to set current working directory to mamedir */
	if ( chdir(mamedir)<0 ) {
		fprintf(stderr,"Cannot chdir() to %s. Sorry\n",mamedir);
		return (OSD_NOT_OK);
	}
#endif

	/* check for frontend options */
	if ( (res = frontend_help (argc, argv)) != 1234 ) return res;
	
	/* parse the cmdline */
	if (parse_command_line(argc, argv) == OSD_NOT_OK) return (OSD_NOT_OK);

	/* Network Init */
	if (netstate) osd_net_init();

	/* this could change the samplerate so has to be done here and not
	   in osd_init ! */
	sysdep_init();

	/* Set the samplerate to 0 if sound is disabled,
	   this should notify mame not to "render" it (speed improvement) */
	if (play_sound==0) 
	{
	   if (fake_sound)
	      options.samplerate=8000;
	   else
	   {
	      options.samplerate=0;
	      No_FM=0;
	   }
	}
	
	/* go for it */
	res = run_game (game_index , &options);

	/* close sockets */
	if (netstate) osd_cleanup_network();

	/* close open files */
	if (options.errorlog) fclose (options.errorlog);
	if (options.playback) osd_fclose (options.playback);
	if (options.record)   osd_fclose (options.record);

	return res;
}
