///////////////////////////////////////////////////////////////////////////////
// $Id: $
///////////////////////////////////////////////////////////////////////////////
//
// main.cxx - Starting point for Oonsoo
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 11,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: $
///////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>

#include "UIApplication.hxx"
#include "SpriteCollection.hxx"
#include "SpriteData.hxx"
#include "Sound.hxx"
#include "SampleCollection.hxx"
#include "SampleData.hxx"
#include "Engine.hxx"


main(int argc, char **argv)
{
  // Build the sample collection
  SampleCollection* sampleCollection = new SampleCollection(SampleData);

  // Build the Sound system
  Sound* sound = new Sound(sampleCollection);

  // Create an application
  application = new UIApplication(&argc, argv, "Oonsoo", sound);

  // Make sure we're running on a color display
  if(DisplayCells(application->display(), application->screen()) <= 2)
  {
    fprintf(stderr,"Can't run on monochrome displays!\n");
    exit(1);
  }
  
  // Build the sprite collection
  SpriteCollection* spriteCollection = new SpriteCollection(SpriteData);

 
  // Fire up the oonsoo engine 
  Engine* engine = new Engine(spriteCollection);

  // Loop until they decide to quit
  application->eventLoop();


  // Destroy the oonsoo engine
  delete engine;

  // Destroy the sprite collection
  delete spriteCollection;

  // Destroy the application
  delete application;

  // Destroy the sound system
  delete sound;

  // Destroy the sample collection
  delete sampleCollection;
}

