.TH SCC 1 local
.SH NAME
scc \- Scheme to C compiler
.SH SYNTAX
.B scc
[ option ] ... file ...
.SH DESCRIPTION
The 
.B scc
command invokes a Scheme compiler which accepts the language
defined in the essential portions of
.I
Revised\v'-0.3m'4\v'0.3m' Report on the Algorithmic Language Scheme,
with minor constraints and some additions.  The compiler produces C source
files which are then compiled using the system's C compiler to produce
conventional \fI.o\fR and \fIa.out\fR files.  The C code produced by this
compiler may be intermixed with other C code or code written in other
languages.
.SH OPTIONS
These options are accepted by \fBscc\fR.
Other options will be assumed to be options of the system's C
compiler and they will be passed to it when it is invoked.
.TP 18
\fB-cc  \fIC compiler\fR
Compile the Scheme compiler produced C code with \fIC compiler\fR.  If this
flag is not supplied, then the C compiler \fIcc\fR will be used.
.TP 18
.B -C
Compile the Scheme programs found in the files \fIsource\fR.sc and
leave the resulting code in \fIsource\fR.c files.  No further operations
are performed.
.TP 18
\fB-I  \fIdirectory\fR
Specifies a directory to be searched by include for source files.  
.TP 18
\fB-f  \fIsymbol  value\fR
Define the compile-time constant
.I symbol
to
.I value.
This is equivalent to the construct (define-constant
.I
symbol
.IR value )
appearing in the Scheme source.
.TP 18
.B -i
Combine the source and object files into a Scheme interpreter.  The module
name for each Scheme source file is automatically determined.  Module names
for previously compiled modules must be specified using the \fB-m\fR option.
.TP 18
\fB-m  \fImodule-name\fR
Specifies the name of a previously compiled module.  Note that the Scheme
compiler will downshift the alphabetic characters in the \fImodule-name\fR.
Modules are initialized in the order that the \fB-m\fR flags appear.
.TP 18
.B -Ob
Optimize code by omitting bounds checks on vectors and strings.
.TP 18
.B -Og
Optimize code by omitting stack trace-back code.
.TP 18
.B -On
Optimize code by assuming that all numbers are fixed point.
.TP 18
.B -Ot
Optimize code by omitting type error checks.
.TP 18
.B -pg
Produce profiled code for run-time measurement using
.I gprof(1).
The profiled library is used in lieu of the standard Scheme library.
.TP 18
\fB-scgc   \fIstatflag\fR
Enables garbage collection statistics.  If set to 1, then garbage collection
statistics will be printed.  The default is 0, that will result in no
statistics.
.TP 18
\fB-sch  \fIheap\fR
Specifies the compiler's initial heap size in megabytes.  The default is
system dependent.
.TP 18
\fB-scl \fIpercent\fR
Specifies the percent of the heap allocated after a generational garbage
collection that will force a full collection.  The default is 40.
.TP 18
\fB-scmh  \fIheap\fR
Specifies the compiler's maximum heap size in megabytes.  The
default is five times the initial size of the heap.
.TP 18
\fB-LIBDIR  \fIdirectory\fR
Specifies a directory containing the files: predef.sc, objects.h, libsc.a, and
optionally libsc_p.a.
.TP 18
\fB-log\fR
Logs information internal to the compiler to the C source file produced by the
compiler.  Each type of information is controlled by a flag:
\fB-source\fR, \fB-macro\fR, \fB-expand\fR, \fB-closed\fR, \fB-transform\fR,
\fB-lambda\fR, \fB-tree\fR, \fB-lap\fR, \fB-peep\fR.  The flag \fB-log\fR is
equivalent to specifying the flags: \fB-source\fR, \fB-macro\fR, \fB-expand\fR,
\fB-closed\fR, \fB-transform\fR, \fB-lambda\fR, \fB-tree\fR.

.SH ENVIRONMENT VARIABLES
The items controlled by \fI-sc..\fR flags can also be controlled by environment
variables.  If both the flag and the environment variable are provided, then
the flag's value will be used.
.TP 18
.B SCGCINFO
Controls the reporting of garbage collection statistics to the standard error
file.  If set to 1, then garbage collection statistics will be printed.  The
default setting is 0 that will not print the statistics.
.TP 18
.B SCHEAP
Specifies the initial size of the heap in megabytes.  The default heap size is
system dependent.
.TP 18
.B SCLIMIT
Specifies the percent of the heap allocated after a generational garbage
collection that will force a full collection.  The default is 40.
.TP 18
.B SCMAXHEAP
Specifies the maximum size of the heap in megabytes.
.SH INPUT FILES
Following the command options come one or more file names.
.TP 18
.IR name .sc
Scheme source.  Scheme source files will be compiled into C files with the
name \fIname\fR.c.
.TP 18
.IR name .c
C source.
.TP 18
.IR name .s
Assembly language source.
.TP 18
.IR name .o
Object file which may have been generated by any compiler.
.TP 18
.IR name .a
Object file archive which may have been generated by any compiler.
.SH DIAGNOSTICS
The disgnostic messages produced by the compiler are printed on the standard
error file.
.SH FILES
.ta 2.0i
/.../schemetoc/...	source and documentation
.br
/.../libsc.a	library
.br
/.../libsc_p.a	profiled library (optional)
.br
/.../scc	c-shell script
.br
/.../sccomp	compiler
.br
/.../predef.sc	predefined functions
.br
/.../objects.h	definitions "#include'd" in the C code
.br
SC-TO-C.c	temporary C source file
.br
\fIsource\fR.S2C	temporary C source file
.br
SC-TO-C.o	temporary object file
.br
.SH LIMITATIONS
When the compiler is able to identify every call to a procedure, it is able
to generate it "in-line", and perform tail calls by using "goto".  This
analysis covers most loops, conditional expressions, and finite state machines.
For non-tail recursive calls, the code generated by the compiler uses the
standard C mechanisms for
procedure call and return.  This therefore requires that
each top-level Scheme procedure, and any Scheme procedure which has more than
one call which is not tail-recursive be compiled into its own C procedure.
Calls to such procedures will be tail-recursive if and only if the host C
compiler optimizes tail-recursion.

.SH SEE ALSO
.PP
Harold Abelson and Gerald Jay Sussman with Julie Sussman,
.I
Structure and Interpretation of Computer Programs,
The MIT Press.
.PP
William Clinger and Jonathan Rees (Editors),
.I
Revised\v'-0.3m'4\v'0.3m' Report on the Algorithmic Language Scheme,
LISP Pointers, Volume IV, Number 3, July-September 1991.  PostScript for this
file is included in the software distribution.
.PP
Jerry D. Smith,
.I
An Introduction to Scheme,
Prentice Hall, Inc.  Chapter notes for using this text with Scheme->C are
included in the software distribution.
.PP
R. Kent Dybvig,
.I
The SCHEME Programming Language,
Prentice Hall, Inc.
.PP
Daniel P. Friedman and Matthias Felleisen,
.I
The Little LISPer,
MIT Press.
.PP
Joel F. Bartlett,
.I
Scheme->C  a Portable Scheme-to-C Compiler,
WRL Research Report 89/1.
.PP
Additional documentation is included in the software distribution.
.PP
sci(1)
.SH QUESTIONS, COMMENTS, AND COMPLAINTS
bartlett@decwrl.dec.com
