/*
  cvtmake
  Main file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include "Global.h"
#include "Holder.h"
#include "Entry.h"
#include "Misc.h"

//#define DEBUG 0

FILE *in, *out;

int main(int argc, char *argv[])
{
  char instr[80];
  char outstr[80];
  char *tmpstr = new char[MaxSize];
  int tmpint;
  Holder H;
  unsigned int whichCPU = PENTIUM;    // Default value PENTIUM
  unsigned int whichASM = GNU;        // Default value GNU as

  if ((argc < 2)||(argc > 4)) {
     cout << "cvtmake v" << VERSION << " :\n\n";
     cout << "Usage: cvtmake [-g|-n] [-I486|-P5|-P5MMX|-P6|-PII] <inputfile>\n\n";
     cout << "       -g      : Use GNU as (Default)\n";
     cout << "       -n      : Use NASM\n\n";
     cout << "       -I486   : No optimization in Makefile\n";
     cout << "       -P5     : Convert Makefile to use Pentium (Default)\n";
     cout << "       -P5MMX  : Convert Makefile to use Pentium MMX\n";
     cout << "       -P6     : Convert Makefile to use Pentium Pro\n";
     cout << "       -PII    : Convert Makefile to use Pentium II\n\n";
     cout << "       where <inputfile> is: 'Makefile'\n";
     return 0;
  }
  instr[0] = '\0';
  outstr[0] = '\0';
  
  for (tmpint=1; tmpint<argc; tmpint++) {
    if (strstr(argv[tmpint],"-g") != NULL) {
       whichASM = GNU;
    } else
    if (strstr(argv[tmpint],"-n") != NULL) {
       whichASM = NASM;
    } else
    if (strstr(argv[tmpint],"-I486") != NULL) {
       whichCPU = I486;
    } else
    if (strstr(argv[tmpint],"-P5") != NULL) {
       whichCPU = PENTIUM;
    } else
    if (strstr(argv[tmpint],"-P5MMX") != NULL) {
       whichCPU = PENTIUMMMX;
    } else
    if (strstr(argv[tmpint],"-P6") != NULL) {
       whichCPU = PENTIUMPRO;
    } else
    if (strstr(argv[tmpint],"-PII") != NULL) {
       whichCPU = PENTIUMII;
    } else {
       strcpy(instr,argv[tmpint]);
    }
  }
  if (!strcmp(instr,"")) {
    cout << "cvtmake v" << VERSION << ": No input file given." << endl;
    delete tmpstr;
    return 1;
  }
// -----------------------------------------------------  
  strcpy(outstr,instr);  
  in = fopen(instr,"rb");
  if (in == NULL) {
    strcpy(tmpstr,"Can't open : ");
    strcat(tmpstr,instr);
    error(tmpstr);
  }
  H.loadFile();
  remove(instr);
  
  out = fopen(outstr,"wb");
  if (out == NULL) {
    strcpy(tmpstr,"Can't open : ");
    strcat(tmpstr,outstr);
    error(tmpstr);
  }
  rewind(out);

  H.process(whichASM,whichCPU);

#ifdef DEBUG
  H.printAll();
#endif
  H.saveFile();
// ------------------------------------------------------

  fclose(in);
  fclose(out);

  delete tmpstr;
};

