/*
  cvtmake
  Holder C++ file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */

#include "Global.h"
#include "IO.h"
#include "Entry.h"
#include "Holder.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>
#include <string.h>

//
//	Method name : Holder
//
//	Description : Constructor to Holder
//	Input : ---
//	Output : ---
//
Holder::Holder() {
  firstEntry = (PEntry) NULL;
  lastEntry = (PEntry) NULL;
}

//
//	Method name : ~Holder
//
//	Description : Destructor to Holder
//	Input : ---
//	Output : ---
//
Holder::~Holder() {
  PEntry    tmp;

  while (firstEntry != NULL) {
    tmp = firstEntry;
    firstEntry = tmp->next;
    delete tmp;
  }
}

//
//	Method name : insert
//
//	Description : Inserts a entry in Holder
//	Input : The information for the entry
//	Output : ---
//
void Holder::insert(char *s){
  PEntry newEntry = new Entry(s);

  if (firstEntry == NULL) {
    firstEntry = newEntry;
    lastEntry = newEntry;
  } else {
    lastEntry->next = newEntry;
    lastEntry = newEntry;
  }
}

//
//	Method name : process
//
//	Description : Changes the Makefile
//	Input : Which assembler type, Which CPU
//	Output : ---
//
void Holder::process(unsigned int ASMtype, unsigned int CPUtype){
  char *optimizer_call = new char[MaxSize];
  char *asm_call = new char[MaxSize];

  if (ASMtype == GNU) {
    strcpy(asm_call,"");
  } else {
    strcpy(asm_call,"nasm -f elf ");
  }
    
  switch(CPUtype) {
    case PENTIUM:
      strcpy(optimizer_call,P5str);
      break;
    case PENTIUMMMX:
      strcpy(optimizer_call,P5MMXstr);
      break;
    case PENTIUMPRO:
      strcpy(optimizer_call,P6str);
      break;
    case PENTIUMII:
      strcpy(optimizer_call,PIIstr);
      break;
  }

  delete optimizer_call;
  delete asm_call;
}



//
//	Method name : printAll
//
//	Description : Prints all the entry's
//	Input : ---
//	Output : ---
//
void Holder::printAll(void){
  PEntry tmp;

  tmp = firstEntry;
  while (tmp != NULL) {
     tmp->print();
     tmp = tmp->next;
  }
  cout << endl;
}

