/*
** structNames.c
**
** Hacks to fit tags into the same namespace.
*/

# include "lclintMacros.nf"
# include "basic.h"
# include "structNames.h"

/*@constant char MARKCHAR_STRUCT; @*/
# define MARKCHAR_STRUCT '@'

/*@constant char MARKCHAR_UNION; @*/
# define MARKCHAR_UNION  '$'

/*@constant char MARKCHAR_ENUM; @*/
# define MARKCHAR_ENUM   '&'

/*@constant char MARKCHAR_PARAM; @*/
# define MARKCHAR_PARAM  '%'

/*@only@*/ cstring fixTagName (cstring s)
{
  if (isFakeTag (s))
    {
      switch (cstring_firstChar (s))
	{
	case MARKCHAR_STRUCT: return (cstring_makeLiteral ("struct"));
	case MARKCHAR_UNION:  return (cstring_makeLiteral ("union"));
	case MARKCHAR_ENUM:   return (cstring_makeLiteral ("enum"));
	default:         return (message ("<bad tag name: %s>", s));
	  /* BADDEFAULT; */
	}
    }
  else
    {
      if (cstring_isDefined (s)) {
	switch (cstring_firstChar (s))
	  {
	  case MARKCHAR_STRUCT:
	    return (message ("struct %s", cstring_suffix (s, 1)));
	  case MARKCHAR_UNION: 
	    return (message ("union %s", cstring_suffix (s, 1)));
	  case MARKCHAR_ENUM:   
	    return (message ("enum %s", cstring_suffix (s, 1)));
	    BADDEFAULT;
	  }
      } else {
	return (cstring_makeLiteral ("<missing tag name>"));
      }
    }
}

cstring makeParam (cstring s)
{
  if (cstring_length(s) > 0 && cstring_firstChar (s) == MARKCHAR_PARAM)
    {
      llbug (message ("makeParam: %s\n", s));
    }

  if (cstring_isUndefined (s))
    {
      return cstring_undefined;
    }

  return (cstring_prependChar (MARKCHAR_PARAM, s));  
}

/*@observer@*/ cstring fixParamName (cstring s)
{
  if (cstring_length(s) < 1)
    {
      return cstring_undefined;
    }

  if (cstring_firstChar (s) != MARKCHAR_PARAM)
    {
      llbug (message ("fixParamName (no #): %s", s));
    }

  return (cstring_suffix (s, 1));
}

cstring makeStruct (cstring s)
{
  if (cstring_firstChar (s) == '@')
    {
      llbug (message ("makeStruct: %s\n", s));
    }

  return (cstring_prependChar (MARKCHAR_STRUCT, s));
}

cstring makeUnion (cstring s)
{
  return (cstring_prependChar (MARKCHAR_UNION, s));
}

cstring makeEnum (cstring s)
{
  return (cstring_prependChar (MARKCHAR_ENUM, s));
}

static unsigned int tagno = 1;

void setTagNo (unsigned int n)
{
  if (n > tagno)
    tagno = n;
}

bool isFakeTag (cstring s)
{
  int length = cstring_length (s);

  return ((length >= 1 && cstring_firstChar (s) == '!')
	  || (length >= 2 && cstring_getChar (s, 2) == '!'));
}

cstring fakeTag ()
{
  tagno++;

  return (message ("!%u", tagno));
}





