/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/

# include "lclintMacros.nf"
# include "basic.h"

fileloc g_currentloc;

# ifndef NOLCL
symtable g_symtab;
/*@only@*/ lsymbolSet g_currentImports = lsymbolSet_undefined;
# endif

cstring g_codeFile = cstring_undefined;
int g_codeLine = 0;

cstring g_prevCodeFile = cstring_undefined;
int g_prevCodeLine = 0;
FILE *g_msgstream;

/*
** These were in llmain.c.  Most should not be globals...
*/

/*@observer@*/ char *g_localSpecPath = ".";

# ifndef NOLCL
/*@only@*/ cstring g_currentSpec;
/*@only@*/ char *g_currentSpecName;
# endif

void printCodePoint (void)
{
  static bool incode = FALSE;

  if (incode) {
    fprintf (stderr, "[[[ in code! ]]]\n");
  }

  incode = TRUE;

  if (cstring_isDefined (g_codeFile))
    {
      cstring temps = fileloc_unparseRaw (g_codeFile, g_codeLine);

      fprintf (stderr, "*** Last code point: %s\n", 
	       cstring_toCharsSafe (temps));

      cstring_free (temps);

      if (cstring_isDefined (g_prevCodeFile))
	{
	  temps = fileloc_unparseRaw (g_prevCodeFile, g_prevCodeLine);
	  fprintf (stderr, "*** Previous code point: %s\n", 
		   cstring_toCharsSafe (temps));

	  cstring_free (temps);
	}
    }

  incode = FALSE;
}

# ifdef WIN32
int yywrap (void)
{
  return 1;
}
# endif



