/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** flagMarkerList.h
*/

# ifndef flagMarkerList_H
# define flagMarkerList_H

typedef /*@only@*/ flagMarker o_flagMarker;

abst_typedef struct _flagMarkerList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ o_flagMarker  *elements;
} *flagMarkerList ;

extern /*@only@*/ flagMarkerList flagMarkerList_new (void) /*@*/ ;

extern /*@unused@*/ /*@only@*/ cstring
  flagMarkerList_unparse (flagMarkerList p_s) /*@*/ ;
extern void flagMarkerList_free (/*@only@*/ flagMarkerList p_s) ;

extern void flagMarkerList_add (flagMarkerList p_s, /*@only@*/ flagMarker p_fm)
               /*@modifies p_s@*/ ;

extern ynm 
  flagMarkerList_suppressError (flagMarkerList p_s, flagcode p_code, fileloc p_loc) /*@*/ ;

extern void flagMarkerList_checkSuppressCounts (flagMarkerList p_s) 
   /*@modifies g_msgstream@*/ ;

extern bool
  flagMarkerList_inIgnore (flagMarkerList p_s, fileloc p_loc) /*@*/ ;

/*@constant int flagMarkerListBASESIZE;@*/
# define flagMarkerListBASESIZE SMALLBASESIZE

# else
# error "Multiple include"
# endif




