/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/

# ifndef USYMTAB_INTERFACE_H
# define USYMTAB_INTERFACE_H

# ifdef NOLCL
# error "Bad include"
# endif

extern void doDeclareConstant (constDeclarationNode, bool);
extern void doDeclareVar      (varDeclarationNode, bool);
extern void doDeclareType     (typeNode, bool);
extern void doDeclareFcn      (fcnNode p_f, typeId p_tn, bool p_priv, bool p_spec);
extern void declareIter        (iterNode p_iter);

extern void declareConstant (constDeclarationNode);
extern void declareVar      (varDeclarationNode);
extern void declareType     (typeNode);
extern void declareFcn      (fcnNode p_f, typeId p_t);

extern void declarePrivConstant (constDeclarationNode);
extern void declarePrivVar      (varDeclarationNode);
extern void declarePrivType     (typeNode);
extern void declarePrivFcn      (fcnNode p_f, typeId p_t);

# define declareConstant(c)     doDeclareConstant(c, FALSE)
# define declareVar(c)          doDeclareVar(c, FALSE)
# define declareType(c)         doDeclareType(c, FALSE)
# define declareFcn(f, t)       doDeclareFcn(f, t, FALSE, TRUE)

# define declarePrivConstant(c) doDeclareConstant(c, TRUE)
# define declarePrivVar(c)      doDeclareVar(c, TRUE)
# define declarePrivType(c)     doDeclareType(c, TRUE)
# define declarePrivFcn(f, t)   doDeclareFcn(f, t, TRUE, TRUE)

# else
# error "Multiple include"
# endif




