;==============================================================================

; file: "_repl.scm"

; Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved.

(##include "header.scm")

;==============================================================================

; Decompilation of a piece of code

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(##define-macro (mk-degen params . def)
  `(let () (##declare (not inline)) (lambda ($code ,@params) ,@def)))

(##define-macro (degen proc . args)
  `(,proc $code ,@args))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (##extract-container $code rte)
  (let loop ((c (code-cte $code)) (r rte))
    (cond ((##cte-top? c)
           #f)
          ((##cte-frame? c)
           (let ((vars (##cte-frame-vars c)))
             (if (and (##pair? vars) (##eq? (##car vars) (self-var)))
               (rte-ref r 1)
               (loop (##cte-parent-cte c) (rte-up r)))))
          (else
           (loop (##cte-parent-cte c) r)))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (##begin? x) (and (##pair? x) (##eq? (##car x) 'begin)))
(define (##cond? x)  (and (##pair? x) (##eq? (##car x) 'cond)))
(define (##and? x)   (and (##pair? x) (##eq? (##car x) 'and)))
(define (##or? x)    (and (##pair? x) (##eq? (##car x) 'or)))
(define (##void-constant? x)
  (and (##pair? x)
       (##eq? (##car x) 'quote)
       (##eq? (##cadr x) (##void))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define ##degen-top
  (mk-degen ()
    (##decomp (^ 0))))

(define ##degen-cst
  (mk-degen ()
    (let ((val (^ 0)))
      (if (##self-eval? val) val (##list 'quote val)))))

(define ##degen-loc-ref-x-y
  (mk-degen (up over)
    (degen ##degen-up-over up over)))

(define ##degen-up-over
  (mk-degen (up over)
    (let loop1 ((c (code-cte $code)) (up up))
      (cond ((##cte-frame? c)
             (if (##fixnum.= up 0)
               (let loop2 ((vars (##cte-frame-vars c)) (i over))
                 (if (##fixnum.< i 2)
                   (##car vars)
                   (loop2 (##cdr vars) (##fixnum.- i 1))))
               (loop1 (##cte-parent-cte c) (##fixnum.- up 1))))
            (else
             (loop1 (##cte-parent-cte c) up))))))

(define ##degen-loc-ref
  (mk-degen ()
    (degen ##degen-loc-ref-x-y (^ 0) (^ 1))))

(define ##degen-glo-ref
  (mk-degen ()
    (global-var->identifier (^ 0))))

(define ##degen-loc-set
  (mk-degen ()
    (##list 'set! (degen ##degen-up-over (^ 1) (^ 2))
                  (##decomp (^ 0)))))

(define ##degen-glo-set
  (mk-degen ()
    (##list 'set! (global-var->identifier (^ 1))
                  (##decomp (^ 0)))))

(define ##degen-glo-def
  (mk-degen ()
    (##list 'define (global-var->identifier (^ 1))
                    (##decomp (^ 0)))))

(define ##degen-if2
  (mk-degen ()
    (##list 'if (##decomp (^ 0))
                (##decomp (^ 1)))))

(define ##degen-if3
  (mk-degen ()
    (##list 'if (##decomp (^ 0))
                (##decomp (^ 1))
                (##decomp (^ 2)))))

(define ##degen-seq
  (mk-degen ()
    (let ((val1 (##decomp (^ 0)))
          (val2 (##decomp (^ 1))))
      (if (##begin? val2)
        (##cons 'begin (##cons val1 (##cdr val2)))
        (##list 'begin val1 val2)))))

(define ##degen-quasi-list->vector
  (mk-degen ()
    (##list 'quasiquote
            (##vector (##list 'unquote-splicing (##decomp (^ 0)))))))

(define ##degen-quasi-append
  (mk-degen ()
    (##list 'quasiquote
            (##list (##list 'unquote-splicing (##decomp (^ 0)))
                    (##list 'unquote-splicing (##decomp (^ 1)))))))

(define ##degen-quasi-cons
  (mk-degen ()
    (##list 'quasiquote
            (##list (##list 'unquote (##decomp (^ 0)))
                    (##list 'unquote-splicing (##decomp (^ 1)))))))

(define ##degen-cond-if
  (mk-degen ()
    (let ((val1 (##decomp (^ 0)))
          (val2 (##decomp (^ 1)))
          (val3 (##decomp (^ 2))))
      (##build-cond
        (if (##begin? val2)
          (##cons val1 (##cdr val2))
          (##list val1 val2))
        val3))))

(define ##degen-cond-or
  (mk-degen ()
    (let ((val1 (##decomp (^ 0)))
          (val2 (##decomp (^ 1))))
      (##build-cond (##list val1) val2))))

(define ##degen-cond-send
  (mk-degen ()
    (let ((val1 (##decomp (^ 0)))
          (val2 (##decomp (^ 1)))
          (val3 (##decomp (^ 2))))
      (##build-cond (##list val1 '=> val2) val3))))

(define (##build-cond clause rest)
  (cond ((##cond? rest)
         (##cons 'cond (##cons clause (##cdr rest))))
        ((##begin? rest)
         (##cons 'cond (##list clause (##cons 'else (##cdr rest)))))
        ((##void-constant? rest)
         (##list 'cond clause))
        (else
         (##list 'cond clause (##list 'else rest)))))

(define ##degen-or
  (mk-degen ()
    (let ((val1 (##decomp (^ 0)))
          (val2 (##decomp (^ 1))))
      (if (##or? val2)
        (##cons 'or (##cons val1 (##cdr val2)))
        (##list 'or val1 val2)))))

(define ##degen-and
  (mk-degen ()
    (let ((val1 (##decomp (^ 0)))
          (val2 (##decomp (^ 1))))
      (if (##and? val2)
        (##cons 'and (##cons val1 (##cdr val2)))
        (##list 'and val1 val2)))))

(define ##degen-case
  (mk-degen ()
    (let ((val1 (##decomp (^ 0)))
          (val2 (##decomp (^ 1))))
      (##cons 'case (##cons val1 val2)))))

(define ##degen-case-clause
  (mk-degen ()
    (let ((val1 (##decomp (^ 0)))
          (val2 (##decomp (^ 1))))
      (##cons (if (##begin? val1)
                (##cons (^ 2) (##cdr val1))
                (##list (^ 2) val1))
              val2))))

(define ##degen-case-else
  (mk-degen ()
    (let ((val (##decomp (^ 0))))
      (if (##void-constant? val)
        '()
        (##list (if (##begin? val)
                  (##cons 'else (##cdr val))
                  (##list 'else val)))))))

(define ##degen-let
  (mk-degen ()
    (let ((n (code-length $code)))
      (let loop ((i (##fixnum.- n 2)) (vals '()))
        (if (##fixnum.< 0 i)
          (loop (##fixnum.- i 1)
                (##cons (##decomp (code-ref $code i)) vals))
          (let ((body
                 (##decomp (^ 0)))
                (bindings
                 (##make-bindings (code-ref $code (##fixnum.- n 1)) vals)))
            (if (##begin? body)
              (##cons 'let (##cons bindings (##cdr body)))
              (##list 'let bindings body))))))))

(define (##make-bindings l1 l2)
  (if (##pair? l1)
    (##cons (##list (##car l1) (##car l2))
            (##make-bindings (##cdr l1) (##cdr l2)))
    '()))

(define ##degen-letrec
  (mk-degen ()
    (let ((n (code-length $code)))
      (let loop ((i (##fixnum.- n 2)) (vals '()))
        (if (##fixnum.< 0 i)
          (loop (##fixnum.- i 1)
                (##cons (##decomp (code-ref $code i)) vals))
          (let ((body (##decomp (^ 0)))
                (bindings (##make-bindings (code-ref $code (##fixnum.- n 1)) vals)))
            (if (##begin? body)
              (##cons 'letrec (##cons bindings (##cdr body)))
              (##list 'letrec bindings body))))))))

(define ##degen-prc-req
  (mk-degen ()
    (let* ((n (code-length $code))
           (body (##decomp (^ 0)))
           (params (code-ref $code (##fixnum.- n 1))))
      (if (##begin? body)
        (##cons 'lambda (##cons params (##cdr body)))
        (##list 'lambda params body)))))

(define ##degen-prc-rest
  (mk-degen ()
    (let ((body (##decomp (^ 0)))
          (params (##make-params (^ 3) #t #f '())))
      (if (##begin? body)
        (##cons 'lambda (##cons params (##cdr body)))
        (##list 'lambda params body)))))

(define ##degen-prc
  (mk-degen ()
    (let ((n (code-length $code)))
      (let loop ((i (##fixnum.- n 8)) (inits '()))
        (if (##not (##fixnum.< i 1))
          (loop (##fixnum.- i 1)
                (##cons (##decomp (code-ref $code i)) inits))
          (let ((body
                 (##decomp (^ 0)))
                (params
                 (##make-params
                   (code-ref $code (##fixnum.- n 1))
                   (code-ref $code (##fixnum.- n 4))
                   (code-ref $code (##fixnum.- n 3))
                   inits)))
            (if (##begin? body)
              (##cons 'lambda (##cons params (##cdr body)))
              (##list 'lambda params body))))))))

(define (##make-params parms rest? keys inits)
  (let* ((nb-parms
          (##length parms))
         (nb-inits
          (##length inits))
         (nb-reqs
          (##fixnum.- nb-parms (##fixnum.+ nb-inits (if rest? 1 0))))
         (nb-opts
          (##fixnum.- nb-inits (if keys (##vector-length keys) 0))))

    (define (build-reqs)
      (let loop ((parms parms)
                 (i nb-reqs))
        (if (##fixnum.= i 0)
          (build-opts parms)
          (let ((parm (##car parms)))
            (##cons parm
                    (loop (##cdr parms)
                          (##fixnum.- i 1)))))))

    (define (build-opts parms)
      (if (##fixnum.= nb-opts 0)
        (build-rest parms inits)
        (##cons #!optional
                (let loop ((parms parms)
                           (i nb-opts)
                           (inits inits))
                  (if (##fixnum.= i 0)
                    (build-rest parms inits)
                    (let ((parm (##car parms))
                          (init (##car inits)))
                      (##cons (if (##eq? init #f) parm (##list parm init))
                              (loop (##cdr parms)
                                    (##fixnum.- i 1)
                                    (##cdr inits)))))))))

    (define (build-rest parms inits)
      (if rest?
        (let ((parm (##car parms)))
          (if (and (##fixnum.= nb-opts 0) (##not keys))
            parm
            (##cons #!rest (##cons parm (build-keys (##cdr parms) inits)))))
        (build-keys parms inits)))

    (define (build-keys parms inits)
      (if (##not keys)
        '()
        (##cons #!key
                (let loop ((parms parms)
                           (i (##vector-length keys))
                           (inits inits))
                  (if (##fixnum.= i 0)
                    '()
                    (let ((parm (##car parms))
                          (init (##car inits)))
                      (##cons (if (##eq? init #f) parm (##list parm init))
                              (loop (##cdr parms)
                                    (##fixnum.- i 1)
                                    (##cdr inits)))))))))

    (build-reqs)))

(define ##degen-app0
  (mk-degen ()
    (##list (##decomp (^ 0)))))

(define ##degen-app1
  (mk-degen ()
    (##list (##decomp (^ 0))
            (##decomp (^ 1)))))

(define ##degen-app2
  (mk-degen ()
    (##list (##decomp (^ 0))
            (##decomp (^ 1))
            (##decomp (^ 2)))))

(define ##degen-app3
  (mk-degen ()
    (##list (##decomp (^ 0))
            (##decomp (^ 1))
            (##decomp (^ 2))
            (##decomp (^ 3)))))

(define ##degen-app
  (mk-degen ()
    (let ((n (code-length $code)))
      (let loop ((i (##fixnum.- n 1)) (vals '()))
        (if (##not (##fixnum.< i 0))
          (loop (##fixnum.- i 1)
                (##cons (##decomp (code-ref $code i)) vals))
          vals)))))

(define ##degen-delay
  (mk-degen ()
    (##list 'delay (##decomp (^ 0)))))

(define ##degen-future
  (mk-degen ()
    (##list 'future (##decomp (^ 0)))))

;------------------------------------------------------------------------------

(define ##decomp-dispatch-table #f)

(define (##setup-decomp-dispatch-table)
  (set! ##decomp-dispatch-table
    (##list
      (##cons ##cprc-top         ##degen-top)

      (##cons ##cprc-cst         ##degen-cst)

      (##cons ##cprc-loc-ref-0-1 (mk-degen () (degen ##degen-loc-ref-x-y 0 1)))
      (##cons ##cprc-loc-ref-0-2 (mk-degen () (degen ##degen-loc-ref-x-y 0 2)))
      (##cons ##cprc-loc-ref-0-3 (mk-degen () (degen ##degen-loc-ref-x-y 0 3)))
      (##cons ##cprc-loc-ref-1-1 (mk-degen () (degen ##degen-loc-ref-x-y 1 1)))
      (##cons ##cprc-loc-ref-1-2 (mk-degen () (degen ##degen-loc-ref-x-y 1 2)))
      (##cons ##cprc-loc-ref-1-3 (mk-degen () (degen ##degen-loc-ref-x-y 1 3)))
      (##cons ##cprc-loc-ref-2-1 (mk-degen () (degen ##degen-loc-ref-x-y 2 1)))
      (##cons ##cprc-loc-ref-2-2 (mk-degen () (degen ##degen-loc-ref-x-y 2 2)))
      (##cons ##cprc-loc-ref-2-3 (mk-degen () (degen ##degen-loc-ref-x-y 2 3)))
      (##cons ##cprc-loc-ref     ##degen-loc-ref)
      (##cons ##cprc-glo-ref     ##degen-glo-ref)

      (##cons ##cprc-loc-set     ##degen-loc-set)
      (##cons ##cprc-glo-set     ##degen-glo-set)
      (##cons ##cprc-glo-def     ##degen-glo-def)

      (##cons ##cprc-if2         ##degen-if2)
      (##cons ##cprc-if3         ##degen-if3)
      (##cons ##cprc-seq         ##degen-seq)
      (##cons ##cprc-quasi-list->vector ##degen-quasi-list->vector)
      (##cons ##cprc-quasi-append ##degen-quasi-append)
      (##cons ##cprc-quasi-cons  ##degen-quasi-cons)
      (##cons ##cprc-cond-if     ##degen-cond-if)
      (##cons ##cprc-cond-or     ##degen-cond-or)
      (##cons ##cprc-cond-send-red ##degen-cond-send)
      (##cons ##cprc-cond-send-sub ##degen-cond-send)

      (##cons ##cprc-or          ##degen-or)
      (##cons ##cprc-and         ##degen-and)

      (##cons ##cprc-case        ##degen-case)
      (##cons ##cprc-case-clause ##degen-case-clause)
      (##cons ##cprc-case-else   ##degen-case-else)

      (##cons ##cprc-let         ##degen-let)
      (##cons ##cprc-letrec      ##degen-letrec)

      (##cons ##cprc-prc-req0    ##degen-prc-req)
      (##cons ##cprc-prc-req1    ##degen-prc-req)
      (##cons ##cprc-prc-req2    ##degen-prc-req)
      (##cons ##cprc-prc-req3    ##degen-prc-req)
      (##cons ##cprc-prc-req     ##degen-prc-req)
      (##cons ##cprc-prc-rest    ##degen-prc-rest)
      (##cons ##cprc-prc         ##degen-prc)

      (##cons ##cprc-app0-red    ##degen-app0)
      (##cons ##cprc-app1-red    ##degen-app1)
      (##cons ##cprc-app2-red    ##degen-app2)
      (##cons ##cprc-app3-red    ##degen-app3)
      (##cons ##cprc-app-red     ##degen-app)
      (##cons ##cprc-app0-sub    ##degen-app0)
      (##cons ##cprc-app1-sub    ##degen-app1)
      (##cons ##cprc-app2-sub    ##degen-app2)
      (##cons ##cprc-app3-sub    ##degen-app3)
      (##cons ##cprc-app-sub     ##degen-app)

      (##cons ##cprc-delay       ##degen-delay)
      (##cons ##cprc-future      ##degen-future)
)))

(##setup-decomp-dispatch-table)

;------------------------------------------------------------------------------

(define (##decomp $code)
  (let ((cprc (code-cprc $code)))
    (let ((x (##assq cprc ##decomp-dispatch-table)))
      (if x
        (degen (##cdr x))
        '?))))

(define (##decompile proc)

  (define (decomp p)
    (let ((source (##subprocedure-source p)))
      (if source
        (source->expression source)
        proc)))

  (define (compiler-source-code source)
    (##vector-ref source 0))

  (define (source->expression source)

    (define (list->expression l)
      (cond ((##pair? l)
             (##cons (source->expression (##car l))
                     (list->expression (##cdr l))))
            ((##null? l)
             '())
            (else
             (source->expression l))))

    (define (vector->expression v)
      (let* ((len (##vector-length v))
             (x (##make-vector len #f)))
        (let loop ((i (##fixnum.- len 1)))
          (if (##not (##fixnum.< i 0))
            (begin
              (##vector-set! x i (source->expression (##vector-ref v i)))
              (loop (##fixnum.- i 1)))))
        x))

    (let ((code (compiler-source-code source)))
      (cond ((##pair? code)   (list->expression code))
            ((##vector? code) (vector->expression code))
            (else             code))))

  (let loop ((p proc))
    (cond ((##interp-procedure? p)
           (let* (($code (##interp-procedure-code p))
                  (cprc (code-cprc $code)))
             (if (##eq? cprc ##interp-procedure-wrapper)
               (loop (^ 1))
               (##decomp $code))))
          ((##closure? p)
           (decomp (##closure-code p)))
          (else
           (decomp p)))))

(define (##procedure-locat proc)

  (define (locat p)
    (let ((source (##subprocedure-source p)))
      (if source
        (compiler-source-locat source)
        #f)))

  (define (compiler-source-locat source)
    (##make-locat (##vector-ref source 1)
                  (##vector-ref source 2)))

  (let loop ((p proc))
    (cond ((##interp-procedure? p)
           (let* (($code (##interp-procedure-code p))
                  (cprc (code-cprc $code)))
             (if (##eq? cprc ##interp-procedure-wrapper)
               (loop (^ 1))
               (##code-locat $code))))
          ((##closure? p)
           (locat (##closure-code p)))
          (else
           (locat p)))))

(define (##code-locat $code)
  (let ((locat (code-locat $code)))
    (if (or (##locat? locat) (##not locat))
      locat
      (let loop ((parent (code-link $code)))
        (if parent
          (let ((locat-parent (code-locat parent)))
            (if (##locat? locat-parent)
              (##make-locat (##locat-file locat-parent) locat)
              (loop (code-link parent))))
          #f)))))

(define (##subprocedure-source proc)
  (let ((info (##subprocedure-info proc)))
    (if info
      (##vector-ref info 1)
      #f)))

(define (##subprocedure-info proc)
  (let* ((id (##subprocedure-id proc))
         (parent (##subprocedure-parent proc))
         (parent-info (##procedure-info parent)))
    (if parent-info
      (let ((v (##vector-ref parent-info 0)))
        (let loop ((i (##fixnum.- (##vector-length v) 1)))
          (if (##fixnum.< i 0)
            #f
            (let ((x (##vector-ref v i)))
              (if (##fixnum.= id (##vector-ref x 0))
                x
                (loop (##fixnum.- i 1)))))))
      #f)))

;==============================================================================

; Utilities

;------------------------------------------------------------------------------

; Internal variables are uninteresting for the user.

(define (##internal-var? var)
  (or (##eq? var (self-var))
      (##eq? var (selector-var))
      (##eq? var (do-loop-var))))

;------------------------------------------------------------------------------

; Access to structure of closures for interpreter procedures.
;
; Layout of closed variables for closures created by ##cprc-prcXXX and
; ##interp-procedure-wrapper:
;
;   slot 1: $code
;   slot 2: proc
;   slot 3: rte

(define ##interp-procedure-code-pointers
  (let (($code (mk-code #f #f #f (##no-stepper) ()))
        (rte #f))
    (##list (##closure-code (##cprc-prc-req0 $code rte))
            (##closure-code (##cprc-prc-req1 $code rte))
            (##closure-code (##cprc-prc-req2 $code rte))
            (##closure-code (##cprc-prc-req3 $code rte))
            (##closure-code (##cprc-prc-req  $code rte))
            (##closure-code (##cprc-prc-rest $code rte))
            (##closure-code (##cprc-prc      $code rte))
            (##closure-code (##interp-procedure-wrapper $code rte)))))

(define (##interp-procedure? x)
  (and (##procedure? x)
       (##closure? x)
       (##memq (##closure-code x) ##interp-procedure-code-pointers)))

(define (##interp-procedure-code x) ; return "$code" closed variable of x
  (##closure-ref x 1))

(define (##interp-procedure-rte x) ; return "rte" closed variable of x
  (##closure-ref x 3))

;------------------------------------------------------------------------------

; Access to continuation frames

(define (##frame-parent f)
  (##subprocedure-parent (##frame-ret f)))

(define (##hidden-frame? f)
  (let ((parent (##frame-parent f)))
    (or (##eq? parent ##interp-procedure-wrapper)
        (##eq? parent ##dynamic-env-bind)
        (##eq? parent ##read-eval-print)
        (##eq? parent ##non-tail-call-for-leap)
        (##eq? parent ##non-tail-call-for-step)
        (##eq? parent ##trace-generate))))

(define (##interp-subproblem-frame? f)
  (let ((parent (##frame-parent f)))
    (or (##eq? parent ##subproblem-apply0)
        (##eq? parent ##subproblem-apply1)
        (##eq? parent ##subproblem-apply2)
        (##eq? parent ##subproblem-apply3)
        (##eq? parent ##subproblem-apply))))

(define (##interp-internal-frame? f)
  (let ((parent (##frame-parent f)))
    (or (##eq? parent ##step-handler)
        (##assq parent ##decomp-dispatch-table))))

(define (##interp-frame? f)
  (or (##interp-subproblem-frame? f)
      (##interp-internal-frame? f)))

(define (##frame-creator f) ; returns #f if creator is REPL
  (if (##interp-frame? f)
    (let (($code (##interp-frame-code f))
          (rte (##interp-frame-rte f)))
      (##extract-container $code rte))
    (##frame-parent f)))

(define (##frame-locat f) ; returns #f if location unknown
  (if f
    (if (##interp-frame? f)
      (##code-locat (##interp-frame-code f))
      (##procedure-locat (##frame-ret f)))
    #f))

(define (##interp-frame-code f)
  (##cdr (##frame-locals f '$code)))

(define (##interp-frame-rte f)
  (##cdr (##frame-locals f 'rte)))

(define (##interesting-frame? f)
  (or (##interp-subproblem-frame? f)
      (and (##not (##interp-internal-frame? f))
           (##not (##hidden-frame? f)))))

(define (##continuation->first-frame cont)
  (let loop ((f (##continuation->frame cont)))
    (if f
      (if (##not (##hidden-frame? f))
        f
        (loop (##frame-next f)))
      #f)))

(define (##frame-next-interesting f)
  (let loop ((f (##frame-next f)))
    (if f
      (if (##interesting-frame? f)
        f
        (loop (##frame-next f)))
      #f)))

(define (##frame-count-interesting f)
  (let loop ((f (##frame-next f)) (n 1))
    (if f
      (if (##interesting-frame? f)
        (loop (##frame-next f) (##fixnum.+ n 1))
        (loop (##frame-next f) n))
      n)))

(define (##frame-locals f #!optional (var (absent-obj)))
  (##subprocedure-locals (##frame-ret f) f var))

(define (##subprocedure-locals
         proc
         #!optional (f (absent-obj)) (var (absent-obj)))
  (let* ((parent (##subprocedure-parent proc))
         (parent-info (##procedure-info parent))
         (info (##subprocedure-info proc)))
    (if (and parent-info info)
      (let ((var-descrs (##vector-ref parent-info 1)))
        (let loop1 ((j 2) (result '()))
          (if (##fixnum.< j (##vector-length info))
            (let* ((descr
                    (##vector-ref info j))
                   (slot-index
                    (##fixnum.quotient descr 32768))
                   (var-descr-index
                    (##fixnum.quotient (##fixnum.modulo descr 32768) 2))
                   (var-descr
                    (##vector-ref var-descrs var-descr-index))
                   (val1
                    (if (##eq? f (absent-obj))
                      #f
                      (let ((val (##frame-stk-ref f slot-index)))
                        (if (##fixnum.= (##fixnum.modulo descr 2) 0)
                          val
                          (##cell-ref val))))))
              (if (##pair? var-descr)
                (let loop2 ((lst var-descr) (result result))
                  (if (##pair? lst)
                    (let* ((descr
                            (##car lst))
                           (slot-index
                            (##fixnum.quotient descr 32768))
                           (var-descr-index
                            (##fixnum.quotient (##fixnum.modulo descr 32768) 2))
                           (var-descr
                            (##vector-ref var-descrs var-descr-index))
                           (val2
                            (if (##eq? f (absent-obj))
                              #f
                              (let ((val (##closure-ref val1 slot-index)))
                                (if (##fixnum.= (##fixnum.modulo descr 2) 0)
                                  val
                                  (##cell-ref val))))))
                      (if (##eq? f (absent-obj))
                        (loop2 (##cdr lst)
                               (##cons var-descr result))
                        (if (##eq? var (absent-obj))
                          (loop2 (##cdr lst)
                                 (##cons (##cons var-descr val2) result))
                          (if (##eq? var var-descr)
                            (##cons var-descr val2)
                            (loop2 (##cdr lst)
                                   result)))))
                    (loop1 (##fixnum.+ j 1)
                           result)))
                (if (##eq? f (absent-obj))
                  (loop1 (##fixnum.+ j 1)
                         (##cons var-descr result))
                  (if (##eq? var (absent-obj))
                    (loop1 (##fixnum.+ j 1)
                           (##cons (##cons var-descr val1) result))
                    (if (##eq? var var-descr)
                      (##cons var-descr val1)
                      (loop1 (##fixnum.+ j 1)
                             result))))))
            result)))
      #f)))

;------------------------------------------------------------------------------

; Access to run time environments

(define (##rte-shape $code)

  (define (get-shape cte)
    (cond ((##cte-top? cte)
           #f)
          ((##cte-frame? cte)
           (##list->vector
             (##cons (get-shape (##cte-parent-cte cte))
                     (##cte-frame-vars cte))))
          (else
           (get-shape (##cte-parent-cte cte)))))

  (get-shape (code-cte $code)))

(define (##rte-var-ref rte up over)
  (let loop ((r rte) (i up))
    (if (##fixnum.< 0 i)
      (loop (rte-up r) (##fixnum.- i 1))
      (##vector-ref r over))))

(define (##rte-var-set! rte up over val)
  (let loop ((r rte) (i up))
    (if (##fixnum.< 0 i)
      (loop (rte-up r) (##fixnum.- i 1))
      (##vector-set! r over val))))

;------------------------------------------------------------------------------

(define (##eval-in-frame src f dyn-bindings)
  (let ((dyn-env (##cons dyn-bindings (##frame-dyn-env f))))
    (if (##interp-frame? f)
      (let* (($code (##interp-frame-code f))
             (cte (code-cte $code))
             (rte (##interp-frame-rte f)))
        (##eval-inner src cte rte dyn-env))
      (##eval-top-with-dyn-env src ##interaction-cte dyn-env))))

(define (##procedure-name p)
  (or (##object->global-var->identifier p) p))

;------------------------------------------------------------------------------

; Read eval print loop

(define ##repl-write #f)
(set! ##repl-write #f)

(define ##repl-read #f)
(set! ##repl-read #f)

(define (##repl
         #!optional
         (in ##stdin)
         (out ##stdout)
         (rt ##main-readtable)
         (prompt2 "> ")
         (prompt1 ""))
  (##call-with-current-continuation
    (lambda (cont)
      (##read-eval-print in out rt prompt2 prompt1 cont #t))))

(define (##read-eval-print in out rt prompt2 prompt1 cont result-context?)

  (define (repl-start repl-info dyn-bindings)

    (define (repl-read)
      (let ((proc ##repl-read))
        (if (##procedure? proc)
          (proc in rt)
          (##read-expr-from-port in rt))))

    (define (repl-write val)
      (let ((proc ##repl-write))
        (if (##procedure? proc)
          (proc val out rt)
          (if (##not (##eq? val (##void)))
            (begin
              (##write val out rt (if-forces #t #f))
              (##newline out))))))

    (define (repl-n n)
      (let loop ((i 0) (f (##continuation->first-frame cont)))
        (let ((next (##frame-next-interesting f)))
          (if (and (##fixnum.< i n) next)
            (loop (##fixnum.+ i 1) next)
            (begin
              (##cmd-y i f #t out rt)
              (repl i f))))))

    (define (cmd-d eof?)
      (let ((lst (##cdr (##vector-ref repl-info 4))))
        (if eof?
          (##newline out))
        (cond ((##pair? lst)
               ((##car lst) #f))
              (eof?
               (##write-string "*** EOF again to exit" out)
               (##newline out)
               (if (##eof-object? (##peek-char in))
                 (##exit))))))

    (define (cmd-t)
      (let loop ((lst (##vector-ref repl-info 4)))
        (if (##pair? (##cdr lst))
          (loop (##cdr lst))
          ((##car lst) #f))))

    (define (repl pos f)

      (if ##display-environment?
        (##cmd-e f out rt))

      (##call-with-current-continuation
        (lambda (abort)
          (##set-car! (##vector-ref repl-info 4) abort)))

      (let loop1 ()

        (##step-off) ; turn off single-stepping

        (##display prompt1 out rt #f)
        (if (##fixnum.< 0 pos)
          (begin
            (##write-string "-" out)
            (##display pos out rt #f)))
        (##display prompt2 out rt #f)

        (let loop2 ()
          (let ((src (repl-read)))

            (define (unknown-command)
              (##write (##desourcify src) out rt #f)
              (##write-string " is an unknown command" out)
              (##newline out))

            (define (invalid-command)
              (##write (##desourcify src) out rt #f)
              (##write-string " is not valid in this context" out)
              (##newline out))

            (define (eval-print src)
              (let ((val
                     (##eval-in-frame src f dyn-bindings)))
                (repl-write val)))

            (if (##eof-object? src)
              (begin
                (cmd-d #t)
                (loop1))
              (let ((code (##source-code src)))
                (if (and (##pair? code)
                         (##eq? (##source-code (##car code)) 'unquote)
                         (##pair? (##cdr code))
                         (##null? (##cddr code)))
                  (let* ((cmd-src (##cadr code))
                         (cmd (##source-code cmd-src)))
                    (cond
                      ((##eq? cmd '?)
                       (##cmd-? out)
                       (loop1))
                      ((##eq? cmd '-)
                       (repl-n (##fixnum.- pos 1)))
                      ((##eq? cmd '+)
                       (repl-n (##fixnum.+ pos 1)))
                      ((##eq? cmd 'b)
                       (##cmd-b pos f out rt)
                       (loop1))
                      ((##eq? cmd 'i)
                       (##cmd-i f out rt)
                       (loop1))
                      ((##eq? cmd 'y)
                       (##cmd-y pos f #t out rt)
                       (loop1))
                      ((##eq? cmd 'e)
                       (##cmd-e f out rt)
                       (loop1))
                      ((##eq? cmd 't)
                       (cmd-t))
                      ((##eq? cmd 'd)
                       (cmd-d #f)
                       (loop1))
                      ((##eq? cmd 'q)
                       (##exit))
                      ((and (##fixnum? cmd)
                            (##not (##fixnum.< cmd 0)))
                       (repl-n cmd))
                      ((or (##eq? cmd 'c) (##eq? cmd 's) (##eq? cmd 'l))
                       (if result-context?
                         (begin
                           (invalid-command)
                           (loop1))
                         cmd))
                      ((and (##pair? cmd)
                            (##pair? (##cdr cmd))
                            (##null? (##cddr cmd)))
                       (let* ((cmd2-src (##car cmd))
                              (cmd2 (##source-code cmd2-src)))
                         (cond
                          ((##eq? cmd2 'c)
                           (if result-context?
                             (let ((src (##cadr cmd)))
                               (##eval-in-frame src f dyn-bindings))
                             (begin
                               (invalid-command)
                               (loop1))))
                          (else
                           (unknown-command)
                           (loop1)))))
                      (else
                       (unknown-command)
                       (loop1))))
                  (begin
                    (eval-print src)
                    (loop1)))))))))

    (repl 0 (##continuation->first-frame cont)))

  (let* ((prev-info
           (##dynamic-ref '##repl-info #f))
         (repl-info
           (##vector
             in
             out
             rt
             (if prev-info
               (##fixnum.+ (##vector-ref prev-info 3) 1)
               0)
             (if prev-info
               (let ((conts (##vector-ref prev-info 4)))
                 (##cons (##car conts) conts))
               (##cons (lambda (x) (##exit 1)) '()))))
         (dyn-bindings (##list (##cons '##repl-info repl-info))))
    (##dynamic-let
      dyn-bindings
      (lambda ()
        (repl-start repl-info dyn-bindings)))))

(define (##repl-out)
  (let ((repl-info (##dynamic-ref '##repl-info #f)))
    (if repl-info
      (##vector-ref repl-info 1)
      ##stderr)))

(define (##repl-readtable)
  (let ((repl-info (##dynamic-ref '##repl-info #f)))
    (if repl-info
      (##vector-ref repl-info 2)
      ##main-readtable)))

(define (##debug-repl cont result-context?)
  (let ((repl-info (##dynamic-ref '##repl-info #f)))
    (if repl-info
      (##read-eval-print (##vector-ref repl-info 0)
                         (##vector-ref repl-info 1)
                         (##vector-ref repl-info 2)
                         "> "
                         (##fixnum.+ (##vector-ref repl-info 3) 1)
                         cont
                         result-context?)
      (##exit 1))))

(define (##pop-repl)
  (let ((repl-info (##dynamic-ref '##repl-info #f)))
    (if repl-info
      ((##car (##vector-ref repl-info 4)) #f)
      (##exit 1))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (##cmd-? out)
  (##write-string
",?          : Summary of comma commands
,q          : Quit
,t          : Return to toplevel REP loop
,d          : Return to enclosing REP loop
,(c <expr>) : Continue from REP loop with value of <expr>
,c          : Continue from REP loop
,s          : Step continuation
,l          : Leap continuation
,<n>        : Move to particular frame (<n> >= 0)
,+ and ,-   : Move to next or previous frame of continuation
,y          : Display one-line summary of current frame
,b          : Display summary of continuation (i.e. backtrace)
,i          : Display procedure attached to current frame
,e          : Display environment accessible from current frame
" out))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (##cmd-b pos f out rt)
  (define max-head 10)
  (define max-tail 4)
  (let loop ((i 0)
             (j (##fixnum.- (##frame-count-interesting f) 1))
             (f f))
    (if f
      (begin
        (cond ((or (##fixnum.< i max-head) (##fixnum.< j max-tail)
                   (and (##fixnum.= i max-head) (##fixnum.= j max-tail)))
               (##cmd-y (##fixnum.+ pos i) f #f out rt))
              ((##fixnum.= i max-head)
               (##write-string "..." out) (##newline out)))
        (loop (##fixnum.+ i 1)
              (##fixnum.- j 1)
              (##frame-next-interesting f))))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (##cmd-y pos f pinpoint? out rt)
  (let* ((col1
          (##write pos out rt #f))
         (col2
          (##fixnum.+ (##fixnum.+ col1 1)
                      (##display-spaces (##fixnum.- 2 col1) out))))
    (##write-string " " out)
    (let* ((creator
            (##frame-creator f))
           (col3
            (##fixnum.+ col2
                        (if creator
                          (##write (##procedure-name creator) out rt #f)
                          (##display "(interaction)" out rt #f))))
           (col4
            (##fixnum.+ (##fixnum.+ col3 1)
                        (##display-spaces (##fixnum.- 26 col3) out))))
      (##write-string " " out)
      (let* ((locat
              (##frame-locat f))
             (col5
              (##fixnum.+ col4
                          (##display-locat locat pinpoint? out rt)))
             (col6
              (##fixnum.+ (##fixnum.+ col5 1)
                          (##display-spaces (##fixnum.- 50 col5) out))))
        (##write-string " " out)
        (let ((call
               (if (##interp-frame? f)
                 (let* (($code (##interp-frame-code f))
                        (cprc (code-cprc $code)))
                   (if (##eq? cprc ##interp-procedure-wrapper)
                     #f
                     (##decomp $code)))
                 (let* ((ret (##frame-ret f))
                        (call (##decompile ret)))
                   (if (##eq? call ret)
                     #f
                     call)))))
          (if call
            (##write-string
             (##object->string call rt (##fixnum.- (##port-width out) col6) #f)
             out))
          (##newline out))))))

(define (##display-spaces n out)
  (if (##fixnum.< 0 n)
    (let ((m (if (##fixnum.< 40 n) 40 n)))
      (##write-substring "                                        " 0 m out)
      (##display-spaces (##fixnum.- n m) out)
      n)
    0))

(define (##display-locat locat pinpoint? out rt) ; locat is #f if location unknown

  (define (display-loc)
    (let ((file (##locat-file locat))
          (filepos (##locat-filepos locat)))
      (let ((line (##fixnum.+ (##filepos-line filepos) 1))
            (col (##fixnum.+ (##filepos-col filepos) 1))
            (file* (if (##string? file) (##path-expand file 'shortest) file)))
        (let ((x (##write file* out rt #f)))
          (##write-string "@" out)
          (let ((y (##fixnum.+ (##write line out rt #f) x)))
            (##write-string (if pinpoint? "." ":") out)
            (##fixnum.+ (##write col out rt #f)
                        (##fixnum.+ y 2)))))))

  (if locat
    (let ((str (##format-locat locat pinpoint?)))
      (if str
        (##display str out rt #f)
        (display-loc)))
    0))

(define (##format-locat locat pinpoint?)
  (if locat
    (let ((file (##locat-file locat)))
      (if (or (##string? file)
              (##equal? file '(stdin) #f))
        (##format-filepos
         (if (##string? file) file #f)
         (##locat-filepos locat)
         pinpoint?)
        #f))
    #f))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (##cmd-e f out rt)

  (define (display-rte cte rte)
    (let loop1 ((c cte) (r rte))
      (cond ((##cte-top? c))
            ((##cte-frame? c)
             (let loop2 ((vars (##cte-frame-vars c))
                         (vals (##cdr (##vector->list r))))
               (if (##pair? vars)
                 (let ((var (##car vars)))
                   (if (##not (##internal-var? var))
                     (let ((x (##write var out rt #f)))
                       (##write-string " = " out)
                       (##write-string
                        (##object->string
                          (##car vals)
                          rt
                          (##fixnum.- (##fixnum.- (##port-width out) 3) x)
                          (if-forces #t #f))
                        out)
                       (##newline out)))
                   (loop2 (##cdr vars) (##cdr vals)))))
             (loop1 (##cte-parent-cte c) (rte-up r)))
            (else
             (loop1 (##cte-parent-cte c) r)))))

  (define (display-locals lst)
    (if lst
      (let loop ((lst lst))
        (if (##pair? lst)
          (let* ((var-val (##car lst))
                 (var (##car var-val))
                 (val (##cdr var-val))
                 (x (##write var out rt #f)))
            (##write-string " = " out)
            (##write-string
             (##object->string
              val
              rt
              (##fixnum.- (##fixnum.- (##port-width out) 3) x)
              (if-forces #t #f))
             out)
            (##newline out)
            (loop (##cdr lst)))))
      (begin
        (##write-string "Environment is not available for compiled code" out)
        (##newline out))))

  (if (##interp-frame? f)
    (let (($code (##interp-frame-code f))
          (rte (##interp-frame-rte f)))
      (display-rte (code-cte $code) rte))
    (display-locals (##frame-locals f))))

; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define (##cmd-i f out rt)
  (let ((creator (##frame-creator f)))
    (if creator
      (let ((decomp-creator (##decompile creator)))
        (##write creator out rt #f)
        (if (##eq? creator decomp-creator)
          (##newline out)
          (begin
            (##write-string " =" out)
            (##newline out)
            (##pretty-print decomp-creator out rt))))
      (begin
        (##write-string "(interaction)" out)
        (##newline out)))))

;------------------------------------------------------------------------------

; Tracing and single stepping.

(define (##interp-procedure-entry-hook proc)
  (let (($code (##interp-procedure-code proc)))
    (code-ref $code (##fixnum.- (code-length $code) 2))))

(define (##interp-procedure-entry-hook-set! proc hook)
  (let (($code (##interp-procedure-code proc)))
    (code-set! $code (##fixnum.- (code-length $code) 2) hook)))

(define (##interp-procedure-default-entry-hook proc)
  (let ((hook (##interp-procedure-entry-hook proc)))
    (if (and hook
             (##closure? hook)
             (##eq? (##subprocedure-parent (##closure-code hook))
                    ##make-default-entry-hook))
      hook
      #f)))

(define (##make-default-entry-hook)
  (let ((settings (##vector #f #f)))
    (lambda (proc args execute)
      (if (##vector-ref settings 0)
        (##step-on)) ; turn on single-stepping
      (if (##vector-ref settings 1)
        (##trace-generate (##make-call-form proc args) execute #f)
        (execute)))))

(define (##make-call-form proc args)

  (define (add-quotes lst)
    (if (##pair? lst)
      (let ((x (##car lst)))
        (##cons (if (##self-eval? x) x (##list 'quote x))
                (add-quotes (##cdr lst))))
      '()))

  (##cons (##procedure-name proc) (add-quotes (##trim-absent args))))

(define (##trace-generate form execute leap?)
  (let ((out (##repl-out))
        (rt (##repl-readtable)))

    (define max-depth 10)

    (define (bars width)
      (let loop ((i 0))
        (if (##fixnum.< i width)
          (begin
            (##write-string
              (if (##fixnum.= (##fixnum.remainder i 2) 0) "|" " ")
              out)
            (loop (##fixnum.+ i 1))))))

    (define (bars-width depth)
      (let ((d (if (##fixnum.< max-depth depth) max-depth depth)))
        (if (##fixnum.< 0 d) (##fixnum.- (##fixnum.* d 2) 1) 0)))

    (define (indent depth)
      (let ((w (bars-width depth)))
        (if (##fixnum.< max-depth depth)
          (let ((depth-str (##number->string depth 10)))
            (bars (##fixnum.- w (##fixnum.+ (##string-length depth-str) 2)))
            (##write-string "[" out)
            (##write-string depth-str out)
            (##write-string "]" out))
          (bars w))
        w))

    (##call-with-current-continuation
     (lambda (cont)
       (let* ((parent
               (##frame-parent (##continuation->frame cont)))
              (increase-depth?
               (and (##not (##eq? ##non-tail-call-for-leap parent))
                    (##not (##eq? ##non-tail-call-for-step parent))))
              (current-depth
               (##dynamic-ref '##trace-depth 0))
              (depth
               (if increase-depth?
                 (##fixnum.+ current-depth 1)
                 current-depth))
              (width
               (##fixnum.+ (indent depth) 3)))

         (define (nest wrapper)
           (let* ((result
                   (##dynamic-let
                     (##list (##cons '##trace-depth depth))
                     (lambda () (wrapper execute))))
                  (width
                   (##fixnum.+ (indent depth) 1)))
             (##write-string " " out)
             (##write-string
              (##object->string
               result
               rt
               (##fixnum.- (##port-width out) width)
               (if-forces #t #f))
              out)
             (##newline out)
             result))

         (##write-string " > " out)
         (##write-string
          (##object->string
           form
           rt
           (##fixnum.- (##port-width out) width)
           (if-forces #t #f))
          out)
         (##newline out)
         (if leap?
           (cond ((##eq? ##non-tail-call-for-leap parent)
                  (execute))
                 ((##eq? ##non-tail-call-for-step parent)
                  (##non-tail-call-for-leap execute))
                 (else
                  (nest ##non-tail-call-for-leap)))
           (cond ((##eq? ##non-tail-call-for-leap parent)
                  (execute))
                 ((##eq? ##non-tail-call-for-step parent)
                  (execute))
                 (else
                  (nest ##non-tail-call-for-step)))))))))

(define ##non-tail-call-for-leap
  (let ()
    (##declare (not inline))
    (lambda (execute)
      (let ((result (execute)))
        (##step-on)
        result))))

(define ##non-tail-call-for-step
  (let ()
    (##declare (not inline))
    (lambda (execute)
      (##first-argument (execute)))))

(define ##trace-list '())

(define (##trace proc)

  (define (setup hook)
    (let ((settings (##closure-ref hook 1)))
      (##vector-set! settings 1 #t)
      (if (##not (##memq proc ##trace-list))
        (set! ##trace-list (##cons proc ##trace-list)))))

  (let ((hook (##interp-procedure-default-entry-hook proc)))
    (if hook
      (setup hook)
      (let ((new-hook (##make-default-entry-hook)))
        (##interp-procedure-entry-hook-set! proc new-hook)
        (setup new-hook)))))

(define (##untrace proc)
  (let ((hook (##interp-procedure-default-entry-hook proc)))
    (if hook
      (let ((settings (##closure-ref hook 1)))
        (##vector-set! settings 1 #f)
        (if (##not (##vector-ref settings 0))
          (##interp-procedure-entry-hook-set! proc #f))))
    (set! ##trace-list (##remove proc ##trace-list))))

(define (trace . args)
  (if (##pair? args)
    (##for-each-interp-procedure
     'trace
     args
     ##trace
     args)
    ##trace-list))

(define (untrace . args)
  (##for-each-interp-procedure
   'untrace
   args
   ##untrace
   (if (##pair? args) args ##trace-list)))

(define ##break-list '())

(define (##break proc)

  (define (setup hook)
    (let ((settings (##closure-ref hook 1)))
      (##vector-set! settings 0 #t)
      (if (##not (##memq proc ##break-list))
        (set! ##break-list (##cons proc ##break-list)))))

  (let ((hook (##interp-procedure-default-entry-hook proc)))
    (if hook
      (setup hook)
      (let ((new-hook (##make-default-entry-hook)))
        (##interp-procedure-entry-hook-set! proc new-hook)
        (setup new-hook)))))

(define (##unbreak proc)
  (let ((hook (##interp-procedure-default-entry-hook proc)))
    (if hook
      (let ((settings (##closure-ref hook 1)))
        (##vector-set! settings 0 #f)
        (if (##not (##vector-ref settings 1))
          (##interp-procedure-entry-hook-set! proc #f))))
    (set! ##break-list (##remove proc ##break-list))))

(define (break . args)
  (if (##pair? args)
    (##for-each-interp-procedure
     'break
     args
     ##break
     args)
    ##break-list))

(define (unbreak . args)
  (##for-each-interp-procedure
   'unbreak
   args
   ##unbreak
   (if (##pair? args) args ##break-list)))

(define ##step-on
  (let ()
    (##declare (not inline) (not interrupts-enabled))
    (lambda ()
      (let* ((stepper (##current-stepper))
             (handlers (##vector-ref stepper 0)))
        (let loop ((i (##vector-length handlers)))
          (if (##not (##fixnum.< i 1))
            (let ((i-1 (##fixnum.- i 1)))
              (##vector-set! stepper i (##vector-ref handlers i-1))
              (loop i-1))))
        (##void)))))

(define ##step-off
  (let ()
    (##declare (not inline) (not interrupts-enabled))
    (lambda ()
      (let* ((stepper (##current-stepper))
             (handlers (##vector-ref stepper 0)))
        (let loop ((i (##vector-length handlers)))
          (if (##not (##fixnum.< i 1))
            (let ((i-1 (##fixnum.- i 1)))
              (##vector-set! stepper i #f)
              (loop i-1))))
        (##void)))))

(define step ##step-on)

(define ##set-step-level!
  (let ()
    (##declare (not inline) (not interrupts-enabled))
    (lambda (n)
      (let* ((stepper (##current-stepper))
             (handlers (##vector-ref stepper 0)))
        (let loop ((i (##vector-length handlers)))
          (if (##not (##fixnum.< i 1))
            (let ((i-1 (##fixnum.- i 1)))
              (##vector-set! handlers i-1
                (if (##fixnum.< i-1 n)
                  (##vector-ref ##step-handlers i-1)
                  #f))
              (loop i-1))))
        (##void)))))

(define (set-step-level! n)
  (force-vars (n)
    (check-exact-int-range-incl n 0 7 (set-step-level! n)
      (##set-step-level! n))))

(define (set-proper-tail-calls! proper?)
  (set! ##proper-tail-calls? proper?)
  (##void))

(define ##display-environment? #f)
(set! ##display-environment? #f)

(define (set-display-environment! display?)
  (set! ##display-environment? display?)
  (##void))

(define ##step-handler
  (let ()
    (##declare (not inline) (not interrupts-enabled) (environment-map))
    (lambda (leapable? $code rte execute-body . other)
      (##step-off) ; turn off single-stepping
      (##step-handler-continue
        (##step-handler-get-command $code rte)
        leapable?
        $code
        rte
        execute-body
        other))))

(define (##step-handler-get-command $code rte)
  (##call-with-current-continuation
    (lambda (cont) (##sequentially (lambda ()
      (##identify-error
        "STOPPED"
        (##extract-container $code rte)
        (##code-locat $code)
        #f
        '()
        '())
      (##debug-repl cont #f))))))

(define (##step-handler-continue cmd leapable? $code rte execute-body other)

  ; cmd is one of the symbols: c, s or l

  (define (execute)
    (##apply execute-body (##cons $code (##cons rte other))))

  (cond ((##eq? cmd 'c)
         (execute))
        ((and (##eq? cmd 'l) leapable?)
         (##trace-generate (##decomp $code) execute #t))
        (else
         (##step-on)
         (##trace-generate (##decomp $code) execute #f))))

(define (##handle-user-interrupt)
  (##call-with-current-continuation
    (lambda (cont) (##sequentially (lambda ()
      (let ((f (##continuation->first-frame cont)))
        (##identify-error
         "INTERRUPTED"
         (##frame-creator f)
         (##frame-locat f)
         #f
         '()
         '())
         (let ((cmd (##debug-repl cont #f)))
           ; cmd is one of the symbols: c, s or l
           (if (##not (##eq? cmd 'c)) (##step-on))
           (##void))))))))

(define (##for-each-interp-procedure name args fn procs)
  (let loop ((lst1 procs) (lst2 '()))
    (if (##pair? lst1)
      (let ((proc (##car lst1)))
        (if (##procedure? proc)
          (if (##interp-procedure? proc)
            (loop (##cdr lst1)
                  (##cons proc lst2))
            (let ((id (##object->global-var->identifier proc)))
              (if id ; procedure is bound to a global variable
                (let ((out (##repl-out))
                      (rt (##repl-readtable)))
                  (##write-string
                   "*** WARNING -- Rebinding global variable \""
                   out)
                  (##write id out rt (if-forces #t #f))
                  (##write-string
                   "\" to an interpreted procedure"
                   out)
                  (##newline out)
                  (let ((new-proc
                         (##make-interp-procedure proc)))
                    (global-var-set! (make-global-var id) new-proc)
                    (loop (##cdr lst1)
                          (##cons new-proc lst2))))
                (##trap-check-interp-procedure* name args))))
          (##trap-check-interp-procedure* name args)))
      (begin
        (##for-each fn (##reverse lst2))
        (##void)))))

(define ##interp-procedure-wrapper
  (mk-cprc ; this "code procedure" is never actually called to evaluate code
   (letrec ((proc
             (lambda args

               (define (execute)
                 (let (($code $code)
                       (rte (mk-rte rte proc args)))
;;;*********                   (break-if-stepping-level>= 0)
                   (##apply (^ 1) args)))

               (let ((entry-hook (^ 0)))
                 (if entry-hook
                   (entry-hook
                    proc
                    args
                    (lambda () (execute)))
                   (execute))))))
     proc)))

(define (##make-interp-procedure proc)
  (let* ((cte
          (##cte-frame (##make-top-cte) (##cons (self-var) '(arguments))))
         (src
          #f)
         (stepper
          (##current-stepper))
         ($code
          (mk-code ##interp-procedure-wrapper cte src stepper () #f proc))
         (rte
          #f))
    (##interp-procedure-wrapper $code rte)))

(define (##remove elem lst)
  (let loop ((lst1 lst) (lst2 '()))
    (if (##pair? lst1)
      (let ((x (##car lst1)))
        (if (##eq? x elem)
          (##append (##reverse lst2) (##cdr lst1))
          (loop (##cdr lst1) (##cons x lst2))))
      lst)))

;==============================================================================
