package biss.jde;

import biss.VectorSorter;
import biss.awt.List;
import biss.awt.SelfDrawingObject;
import java.awt.Rectangle;
import java.io.*;
import java.util.*;

/**
 * model describing Java import
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class Import
  implements SelfDrawingObject
{
	static ImportSorter Sorter = new ImportSorter();
	String Spec;

Import ( String spec ) {
	Spec = spec;
}

static String allDefinitions ( Vector list ) {
	if ( (list == null) || (list.size() == 0) )
		return null;
	ByteArrayOutputStream o = new ByteArrayOutputStream( 300);
	PrintStream s = new PrintStream( o);
	for ( Enumeration e=list.elements(); e.hasMoreElements(); )
		((Import) e.nextElement()).printOn( s);
	return o.toString();
}

String definition () {
	return "import " + Spec;
}

public int  	drawHeight(){
	return DrawSupport.Cy;
}

public void 	drawSelfIn ( Object pane ){
	DrawSupport.drawImport( (List)pane, Spec);
}

public boolean equals ( Object other ) {
	Import imp = (Import) other;
	return ( imp != null && Spec.equals( imp.Spec));
}

public static String getTemplate () {
	return "import ";
}

public String label () {
	return Spec;
}

public int  	maxDrawWidth(){
	return DrawSupport.Cx * 50;
}

public void printOn ( PrintStream s ) {
	s.print( "import ");
	s.print( Spec);
	s.println( ';');
}
}

class ImportSorter
  implements VectorSorter
{

public int compare ( Object a, Object b ) {
	return ((Import)a).Spec.compareTo( ((Import)b).Spec);
}
}
